/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.word.docbook2word.AnchorWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.LinkWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.docbook2word.UlinkWriter;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Range;
import java.util.List;

public class SubTitleWriter {
    private static SubTitleWriter writer;

    public static SubTitleWriter getInstance() {
        if (writer == null) {
            writer = new SubTitleWriter();
        }
        return writer;
    }

    private SubTitleWriter() {
    }

    public void write(EOSubtitle subtitle, Paragraph subtitlePara, Document document, ProcessingContext processingContext) {
        Range range = subtitlePara.get_Range();
        range.set_End(range.get_End() - 1);
        List contentList = subtitle.getContent(processingContext.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                range.InsertAfter((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, range, processingContext);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, range, document, processingContext);
                continue;
            }
            if (!(obj instanceof EOUlink)) continue;
            UlinkWriter.getInstance().write((EOUlink)obj, range, processingContext);
        }
        range.dispose();
    }
}

