/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.writer.word.docbook2word.IWordDocumentationWriterTask;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ImageObjectWriter;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ProcessingContext {
    private static final ILogger logger = Logger.getLogger(ImageObjectWriter.class);
    private final ReportJob reportJob;
    private final PresentationContext presentationContext;
    private final Locale projectLocale;
    private final List<IWordDocumentationWriterTask> postProcessingTasks = new ArrayList<IWordDocumentationWriterTask>();
    private final List<IWordDocumentationWriterTask> cleanUpTasks = new ArrayList<IWordDocumentationWriterTask>();

    public ProcessingContext(PresentationContext presentationContext, Locale projectLocale, ReportJob reportJob) {
        this.presentationContext = presentationContext;
        this.projectLocale = projectLocale;
        this.reportJob = reportJob;
    }

    public ReportJob getReportJob() {
        return this.reportJob;
    }

    public PresentationContext getPresentationContext() {
        return this.presentationContext;
    }

    public Locale getProjectLocale() {
        return this.projectLocale;
    }

    public void addPostProcessingTask(IWordDocumentationWriterTask postProcessingTaks) {
        this.postProcessingTasks.add(postProcessingTaks);
    }

    public void performPostProcessingTasks() {
        for (IWordDocumentationWriterTask postProcessingTask : this.postProcessingTasks) {
            postProcessingTask.run();
        }
    }

    public void addCleanUpTask(IWordDocumentationWriterTask postProcessingTaks) {
        this.cleanUpTasks.add(postProcessingTaks);
    }

    public void performCleanUpTasks() {
        for (IWordDocumentationWriterTask cleanUpTask : this.cleanUpTasks) {
            try {
                cleanUpTask.run();
            }
            catch (Throwable t) {
                logger.warn("Error while executing a clean up task.", t);
            }
        }
    }
}

