/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEmphasis;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPhrase;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.word.StyleMap;
import com.arcway.cockpit.docgen.writer.word.docbook2word.AnchorWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.BreakType;
import com.arcway.cockpit.docgen.writer.word.docbook2word.BreakTypeParameter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.EmphasisWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.LinkWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.MediaObjectWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.PhraseWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TableWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.UlinkWriter;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.HeaderFooter;
import com.arcway.lib.eclipse.ole.word.HeadersFooters;
import com.arcway.lib.eclipse.ole.word.PageNumbers;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.eclipse.ole.word.Section;
import com.arcway.lib.eclipse.ole.word.Sections;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.List;

public class ParagraphWriter {
    private static final ILogger logger = Logger.getLogger(ParagraphWriter.class);
    private static ParagraphWriter writer;

    public static ParagraphWriter getInstance() {
        if (writer == null) {
            writer = new ParagraphWriter();
        }
        return writer;
    }

    private ParagraphWriter() {
    }

    public void write(EOPara para, Paragraph paraPara, Document document, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        String role = para.getRole();
        ParagraphWriter.addOptionalPageBreak(paraPara, role, processingContext);
        styleMap.applyParagraphStyle(paraPara, role);
        List contentList = para.getContent(processingContext.getReportJob());
        Range range = paraPara.get_Range();
        range.set_End(range.get_End() - 1);
        if (logger.isDebugEnabled(150)) {
            logger.debug(150, "[write paragraph] got  range object ");
        }
        for (Object obj : contentList) {
            Range nextRange;
            if (obj instanceof String) {
                range.InsertAfter((String)obj);
                if (!logger.isDebugEnabled(150)) continue;
                logger.debug(150, "[write paragraph] inserted text " + (String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, range, processingContext);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, range, document, processingContext);
                continue;
            }
            if (obj instanceof EOUlink) {
                UlinkWriter.getInstance().write((EOUlink)obj, range, processingContext);
                continue;
            }
            if (obj instanceof EOMediaObject) {
                MediaObjectWriter.getInstance().write((EOMediaObject)obj, range, graphicsAndFilesStore, processingContext);
                continue;
            }
            if (obj instanceof EOSimpleList) {
                SimpleListWriter.getInstance().write((EOSimpleList)obj, range, document, processingContext);
                continue;
            }
            if (obj instanceof EOTable) {
                TableWriter.getInstance().write((EOTable)obj, range, document, styleMap, graphicsAndFilesStore, processingContext);
                continue;
            }
            if (obj instanceof EOEmphasis) {
                nextRange = EmphasisWriter.getInstance().write((EOEmphasis)obj, range, document, styleMap, processingContext);
                range.dispose();
                range = nextRange;
                continue;
            }
            if (!(obj instanceof EOPhrase)) continue;
            nextRange = PhraseWriter.getInstance().write((EOPhrase)obj, range, document, processingContext);
            range.dispose();
            range = nextRange;
        }
        range.dispose();
    }

    public static void addOptionalPageBreak(Paragraph para, String role, ProcessingContext processingContext) {
        BreakType breakType = BreakTypeParameter.getBreakType(processingContext, role);
        ParagraphWriter.addPageBreak(para, breakType);
    }

    public static void addPageBreak(Paragraph para, BreakType breakType) {
        if (breakType != BreakType.noBreak) {
            Range paraRange2 = para.get_Range();
            ParagraphWriter.addPageBreak(paraRange2, breakType);
            paraRange2.dispose();
        }
    }

    public static void addPageBreak(Range range, BreakType breakType) {
        if (breakType != BreakType.noBreak) {
            boolean isSectionBreak;
            int sectionBreakType = 0;
            switch (breakType) {
                case sectionBreakToOddPage: {
                    sectionBreakType = 5;
                    isSectionBreak = true;
                    break;
                }
                case sectionBreakToEvenPage: {
                    sectionBreakType = 4;
                    isSectionBreak = true;
                    break;
                }
                case sectionBreakToNextPage: {
                    sectionBreakType = 2;
                    isSectionBreak = true;
                    break;
                }
                case sectionBreakContinuous: {
                    sectionBreakType = 3;
                    isSectionBreak = true;
                    break;
                }
                case pageBreak: {
                    sectionBreakType = 7;
                    isSectionBreak = false;
                    break;
                }
                case noBreak: {
                    isSectionBreak = false;
                    break;
                }
                default: {
                    isSectionBreak = false;
                }
            }
            range.InsertBreak((Object)sectionBreakType);
            if (isSectionBreak) {
                Sections sections = range.get_Sections();
                int is = 1;
                while (is <= sections.get_Count()) {
                    Section section = sections.Item(is);
                    HeadersFooters headersFooters = section.get_Headers();
                    int ih = 1;
                    while (ih < headersFooters.get_Count()) {
                        HeaderFooter headerFooter = headersFooters.Item(ih);
                        PageNumbers pageNumbers = headerFooter.get_PageNumbers();
                        if (!pageNumbers.get_IncludeChapterNumber() && pageNumbers.get_RestartNumberingAtSection()) {
                            pageNumbers.set_RestartNumberingAtSection(false);
                        }
                        pageNumbers.dispose();
                        headerFooter.dispose();
                        ++ih;
                    }
                    headersFooters.dispose();
                    section.dispose();
                    ++is;
                }
                sections.dispose();
            }
        }
    }
}

