/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOObjectInfo;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ImageObjectWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Range;
import java.util.List;

public class MediaObjectWriter {
    private static MediaObjectWriter writer;

    public static MediaObjectWriter getInstance() {
        if (writer == null) {
            writer = new MediaObjectWriter();
        }
        return writer;
    }

    private MediaObjectWriter() {
    }

    public void write(EOMediaObject mediaObject, Paragraph para, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        Range range = para.get_Range();
        range.set_End(range.get_End() - 1);
        this.write(mediaObject, range, graphicsAndFilesStore, processingContext);
        range.dispose();
    }

    public void write(EOMediaObject mediaObject, Range range, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        List mediaObjects = mediaObject.getContent();
        for (Object obj : mediaObjects) {
            if (!(obj instanceof EOImageObject)) continue;
            EOImageObject imageObject = (EOImageObject)obj;
            EOObjectInfo objectInfo = mediaObject.getObjectInfo();
            String originalFileName = objectInfo != null ? objectInfo.getTitle() : null;
            ImageObjectWriter.getInstance().write(imageObject, range, originalFileName, graphicsAndFilesStore, processingContext);
        }
    }
}

