/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageData;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageObject;
import com.arcway.cockpit.docgen.writer.word.Messages;
import com.arcway.cockpit.docgen.writer.word.docbook2word.IWordDocumentationWriterTask;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.preferences.WordReportsPreferences;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.ole.word.InlineShape;
import com.arcway.lib.eclipse.ole.word.InlineShapes;
import com.arcway.lib.eclipse.ole.word.PageSetup;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.eclipse.ole.word.util.MSWordVersionAndSettingsHelper;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.program.Program;

public class ImageObjectWriter {
    private static final ILogger logger = Logger.getLogger(ImageObjectWriter.class);
    private static ImageObjectWriter writer;
    private static Set<String> imageFileTypes;
    private static Set<String> insertableFileTypes;
    private static Set<String> forceIconFileTypes;
    private static final String OLE_APPLICATION_ID = "unknown";

    static {
        imageFileTypes = new HashSet<String>();
        insertableFileTypes = new HashSet<String>();
        forceIconFileTypes = new HashSet<String>();
    }

    public static ImageObjectWriter getInstance() {
        if (writer == null) {
            writer = new ImageObjectWriter();
        }
        return writer;
    }

    private ImageObjectWriter() {
        imageFileTypes.add("PNG");
        imageFileTypes.add("GIF");
        imageFileTypes.add("JPG");
        imageFileTypes.add("JPEG");
        imageFileTypes.add("BMP");
        imageFileTypes.add("WMF");
        imageFileTypes.add("EMF");
        insertableFileTypes.add("DOC");
        if (MSWordVersionAndSettingsHelper.getInstalledVersionOfMSWord() >= 12) {
            insertableFileTypes.add("DOCX");
        }
        forceIconFileTypes.add("PDF");
    }

    public void write(EOImageObject imageObject, Paragraph para, String displayName, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        assert (imageObject != null) : "image object is null";
        assert (para != null) : "paragraph object is null";
        Range range = para.get_Range();
        range.set_End(range.get_End() - 1);
        this.write(imageObject, range, displayName, graphicsAndFilesStore, processingContext);
        range.dispose();
    }

    public void write(EOImageObject imageObject, Range range, String displayName, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        assert (imageObject != null) : "image object is null";
        assert (range != null) : "range object is null";
        EOImageData imageData = imageObject.getImageData();
        String graphicOrFileName = imageData.getFileReference();
        double contentHeight = imageData.getDepth();
        double contentWidth = imageData.getWidth();
        String fileType = imageData.getFormat();
        File graphicOrFile = graphicsAndFilesStore.getGraphicOrFileObjectFile(graphicOrFileName);
        if (graphicOrFile == null) {
            throw new ReportGenerationException(Messages.getString("ImageObjectWriter.GraphicOrFileUnavailable.Title"), String.valueOf(Messages.getString("ImageObjectWriter.GraphicOrFileUnavailable.Message")) + " (" + graphicOrFileName + ")", null);
        }
        if (fileType != null) {
            boolean directlyInsertWordFiles = WordReportsPreferences.getWordFileEmbeddingMode().equals("WordEmbeddingMode_Inline");
            boolean forceAsIcon = forceIconFileTypes.contains(fileType.toUpperCase());
            if (!forceAsIcon && imageFileTypes.contains(fileType.toUpperCase())) {
                ImageObjectWriter.insertAsImage(range, graphicOrFile, graphicOrFileName, contentWidth, contentHeight);
            } else if (!forceAsIcon && directlyInsertWordFiles && insertableFileTypes.contains(fileType.toUpperCase())) {
                try {
                    ImageObjectWriter.insertWordDocumentDirectly(range, graphicOrFile, graphicOrFileName);
                }
                catch (SWTException swtE) {
                    logger.warn("Could not insert Word document directly into Word report: " + graphicOrFileName + " (inserting as OLE object instead)");
                    ReportJob reportJob = processingContext.getReportJob();
                    reportJob.addUserWarningMessage(NLS.bind((String)Messages.getString("ImageObjectWriter.DirectInsertionOfWordDocumentFailed.Problem"), (Object)graphicOrFileName), Messages.getString("ImageObjectWriter.DirectInsertionOfWordDocumentFailed.Reason"));
                    ImageObjectWriter.insertAsOLEObject(range, graphicOrFile, graphicOrFileName, displayName, contentWidth, contentHeight, processingContext);
                }
            } else {
                ImageObjectWriter.insertAsOLEObject(range, graphicOrFile, graphicOrFileName, displayName, contentWidth, contentHeight, processingContext);
            }
        }
    }

    public void write_original(EOImageObject imageObject, Range range, String displayName, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        assert (imageObject != null) : "image object is null";
        assert (range != null) : "range object is null";
        EOImageData imageData = imageObject.getImageData();
        String graphicOrFileName = imageData.getFileReference();
        double contentHeight = imageData.getDepth();
        double contentWidth = imageData.getWidth();
        String fileType = imageData.getFormat();
        File graphicOrFile = graphicsAndFilesStore.getGraphicOrFileObjectFile(graphicOrFileName);
        if (graphicOrFile == null) {
            throw new ReportGenerationException(Messages.getString("ImageObjectWriter.GraphicOrFileUnavailable.Title"), String.valueOf(Messages.getString("ImageObjectWriter.GraphicOrFileUnavailable.Message")) + " (" + graphicOrFileName + ")", null);
        }
        if (fileType != null) {
            boolean directlyInsertWordFiles = WordReportsPreferences.getWordFileEmbeddingMode().equals("WordEmbeddingMode_Inline");
            if (imageFileTypes.contains(fileType.toUpperCase())) {
                ImageObjectWriter.insertAsImage(range, graphicOrFile, graphicOrFileName, contentWidth, contentHeight);
            } else if (directlyInsertWordFiles && insertableFileTypes.contains(fileType.toUpperCase())) {
                try {
                    ImageObjectWriter.insertWordDocumentDirectly(range, graphicOrFile, graphicOrFileName);
                }
                catch (SWTException swtE) {
                    logger.warn("Could not insert Word document directly into Word report: " + graphicOrFileName + " (inserting as OLE object instead)");
                    ReportJob reportJob = processingContext.getReportJob();
                    reportJob.addUserWarningMessage(NLS.bind((String)Messages.getString("ImageObjectWriter.DirectInsertionOfWordDocumentFailed.Problem"), (Object)graphicOrFileName), Messages.getString("ImageObjectWriter.DirectInsertionOfWordDocumentFailed.Reason"));
                    ImageObjectWriter.insertAsOLEObjectWithUnknownApplication(range, graphicOrFile, graphicOrFileName, displayName, processingContext);
                }
            } else {
                ImageObjectWriter.insertAsOLEObject_original(range, graphicOrFile, graphicOrFileName, displayName, contentWidth, contentHeight, processingContext);
            }
        }
    }

    private static final void insertAsImage(Range range, File graphicOrFile, String graphicOrFileName, double contentWidth, double contentHeight) {
        Boolean linkToFile = false;
        Boolean saveWithDocument = true;
        InlineShapes inlineShapes = range.get_InlineShapes();
        InlineShape imageShape = inlineShapes.AddPicture(graphicOrFile.getAbsolutePath(), (Object)linkToFile, (Object)saveWithDocument);
        inlineShapes.dispose();
        float height = (float)(contentHeight / 25.4 * 72.0);
        float width = (float)(contentWidth / 25.4 * 72.0);
        if (height > 0.0f) {
            imageShape.set_Height(height);
        }
        if (width > 0.0f) {
            imageShape.set_Width(width);
        }
        imageShape.dispose();
        if (logger.isDebugEnabled()) {
            logger.debug("write() - Graphic file inserted  : filename=" + graphicOrFileName + ", height=" + height + ", width=" + width);
        }
    }

    private static final void insertAsOLEObject(Range range, File graphicOrFile, String graphicOrFileName, String displayName, double contentWidth, double contentHeight, ProcessingContext processingContext) {
        String pathFinal;
        String path = graphicOrFile.getAbsolutePath();
        String extension = FileHelper.getFileExtension((String)path);
        boolean copyWithShortPathCreated = false;
        if (path.length() >= 200) {
            try {
                SessionTempDirectoryManager.SessionTempDirectory directory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"spt");
                File shortPathFile = new File((File)directory, "f" + (extension.length() > 0 ? "." + extension : ""));
                DataCopyHelper.copyFile((File)graphicOrFile, (File)shortPathFile);
                copyWithShortPathCreated = true;
                path = shortPathFile.getAbsolutePath();
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                logger.warn("Could not create temporary directory (prefix = \"sp\"", (Throwable)jeriE);
            }
        }
        String iconFileName = null;
        boolean iconFileCreated = false;
        ImageData imageData = null;
        Program program = Program.findProgram((String)extension);
        if (program != null) {
            imageData = program.getImageData();
        }
        if (imageData == null) {
            imageData = Icons.getDefaultFileImageDescriptor().getImageData();
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        try {
            SessionTempDirectoryManager.SessionTempDirectory directory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"icf");
            File iconFile = new File((File)directory, "icon.bmp");
            iconFileName = iconFile.getAbsolutePath();
            loader.save(iconFileName, 0);
            iconFileCreated = true;
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.warn("Could not create temporary directory (prefix = \"sp\"", (Throwable)jeriE);
        }
        InlineShapes inlineShapes = range.get_InlineShapes();
        InlineShape shape1 = inlineShapes.AddOLEObject((Object)OLE_APPLICATION_ID, (Object)path, (Object)Boolean.FALSE, (Object)Boolean.TRUE, (Object)iconFileName, (Object)0, (Object)displayName);
        inlineShapes.dispose();
        if (shape1 != null) {
            shape1.dispose();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("write() - OLE object NOT inserted (addOLEObject() returned null) : filename=" + graphicOrFileName);
            }
            ReportJob reportJob = processingContext.getReportJob();
            reportJob.addUserWarningMessage(NLS.bind((String)Messages.getString("ImageObjectWriter.ErrorWhileEmbeddingWordObject.Problem"), (Object)graphicOrFileName), Messages.getString("ImageObjectWriter.ErrorWhileEmbeddingWordObject.Reason"));
        }
        if (copyWithShortPathCreated) {
            pathFinal = path;
            processingContext.addCleanUpTask(new IWordDocumentationWriterTask(){

                @Override
                public void run() {
                    try {
                        FileHelper.deleteFileOrDirectory((File)new File(pathFinal).getParentFile());
                    }
                    catch (JvmExternalResourceInteractionException feriE) {
                        logger.warn("Could not delete temp file plus directory: " + pathFinal, (Throwable)feriE);
                    }
                }
            });
        }
        if (iconFileCreated) {
            pathFinal = iconFileName;
            processingContext.addCleanUpTask(new IWordDocumentationWriterTask(){

                @Override
                public void run() {
                    try {
                        FileHelper.deleteFileOrDirectory((File)new File(pathFinal).getParentFile());
                    }
                    catch (JvmExternalResourceInteractionException feriE) {
                        logger.warn("Could not delete temp file plus directory: " + pathFinal, (Throwable)feriE);
                    }
                }
            });
        }
    }

    private static final void insertAsOLEObject_original(Range range, File graphicOrFile, String graphicOrFileName, String displayName, double contentWidth, double contentHeight, ProcessingContext processingContext) {
        String path = graphicOrFile.getAbsolutePath();
        boolean copyWithShortPathCreated = false;
        if (path.length() >= 200) {
            try {
                SessionTempDirectoryManager.SessionTempDirectory directory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"spt");
                String extension = FileHelper.getFileExtension((String)path);
                File shortPathFile = new File((File)directory, "f" + (extension.length() > 0 ? "." + extension : ""));
                DataCopyHelper.copyFile((File)graphicOrFile, (File)shortPathFile);
                copyWithShortPathCreated = true;
                path = shortPathFile.getAbsolutePath();
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                logger.warn("Could not create temporary directory (prefix = \"sp\"", (Throwable)jeriE);
            }
        }
        InlineShapes inlineShapes = range.get_InlineShapes();
        InlineShape shape1 = inlineShapes.AddOLEObject((Object)OLE_APPLICATION_ID, (Object)path);
        inlineShapes.dispose();
        if (shape1 != null) {
            boolean isIconOnly;
            boolean bl = isIconOnly = shape1.get_OLEFormat().get_DisplayAsIcon() || shape1.get_OLEFormat().get_ProgID().equals("Package");
            if (isIconOnly) {
                shape1.Delete();
                ImageObjectWriter.insertAsOLEObjectWithUnknownApplication(range, graphicOrFile, graphicOrFileName, displayName, processingContext);
            } else {
                float height = (float)(contentHeight / 25.4 * 72.0);
                float width = (float)(contentWidth / 25.4 * 72.0);
                if (height > 0.0f) {
                    shape1.set_Height(height);
                }
                if (width > 0.0f) {
                    shape1.set_Width(width);
                } else {
                    PageSetup pageSetup = range.get_PageSetup();
                    float pageWith = pageSetup.get_PageWidth();
                    float leftMargin = pageSetup.get_LeftMargin();
                    float rightMargin = pageSetup.get_RightMargin();
                    shape1.set_Width(pageWith - leftMargin - rightMargin);
                    pageSetup.dispose();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("write() - OLE object inserted : filename=" + graphicOrFileName);
                }
            }
            shape1.dispose();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("write() - OLE object NOT inserted (addOLEObject() returned null) : filename=" + graphicOrFileName);
            }
            ReportJob reportJob = processingContext.getReportJob();
            reportJob.addUserWarningMessage(NLS.bind((String)Messages.getString("ImageObjectWriter.ErrorWhileEmbeddingWordObject.Problem"), (Object)graphicOrFileName), Messages.getString("ImageObjectWriter.ErrorWhileEmbeddingWordObject.Reason"));
        }
        if (copyWithShortPathCreated) {
            final String pathFinal = path;
            processingContext.addCleanUpTask(new IWordDocumentationWriterTask(){

                @Override
                public void run() {
                    try {
                        FileHelper.deleteFileOrDirectory((File)new File(pathFinal).getParentFile());
                    }
                    catch (JvmExternalResourceInteractionException feriE) {
                        logger.warn("Could not delete temp file plus directory: " + pathFinal, (Throwable)feriE);
                    }
                }
            });
        }
    }

    private static final void insertWordDocumentDirectly(Range range, File graphicOrFile, String graphicOrFileName) throws SWTException {
        range.InsertFile(graphicOrFile.getAbsolutePath());
        if (logger.isDebugEnabled()) {
            logger.debug("write() - File inserted directly : filename=" + graphicOrFileName);
        }
    }

    private static final void insertAsOLEObjectWithUnknownApplication(Range range, File graphicOrFile, String graphicOrFileName, String displayName, ProcessingContext processingContext) throws SWTException {
        String sourceFileName;
        SessionTempDirectoryManager.SessionTempDirectory tmpFolder;
        try {
            tmpFolder = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"winwordreport");
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("Could not create temp folder to get file with original file name", (Throwable)e);
            tmpFolder = null;
        }
        if (tmpFolder != null) {
            File tmpFileWithOriginalFileName = new File((File)tmpFolder, displayName);
            try {
                DataCopyHelper.copyFile((File)graphicOrFile, (File)tmpFileWithOriginalFileName);
                sourceFileName = tmpFileWithOriginalFileName.getAbsolutePath();
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error("Could not copy file to get file with original file name", (Throwable)e);
                sourceFileName = graphicOrFile.getAbsolutePath();
            }
        } else {
            sourceFileName = graphicOrFile.getAbsolutePath();
        }
        InlineShapes inlineShapes = range.get_InlineShapes();
        InlineShape shape1 = inlineShapes.AddOLEObject((Object)OLE_APPLICATION_ID, (Object)sourceFileName);
        inlineShapes.dispose();
        if (shape1 != null) {
            if (displayName != null && displayName.length() > 0) {
                shape1.set_AlternativeText(displayName);
            }
            shape1.dispose();
        }
        if (tmpFolder != null) {
            final SessionTempDirectoryManager.SessionTempDirectory tmpFolderFinal = tmpFolder;
            processingContext.addCleanUpTask(new IWordDocumentationWriterTask(){

                @Override
                public void run() {
                    try {
                        FileHelper.deleteExistingFileOrDirectory((File)tmpFolderFinal);
                    }
                    catch (JvmExternalResourceInteractionException e) {
                        logger.error("Could not delete temp folder which had been created to get file with original file name", (Throwable)e);
                    }
                }
            });
        }
        if (logger.isDebugEnabled()) {
            logger.debug("write() - Unknown OLE object inserted : filename=" + graphicOrFileName);
        }
    }
}

