/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import au.com.swz.swttocom.swt.types.AutomationObjectImpl;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.DocBookAnalyzer;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBiblioID;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBiblioMisc;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBook;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBookInfo;
import com.arcway.cockpit.docgen.writer.docbook.model.EOChapter;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCopyright;
import com.arcway.cockpit.docgen.writer.docbook.model.EODate;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEdition;
import com.arcway.cockpit.docgen.writer.docbook.model.EOIssueNum;
import com.arcway.cockpit.docgen.writer.docbook.model.EOOrgName;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPreface;
import com.arcway.cockpit.docgen.writer.docbook.model.EOProductName;
import com.arcway.cockpit.docgen.writer.docbook.model.EOProductNumber;
import com.arcway.cockpit.docgen.writer.docbook.model.EOReleaseInfo;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitleAbbrev;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.ReportTemplateHeaders;
import com.arcway.cockpit.docgen.writer.word.StyleMap;
import com.arcway.cockpit.docgen.writer.word.docbook2word.BreakType;
import com.arcway.cockpit.docgen.writer.word.docbook2word.BreakTypeParameter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ChapterWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.PrefaceWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TableWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TitleWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.WriterUtil;
import com.arcway.cockpit.docgen.writer.word.preferences.WordReportsPreferences;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.lib.eclipse.ole.office.DocumentProperties;
import com.arcway.lib.eclipse.ole.office.DocumentProperty;
import com.arcway.lib.eclipse.ole.office.impl.DocumentPropertiesImpl;
import com.arcway.lib.eclipse.ole.office.impl.DocumentPropertyImpl;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Paragraphs;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.ole.win32.Variant;

public class DocumentWriter {
    public static final String TEMPLATE_HEADER_JUMP_TO_EXISTING_ANCHORS = "jumpToExistingAnchors";
    private static DocumentWriter writer = null;

    public static DocumentWriter getInstance() {
        if (writer == null) {
            writer = new DocumentWriter();
        }
        return writer;
    }

    private DocumentWriter() {
    }

    public Map<String, String> writeWordDocument(EOBook docBook, Document wordDocument, GraphicsAndFilesStore graphicsAndFilesStore, IProgressMonitor progressMonitor, ProcessingContext processingContext, ReportJob reportJob) throws ReportGenerationException, ReportGenerationCanceledException {
        DocBookAnalyzer analyzer = new DocBookAnalyzer();
        DocBookPostProcessingProgress progress = new DocBookPostProcessingProgress(progressMonitor, analyzer.countChaptersAndSections(docBook));
        StyleMap styleMap = new StyleMap(wordDocument);
        progress.checkCancelState();
        DocumentPropertiesImpl buildInDocumentProperties = new DocumentPropertiesImpl(((AutomationObjectImpl)wordDocument.get_BuiltInDocumentProperties()).getOleAutomation(), wordDocument.getResourceManager());
        DocumentPropertiesImpl customDocumentProperties = new DocumentPropertiesImpl(((AutomationObjectImpl)wordDocument.get_CustomDocumentProperties()).getOleAutomation(), wordDocument.getResourceManager());
        DocumentWriter.writeDocumentProperties(docBook, (DocumentProperties)buildInDocumentProperties, (DocumentProperties)customDocumentProperties);
        Map<String, String> customDocumentProperites = DocumentWriter.readCustomDocumentProperties((DocumentProperties)customDocumentProperties);
        customDocumentProperties.dispose();
        buildInDocumentProperties.dispose();
        ArrayList<BreakTypeParameter> generatorSpecificParameters = new ArrayList<BreakTypeParameter>();
        BreakTypeParameter breakTypeParameter = new BreakTypeParameter(customDocumentProperites);
        generatorSpecificParameters.add(breakTypeParameter);
        reportJob.setGeneratorSpecificParameters(generatorSpecificParameters);
        progress.checkCancelState();
        DocumentWriter.writeTitleAndSubtitleAndParagraphsBeforeFirstChapter(docBook, wordDocument, styleMap, graphicsAndFilesStore, processingContext, reportJob, customDocumentProperites);
        progress.checkCancelState();
        boolean anythingBeforeFirstChapter = DocumentWriter.doesDocumentContainAnything(wordDocument);
        boolean jumpToExistingAnchors = DocumentWriter.isJumpToExistingAnchors(processingContext);
        boolean isFirst = true;
        ArrayList contentList = new ArrayList(docBook.getContent());
        for (Object contentItem : contentList) {
            if (contentItem instanceof EOChapter) {
                BreakType breakBeforeChapter;
                String configuredBreakType;
                if (isFirst) {
                    if (anythingBeforeFirstChapter) {
                        if (jumpToExistingAnchors) {
                            WriterUtil.jumpAtEndOfDocument(wordDocument);
                        }
                        if ((configuredBreakType = customDocumentProperites.get("PageBreakBeforeFirstChapter")) == null) {
                            configuredBreakType = WordReportsPreferences.getPageBreakBeforeFirstChapter();
                        }
                        breakBeforeChapter = configuredBreakType.equals("PageBreak_None") ? BreakType.noBreak : (configuredBreakType.equals("PageBreak_NextPage") ? BreakType.sectionBreakToNextPage : (configuredBreakType.equals("PageBreak_OddPage") ? BreakType.sectionBreakToOddPage : (configuredBreakType.equals("PageBreak_EvenPage") ? BreakType.sectionBreakToEvenPage : BreakType.pageBreak)));
                    } else {
                        breakBeforeChapter = BreakType.noBreak;
                    }
                } else {
                    configuredBreakType = customDocumentProperites.get("PageBreakBeforeOtherChapters");
                    if (configuredBreakType == null) {
                        configuredBreakType = WordReportsPreferences.getPageBreakBeforeOtherChapters();
                    }
                    breakBeforeChapter = configuredBreakType.equals("PageBreak_None") ? BreakType.noBreak : (configuredBreakType.equals("PageBreak_OddPage") ? BreakType.sectionBreakToOddPage : (configuredBreakType.equals("PageBreak_NextPage") ? BreakType.sectionBreakToNextPage : (configuredBreakType.equals("PageBreak_EvenPage") ? BreakType.sectionBreakToEvenPage : BreakType.pageBreak)));
                }
                ChapterWriter.getInstance().write((EOChapter)contentItem, breakBeforeChapter, wordDocument, styleMap, graphicsAndFilesStore, progress, processingContext);
                isFirst = false;
            }
            progress.checkCancelState();
        }
        return customDocumentProperites;
    }

    public static boolean isJumpToExistingAnchors(ProcessingContext processingContext) {
        ReportJob reportJob = processingContext.getReportJob();
        return ReportTemplateHeaders.isHeaderParameterTrue((Map)reportJob.getReportTemplateHeader(), (String)TEMPLATE_HEADER_JUMP_TO_EXISTING_ANCHORS);
    }

    private static Map<String, String> readCustomDocumentProperties(DocumentProperties customDocProps) {
        HashMap<String, String> customDocumentPropertiesAsString = new HashMap<String, String>();
        Enumeration customDocPropsEnumeration = customDocProps.elements();
        while (customDocPropsEnumeration.hasMoreElements()) {
            DocumentPropertyImpl property = new DocumentPropertyImpl((Variant)customDocPropsEnumeration.nextElement(), customDocProps.getResourceManager());
            String propertyName = property.get_Name();
            if (propertyName != null && propertyName.length() > 0) {
                String value = property.get_Value().getString();
                customDocumentPropertiesAsString.put(propertyName, value);
            }
            property.dispose();
        }
        return customDocumentPropertiesAsString;
    }

    private static void writeDocumentProperties(EOBook docBook, DocumentProperties builtInDocProps, DocumentProperties customDocProps) {
        EOBookInfo bookInfo = docBook.getBookInfo();
        if (builtInDocProps != null) {
            EOTitle title = null;
            if (bookInfo != null) {
                title = bookInfo.getTitle();
            }
            if (title == null) {
                title = docBook.getTitle();
            }
            String titleAsString = title != null ? title.getContentAsString() : null;
            EOSubtitle subtitle = null;
            if (bookInfo != null) {
                subtitle = bookInfo.getSubtitle();
            }
            if (subtitle == null) {
                subtitle = docBook.getSubtitle();
            }
            String subtitleAsString = subtitle != null ? subtitle.getContentAsString() : null;
            Enumeration docPropsEnumeration = builtInDocProps.elements();
            while (docPropsEnumeration.hasMoreElements()) {
                DocumentPropertyImpl property = new DocumentPropertyImpl((Variant)docPropsEnumeration.nextElement(), builtInDocProps.getResourceManager());
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "Title", titleAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "Subject", subtitleAsString);
                property.dispose();
            }
        }
        if (customDocProps != null) {
            EOReleaseInfo releaseInfo;
            EOOrgName orgName;
            EOCopyright copyright;
            EOBiblioMisc biblioMisc;
            EOEdition edition;
            EOProductNumber productNumber;
            EOProductName productName;
            EOBiblioID biblioID;
            EOIssueNum issueNum;
            EODate date;
            EOTitleAbbrev titleAbbrev = null;
            if (bookInfo != null) {
                titleAbbrev = bookInfo.getTitleAbbrev();
            }
            if (titleAbbrev == null) {
                titleAbbrev = docBook.getTitleAbbrev();
            }
            String titleAbbreviationAsString = titleAbbrev != null ? titleAbbrev.getContentAsString() : null;
            String documentDateAsString = bookInfo != null ? ((date = bookInfo.getDate()) != null ? date.getContentAsString() : null) : null;
            String documentIssueNumAsString = bookInfo != null ? ((issueNum = bookInfo.getIssueNum()) != null ? issueNum.getContentAsString() : null) : null;
            String documentBiblioIDAsString = bookInfo != null ? ((biblioID = bookInfo.getBiblioID()) != null ? biblioID.getContentAsString() : null) : null;
            String documentProductNameAsString = bookInfo != null ? ((productName = bookInfo.getProductName()) != null ? productName.getContentAsString() : null) : null;
            String documentProductNumberAsString = bookInfo != null ? ((productNumber = bookInfo.getProductNumber()) != null ? productNumber.getContentAsString() : null) : null;
            String documentEditionAsString = bookInfo != null ? ((edition = bookInfo.getEditon()) != null ? edition.getContentAsString() : null) : null;
            String documentBiblioMiscAsString = bookInfo != null ? ((biblioMisc = bookInfo.getBiblioMisc()) != null ? biblioMisc.getContentAsString() : null) : null;
            String documentCopyrightAsString = bookInfo != null ? ((copyright = bookInfo.getCopyright()) != null ? copyright.getContentAsString() : null) : null;
            String documentOrgNameAsString = bookInfo != null ? ((orgName = bookInfo.getOrgName()) != null ? orgName.getContentAsString() : null) : null;
            String status = docBook.getStatus();
            String documentStatusAsString = status != null ? status : null;
            String documentReleaseInfoAsString = bookInfo != null ? ((releaseInfo = bookInfo.getReleaseInfo()) != null ? releaseInfo.getContentAsString() : null) : null;
            Map<String, String> keyValuePairs = DocumentWriter.analyzeKeyValuePairsProperty(documentBiblioMiscAsString);
            Enumeration customDocPropsEnumeration = customDocProps.elements();
            while (customDocPropsEnumeration.hasMoreElements()) {
                DocumentPropertyImpl property = new DocumentPropertyImpl((Variant)customDocPropsEnumeration.nextElement(), customDocProps.getResourceManager());
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "TitleAbbrev", titleAbbreviationAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "Date", documentDateAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "IssueNum", documentIssueNumAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "BiblioID", documentBiblioIDAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "ProductName", documentProductNameAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "ProductNumber", documentProductNumberAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "Edition", documentEditionAsString);
                if (keyValuePairs.isEmpty()) {
                    String cleared = documentBiblioMiscAsString == null ? null : EOCommonObject.removeTabAndNewlineChars((String)documentBiblioMiscAsString);
                    DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "BiblioMisc", cleared);
                }
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "Copyright", documentCopyrightAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "OrgName", documentOrgNameAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "Status", documentStatusAsString);
                DocumentWriter.setPropertyIfMatching((DocumentProperty)property, "ReleaseInfo", documentReleaseInfoAsString);
                for (Map.Entry<String, String> keyValuePair : keyValuePairs.entrySet()) {
                    String key = keyValuePair.getKey();
                    String value = keyValuePair.getValue();
                    DocumentWriter.setPropertyIfMatching((DocumentProperty)property, key, value);
                }
                property.dispose();
            }
        }
    }

    private static Map<String, String> analyzeKeyValuePairsProperty(String keyValuePairsAsString) {
        HashMap<String, String> keyValuePairsAnalyzed = new HashMap<String, String>();
        boolean valid = true;
        List keyValuePairs = StringUtil.splitTextLines((String)(keyValuePairsAsString == null ? "" : keyValuePairsAsString));
        for (String keyValuePairAsString : keyValuePairs) {
            ArrayList keyValuePair = StringUtil.split((String)keyValuePairAsString, (char)'=', (int)2);
            if (keyValuePair.size() == 2) {
                String key = ((String)keyValuePair.get(0)).trim();
                String valueWithSemicolon = ((String)keyValuePair.get(1)).trim();
                if (key.length() == 0) {
                    valid = false;
                    break;
                }
                if (valueWithSemicolon.length() < 1) {
                    valid = false;
                    break;
                }
                if (valueWithSemicolon.endsWith(";")) {
                    String valueWithEscapedLineBreaks = valueWithSemicolon.substring(0, valueWithSemicolon.length() - 1).trim();
                    String value = valueWithEscapedLineBreaks.replaceAll("###NL###", "\r\n");
                    keyValuePairsAnalyzed.put(key, value);
                    continue;
                }
                valid = false;
                break;
            }
            valid = false;
            break;
        }
        if (!valid) {
            keyValuePairsAnalyzed.clear();
        }
        return keyValuePairsAnalyzed;
    }

    private static void setPropertyIfMatching(DocumentProperty property, String name, String value) {
        String propertyName = property.get_Name();
        if (value != null && name.equals(propertyName)) {
            property.set_Value((Object)value);
        }
    }

    private static void writeTitleAndSubtitleAndParagraphsBeforeFirstChapter(EOBook book, Document document, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext, ReportJob reportJob, Map<String, String> customDocumentProperites) throws ReportGenerationException {
        EOSubtitle subtitle;
        boolean anyDotTemplateContents = DocumentWriter.doesDocumentContainAnything(document);
        boolean anyTitlePageContents = false;
        Paragraphs paragraphs = document.get_Paragraphs();
        Paragraph firstParagraphOfFormatTemplate = paragraphs.get_First();
        EOTitle title = book.getTitle();
        if (title != null) {
            Range rangeForNewParagraph = firstParagraphOfFormatTemplate.get_Range();
            Paragraph titlePara = paragraphs.Add((Object)rangeForNewParagraph);
            titlePara.set_Style((Object)-63);
            TitleWriter.getInstance().write(title, titlePara, document, processingContext);
            anyTitlePageContents = true;
            titlePara.dispose();
            rangeForNewParagraph.dispose();
        }
        if ((subtitle = book.getSubtitle()) != null) {
            Range rangeForNewParagraph = firstParagraphOfFormatTemplate.get_Range();
            Paragraph subtitlePara = paragraphs.Add((Object)rangeForNewParagraph);
            subtitlePara.set_Style((Object)-75);
            SubTitleWriter.getInstance().write(subtitle, subtitlePara, document, processingContext);
            anyTitlePageContents = true;
            subtitlePara.dispose();
            rangeForNewParagraph.dispose();
        }
        ArrayList contentList = new ArrayList(book.getContent());
        Iterator contentIter = contentList.iterator();
        while (contentIter.hasNext()) {
            Paragraph chapterPara;
            Range rangeForNewParagraph;
            Object obj = contentIter.next();
            if (obj instanceof EOPara) {
                rangeForNewParagraph = firstParagraphOfFormatTemplate.get_Range();
                chapterPara = paragraphs.Add((Object)rangeForNewParagraph);
                chapterPara.set_Style((Object)-1);
                ParagraphWriter.getInstance().write((EOPara)obj, chapterPara, document, styleMap, graphicsAndFilesStore, processingContext);
                anyTitlePageContents = true;
                chapterPara.dispose();
                rangeForNewParagraph.dispose();
            } else if (obj instanceof EOTable) {
                rangeForNewParagraph = firstParagraphOfFormatTemplate.get_Range();
                chapterPara = paragraphs.Add((Object)rangeForNewParagraph);
                chapterPara.set_Style((Object)-1);
                TableWriter.getInstance().write((EOTable)obj, chapterPara, document, styleMap, graphicsAndFilesStore, processingContext);
                anyTitlePageContents = true;
                chapterPara.dispose();
                rangeForNewParagraph.dispose();
            } else if (obj instanceof EOPreface) {
                PrefaceWriter.getInstance().write((EOPreface)obj, document, paragraphs, firstParagraphOfFormatTemplate, styleMap, graphicsAndFilesStore, processingContext);
                anyTitlePageContents = true;
            } else if (obj instanceof EOChapter) break;
            contentIter.remove();
        }
        if (anyTitlePageContents && anyDotTemplateContents) {
            String configuredBreakType = customDocumentProperites.get("PageBreakAfterTitlePage");
            if (configuredBreakType == null) {
                configuredBreakType = WordReportsPreferences.getPageBreakAfterTitlePage();
            }
            if (!configuredBreakType.equals("PageBreak_None")) {
                int breakType = configuredBreakType.equals("PageBreak_NextPage") ? 2 : (configuredBreakType.equals("PageBreak_OddPage") ? 5 : (configuredBreakType.equals("PageBreak_EvenPage") ? 4 : 7));
                Range rangeAtWhichToInsertNewParagraph = firstParagraphOfFormatTemplate.get_Range();
                Paragraph newParagraph = paragraphs.Add((Object)rangeAtWhichToInsertNewParagraph);
                Range newParagraphRange = newParagraph.get_Range();
                newParagraphRange.InsertBreak((Object)breakType);
                newParagraphRange.dispose();
                newParagraph.dispose();
                rangeAtWhichToInsertNewParagraph.dispose();
            }
        }
        paragraphs.dispose();
    }

    public static boolean doesDocumentContainAnything(Document wordDocument) {
        Paragraphs paragraphs = wordDocument.get_Paragraphs();
        Paragraph firstParagraph = paragraphs.get_First();
        Range firstParagraphRange = firstParagraph.get_Range();
        boolean containsAnything = paragraphs.get_Count() > 1 || firstParagraphRange.get_End() - firstParagraphRange.get_Start() > 1;
        paragraphs.dispose();
        firstParagraph.dispose();
        firstParagraphRange.dispose();
        return containsAnything;
    }
}

