/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOChapter;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSection;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.word.StyleMap;
import com.arcway.cockpit.docgen.writer.word.docbook2word.AnchorWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.BreakType;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SectionWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TableWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TitleWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.WriterUtil;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import java.util.List;

public class ChapterWriter {
    private static ChapterWriter writer;
    private static final Integer WdBuiltinStyle_wdStyleNormal;
    private static final Integer WdBuiltinStyle_wdStyleHeading1;
    private static final Integer WdBuiltinStyle_wdStyleHeading2;

    static {
        WdBuiltinStyle_wdStyleNormal = new Integer(-1);
        WdBuiltinStyle_wdStyleHeading1 = new Integer(-2);
        WdBuiltinStyle_wdStyleHeading2 = new Integer(-3);
    }

    public static ChapterWriter getInstance() {
        if (writer == null) {
            writer = new ChapterWriter();
        }
        return writer;
    }

    private ChapterWriter() {
    }

    public void write(EOChapter chapter, BreakType breakBeforeChapter, Document document, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, DocBookPostProcessingProgress progress, ProcessingContext processingContext) throws ReportGenerationException, ReportGenerationCanceledException {
        EOSubtitle subtitle;
        int[] paragraphCount = new int[1];
        EOTitle title = chapter.getTitle();
        if (title != null) {
            Paragraph titlePara = ChapterWriter.createParagraph(document, paragraphCount, breakBeforeChapter, processingContext);
            titlePara.set_Style((Object)WdBuiltinStyle_wdStyleHeading1);
            TitleWriter.getInstance().write(title, titlePara, document, processingContext);
            titlePara.dispose();
        }
        if ((subtitle = chapter.getSubtitle()) != null) {
            Paragraph subtitlePara = ChapterWriter.createParagraph(document, paragraphCount, breakBeforeChapter, processingContext);
            subtitlePara.set_Style((Object)WdBuiltinStyle_wdStyleHeading2);
            SubTitleWriter.getInstance().write(subtitle, subtitlePara, document, processingContext);
            subtitlePara.dispose();
        }
        List contentList = chapter.getContent();
        for (Object obj : contentList) {
            Paragraph chapterPara;
            if (obj instanceof EOAnchor) {
                chapterPara = ChapterWriter.createParagraph(document, paragraphCount, breakBeforeChapter, processingContext);
                AnchorWriter.getInstance().write((EOAnchor)obj, chapterPara, processingContext);
                chapterPara.dispose();
            } else if (obj instanceof EOPara) {
                chapterPara = ChapterWriter.createParagraph(document, paragraphCount, breakBeforeChapter, processingContext);
                chapterPara.set_Style((Object)WdBuiltinStyle_wdStyleNormal);
                ParagraphWriter.getInstance().write((EOPara)obj, chapterPara, document, styleMap, graphicsAndFilesStore, processingContext);
                chapterPara.dispose();
            } else if (obj instanceof EOSection) {
                SectionWriter.getInstance().write((EOSection)obj, document, WdBuiltinStyle_wdStyleHeading2, styleMap, graphicsAndFilesStore, progress, processingContext);
            } else if (obj instanceof EOTable) {
                chapterPara = ChapterWriter.createParagraph(document, paragraphCount, breakBeforeChapter, processingContext);
                chapterPara.set_Style((Object)WdBuiltinStyle_wdStyleNormal);
                TableWriter.getInstance().write((EOTable)obj, chapterPara, document, styleMap, graphicsAndFilesStore, processingContext);
                chapterPara.dispose();
            } else if (obj instanceof EOSimpleList) {
                chapterPara = ChapterWriter.createParagraph(document, paragraphCount, breakBeforeChapter, processingContext);
                chapterPara.set_Style((Object)WdBuiltinStyle_wdStyleNormal);
                SimpleListWriter.getInstance().write((EOSimpleList)obj, chapterPara, document, processingContext);
                chapterPara.dispose();
            }
            progress.checkCancelState();
        }
        progress.incrementChapterProgress();
    }

    private static Paragraph createParagraph(Document document, int[] count, BreakType breakType, ProcessingContext processingContext) {
        Paragraph para = WriterUtil.createNewParagraph(document, processingContext);
        if (count[0] == 0) {
            ParagraphWriter.addPageBreak(para, breakType);
        }
        count[0] = count[0] + 1;
        return para;
    }
}

