/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word;

import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.eclipse.ole.word.Style;
import com.arcway.lib.eclipse.ole.word.Styles;
import com.arcway.lib.eclipse.ole.word.Table;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.SWTException;

public class StyleMap {
    private static final ILogger logger = Logger.getLogger(StyleMap.class);
    private Map<String, Style> map_styleName_style;
    private HashSet<String> unknownStyles = null;
    private final HashSet<String> problemEmphasisStyles = new HashSet();
    private final HashSet<String> problemParagraphStyles = new HashSet();
    private final HashSet<String> problemTableStyles = new HashSet();
    private final HashSet<String> problemTableEntryStyles = new HashSet();

    public StyleMap(Document document) {
        this.fillStyleCache(document);
    }

    private Style findStyle(String styleName) {
        if (styleName == null) {
            return null;
        }
        Style style = this.map_styleName_style.get(styleName);
        if (style != null) {
            return style;
        }
        if (!this.unknownStyles.contains(styleName)) {
            this.unknownStyles.add(styleName);
            logger.debug(150, "[write table] could not find style " + styleName);
        }
        return null;
    }

    private void fillStyleCache(Document document) {
        this.map_styleName_style = new HashMap<String, Style>();
        this.unknownStyles = new HashSet();
        Styles styles = document.get_Styles();
        int styleCount = styles.get_Count();
        int i = 1;
        while (i <= styleCount) {
            Style style = styles.Item((Object)i);
            if (style != null) {
                String currentStyleName = style.get_NameLocal();
                this.map_styleName_style.put(currentStyleName, style);
                if (logger.isDebugEnabled(150)) {
                    logger.debug(150, "[write table] found style " + currentStyleName);
                }
            }
            ++i;
        }
        styles.dispose();
    }

    public boolean applyEmphasisStyle(Range emphasisRange, String styleName) {
        boolean success = false;
        if (!StyleMap.isNullOrWhitespace(styleName) && !this.problemEmphasisStyles.contains(styleName)) {
            Style style = this.findStyle(styleName);
            if (style != null) {
                try {
                    emphasisRange.set_Style((Object)style);
                    success = true;
                }
                catch (SWTException swte) {
                    if (this.problemEmphasisStyles.add(styleName)) {
                        logger.error("[write emphasis] style: \"" + styleName + "\" could not be applied.", (Throwable)swte);
                    }
                }
            } else if (this.problemEmphasisStyles.add(styleName)) {
                logger.warn("[write emphasis] emphasis style: \"" + styleName + "\" is not defined in the document template.");
            }
        }
        return success;
    }

    public boolean applyParagraphStyle(Paragraph paragraph, String styleName) {
        boolean success = false;
        if (!StyleMap.isNullOrWhitespace(styleName) && !this.problemParagraphStyles.contains(styleName)) {
            Style style = this.findStyle(styleName);
            if (style != null) {
                try {
                    paragraph.set_Style((Object)style);
                    success = true;
                }
                catch (SWTException swte) {
                    if (this.problemParagraphStyles.add(styleName)) {
                        logger.error("[write paragraph] style: \"" + styleName + "\" could not be applied.", (Throwable)swte);
                    }
                }
            } else if (this.problemParagraphStyles.add(styleName)) {
                logger.warn("[write paragraph] paragraph style: \"" + styleName + "\" is not defined in the document template.");
            }
        }
        return success;
    }

    public boolean applyTableStyle(Table table, String styleName) {
        boolean success;
        block9: {
            success = false;
            if (!StyleMap.isNullOrWhitespace(styleName) && !this.problemTableStyles.contains(styleName)) {
                Style style = this.findStyle(styleName);
                if (style != null) {
                    try {
                        if (style.get_Type() == 3) {
                            table.set_Style((Object)style);
                            success = true;
                        } else if (this.problemTableStyles.add(styleName)) {
                            logger.warn("[write table] style: \"" + styleName + "\" is not a table style.");
                        }
                        break block9;
                    }
                    catch (SWTException swte) {
                        if (this.problemTableStyles.add(styleName)) {
                            logger.error("[write table] style: \"" + styleName + "\" could not be applied.", (Throwable)swte);
                        }
                        break block9;
                    }
                }
                if (this.problemTableStyles.add(styleName)) {
                    logger.warn("[write table] table style: \"" + styleName + "\" is not defined in the document template.");
                }
            }
        }
        return success;
    }

    public boolean applyTableEntryStyle(Range tableEntryRange, String styleName) {
        boolean success = false;
        if (!StyleMap.isNullOrWhitespace(styleName) && !this.problemTableEntryStyles.contains(styleName)) {
            Style style = this.findStyle(styleName);
            if (style != null) {
                try {
                    tableEntryRange.set_Style((Object)style);
                    success = true;
                }
                catch (SWTException swte) {
                    if (this.problemTableEntryStyles.add(styleName)) {
                        logger.error("[write table entry] style: \"" + styleName + "\" could not be applied.", (Throwable)swte);
                    }
                }
            } else if (this.problemTableEntryStyles.add(styleName)) {
                logger.warn("[write table entry] style: \"" + styleName + "\" is not defined in the document template.");
            }
        }
        return success;
    }

    private static boolean isNullOrWhitespace(String s) {
        return s == null || s.trim().length() == 0;
    }
}

