/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.util;

import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    private static final String ZIP_SEPARATOR = "/";

    public static void createZipFile(File sourceDirectory, File destinationFile) throws IOException, JvmExternalResourceInteractionException {
        try (ZipOutputStream zos = Zip.createZipOutputStream(destinationFile);){
            Zip.createZipEntries(sourceDirectory, sourceDirectory, zos);
            zos.flush();
        }
    }

    private static ZipOutputStream createZipOutputStream(File destination) throws IOException {
        if (destination.exists()) {
            throw new IOException("Destination File already exists.");
        }
        if (!destination.getParentFile().exists()) {
            throw new FileNotFoundException("Cannot find the path specified.");
        }
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
        return zos;
    }

    private static void createZipEntries(File file, File root, ZipOutputStream zos) throws IOException, JvmExternalResourceInteractionException {
        if (!file.exists()) {
            throw new IOException("Error while opening zip file: cannot find file " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            File[] content;
            File[] fileArray = content = file.listFiles();
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                Zip.createZipEntries(element, root, zos);
                ++n2;
            }
        } else {
            Zip.createZipEntry(file, root, zos);
        }
    }

    private static void createZipEntry(File source, File root, ZipOutputStream zos) throws IOException, JvmExternalResourceInteractionException {
        if (!source.getAbsolutePath().startsWith(root.getAbsolutePath())) {
            throw new IOException("File to compress is not in directory to compress.");
        }
        ArrayList<String> rootPathElements = new ArrayList<String>();
        File remaining = root.getAbsoluteFile();
        while (remaining != null) {
            rootPathElements.add(0, remaining.getName());
            remaining = remaining.getParentFile();
        }
        ArrayList<String> sourcePathElements = new ArrayList<String>();
        File remaining2 = source.getAbsoluteFile();
        while (remaining2 != null) {
            sourcePathElements.add(0, remaining2.getName());
            remaining2 = remaining2.getParentFile();
        }
        assert (sourcePathElements.size() > rootPathElements.size());
        int i = 0;
        while (i < rootPathElements.size()) {
            assert (((String)rootPathElements.get(i)).equals(sourcePathElements.get(i)));
            ++i;
        }
        StringBuilder relativePath = new StringBuilder();
        int i2 = rootPathElements.size();
        while (i2 < sourcePathElements.size()) {
            if (i2 != rootPathElements.size()) {
                relativePath.append(ZIP_SEPARATOR);
            }
            relativePath.append((String)sourcePathElements.get(i2));
            ++i2;
        }
        Zip.writeZipEntry(source, relativePath.toString(), zos);
    }

    public static void writeZipEntry(File source, String name, ZipOutputStream zos) throws IOException, JvmExternalResourceInteractionException {
        ZipEntry e = new ZipEntry(name);
        zos.putNextEntry(e);
        DataCopyHelper.copyFile((File)source, (OutputStream)zos, (boolean)false);
    }
}

