/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.util;

import com.arcway.cockpit.docgen.writer.odt.dom.CRLFLineBreaksXmlFileWriter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlComponentUtil {
    private static final ILogger LOGGER = Logger.getLogger(XmlComponentUtil.class);

    public static Document readComponentXmlFile(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    public static void write(Document document, File outputFile) {
        try {
            Closeable serialisationOutputTarget;
            StreamResult result;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            if (CRLFLineBreaksXmlFileWriter.isCRLFPatchingNecessary()) {
                CRLFLineBreaksXmlFileWriter crlfLineBreaksXmlFileWriter = new CRLFLineBreaksXmlFileWriter(outputFile, "UTF-8");
                result = new StreamResult(crlfLineBreaksXmlFileWriter);
                serialisationOutputTarget = crlfLineBreaksXmlFileWriter;
            } else {
                FileOutputStream stream = new FileOutputStream(outputFile);
                result = new StreamResult(stream);
                serialisationOutputTarget = stream;
            }
            transformer.transform(source, result);
            if (serialisationOutputTarget instanceof Flushable) {
                try {
                    ((Flushable)((Object)serialisationOutputTarget)).flush();
                }
                catch (IOException ioE) {
                    LOGGER.error("Problem while flush()'ing ODT related XML output stream.", (Throwable)ioE);
                }
            }
            try {
                serialisationOutputTarget.close();
            }
            catch (IOException ioE) {
                LOGGER.error("Problem while close()'ing ODT related XML output stream.", (Throwable)ioE);
            }
        }
        catch (TransformerConfigurationException tce) {
            LOGGER.error("Could not write OpenDocument Text report: Transformer Factory error", (Throwable)tce);
        }
        catch (TransformerException te) {
            LOGGER.error("Could not write OpenDocument Text report: Transformation error", (Throwable)te);
        }
        catch (FileNotFoundException fnfE) {
            LOGGER.error("Could not write OpenDocument Text report: Transformation error: Could not open target file", (Throwable)fnfE);
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.error("Could not write OpenDocument Text report: Required character encoding not supported", (Throwable)uee);
        }
    }
}

