/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.writer.odt.TableStyleCreationAssistant;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TableRowType;
import com.arcway.cockpit.docgen.writer.odt.dom.AnchorWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.EmphasisWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.IAnchorParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IEmphasisParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ILinkParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IMediaObjectParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IParagraphParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IPhraseParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ISimpleListParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IUlinkParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ImageObjectWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.LinkWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.MediaObjectWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.ParagraphWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.PhraseWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.SimpleListWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.UlinkWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableWrapper
implements IAnchorParent,
ILinkParent,
IParagraphParent,
ISimpleListParent,
ITableParent,
IUlinkParent,
IMediaObjectParent,
IEmphasisParent,
IPhraseParent {
    private final TableStyleCreationAssistant tableStyleCreationAssistant;
    private final DocBook2ODTGenerationContext context;
    private Document document = null;
    private Element table = null;
    private int rowIndex = -1;
    private TableRowType rowType = null;
    private Element row = null;
    private int columnIndex = -1;
    private Element cell = null;
    private ParagraphWrapper paragraphWrapper = null;

    public TableWrapper(Document document, Node parent, String tabstyle, DocBook2ODTGenerationContext context) {
        this.tableStyleCreationAssistant = context.getTableStyleManager().getTableStyleCreationAssistant(tabstyle);
        this.context = context;
        this.document = document;
        this.table = document.createElement("table:table");
        this.table = (Element)parent.appendChild(this.table);
    }

    public void setStyle(double tableWidthInMm) {
        String stylename_table = this.tableStyleCreationAssistant.createTableStyle(tableWidthInMm);
        if (stylename_table != null) {
            this.table.setAttribute("table:style-name", stylename_table);
        }
    }

    public void addColumn(double colWidthInMm) {
        Element column = this.document.createElement("table:table-column");
        this.table.appendChild(column);
        ++this.columnIndex;
        String stylename_table_column = this.tableStyleCreationAssistant.createColumnStyle(this.columnIndex, colWidthInMm);
        if (stylename_table_column != null) {
            column.setAttribute("table:style-name", stylename_table_column);
        }
    }

    public void addRow(TableRowType p_rowType) {
        ++this.rowIndex;
        this.rowType = p_rowType;
        this.row = this.document.createElement("table:table-row");
        this.row = (Element)this.table.appendChild(this.row);
        String stylename_table_row = this.tableStyleCreationAssistant.getRowStyle(this.rowIndex, p_rowType);
        if (stylename_table_row != null) {
            this.row.setAttribute("table:style-name", stylename_table_row);
        }
    }

    public void controlRow() {
    }

    public void addCell(int number_columns_spanned) {
        this.cell = this.document.createElement("table:table-cell");
        if (number_columns_spanned > 1) {
            this.cell.setAttribute("table:number-columns-spanned", "" + number_columns_spanned);
        }
        this.cell.setAttribute("office:value-type", "string");
        this.row.appendChild(this.cell);
        String stylename_table_cell = this.tableStyleCreationAssistant.getCellStyle(this.rowIndex, this.rowType);
        if (stylename_table_cell != null) {
            this.cell.setAttribute("table:style-name", stylename_table_cell);
        }
        int i = 1;
        while (i < number_columns_spanned) {
            Element covered_table_cell = this.document.createElement("table:covered-table-cell");
            this.row.appendChild(covered_table_cell);
            ++i;
        }
        this.paragraphWrapper = null;
    }

    public void controlCell() {
    }

    public void addText(String text) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        this.paragraphWrapper.addText(text);
    }

    @Override
    public SimpleListWrapper addSimpleList() {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addSimpleList();
    }

    @Override
    public AnchorWrapper addAnchor(String anchorId, String anchorName) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addAnchor(anchorId, anchorName);
    }

    @Override
    public LinkWrapper addLink(String anchorName) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addLink(anchorName);
    }

    public void hideMergedParagraph() {
        if (this.paragraphWrapper != null) {
            this.paragraphWrapper.hideParagraph();
        }
    }

    @Override
    public ParagraphWrapper addParagraph() {
        return this.addParagraph(null);
    }

    @Override
    public ParagraphWrapper addParagraph(String style) {
        this.paragraphWrapper = new ParagraphWrapper(this.document, this.cell, style, this.context.getStyleMap(), this.context.getProjectLocale());
        return this.paragraphWrapper;
    }

    @Override
    public TableWrapper addTable(String tabstyle, DocBook2ODTGenerationContext context) {
        TableWrapper t = new TableWrapper(this.document, this.cell, tabstyle, context);
        return t;
    }

    @Override
    public UlinkWrapper addUlink(String url) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addUlink(url);
    }

    @Override
    public EmphasisWrapper addEmphasis() {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addEmphasis();
    }

    @Override
    public PhraseWrapper addPhrase() {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addPhrase();
    }

    @Override
    public MediaObjectWrapper addMediaObject() {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addMediaObject();
    }

    @Override
    public ImageObjectWrapper addImageObject(String name, String format, float width, float height, boolean newImage, int imageCounter, String filename) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addImageObject(name, format, width, height, newImage, imageCounter, filename);
    }
}

