/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.dom.AnchorWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.HeadingWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.IAnchorParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IHeadingParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ILinkParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ISectionParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ISimpleListParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.odt.dom.LinkWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.ParagraphWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.SectionWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.SimpleListWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.TableWrapper;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ChapterWrapper
implements IHeadingParent,
ISectionParent,
ITableParent,
IAnchorParent,
ILinkParent,
ISimpleListParent {
    private final Document document;
    private final Node parent;
    private final Locale projectLocale;
    private final StyleMap styleMap;
    private ParagraphWrapper lastParagraph = null;

    public ChapterWrapper(Document document, Node parent, Locale projectLocale, StyleMap styleMap) {
        this.document = document;
        this.parent = parent;
        this.projectLocale = projectLocale;
        this.styleMap = styleMap;
    }

    @Override
    public HeadingWrapper addHeading(int outlinelevel, String style) {
        return new HeadingWrapper(this.document, this.parent, outlinelevel, style, this.styleMap, this.projectLocale);
    }

    @Override
    public SectionWrapper addSection() {
        this.lastParagraph = null;
        return new SectionWrapper(this.document, this.parent, this.projectLocale, this.styleMap);
    }

    @Override
    public ParagraphWrapper addParagraph() {
        return this.addParagraph(null);
    }

    @Override
    public ParagraphWrapper addParagraph(String style) {
        this.lastParagraph = new ParagraphWrapper(this.document, this.parent, style, this.styleMap, this.projectLocale);
        return this.lastParagraph;
    }

    @Override
    public TableWrapper addTable(String tabstyle, DocBook2ODTGenerationContext context) {
        this.lastParagraph = null;
        return new TableWrapper(this.document, this.parent, tabstyle, context);
    }

    @Override
    public AnchorWrapper addAnchor(String anchorId, String anchorName) {
        if (this.lastParagraph == null) {
            this.addParagraph();
        }
        return this.lastParagraph.addAnchor(anchorId, anchorName);
    }

    @Override
    public LinkWrapper addLink(String anchorName) {
        if (this.lastParagraph == null) {
            this.addParagraph();
        }
        return this.lastParagraph.addLink(anchorName);
    }

    @Override
    public SimpleListWrapper addSimpleList() {
        if (this.lastParagraph == null) {
            this.addParagraph();
        }
        return this.lastParagraph.addSimpleList();
    }
}

