/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.AnchorWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.LinkWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.UlinkWriter;
import com.arcway.cockpit.docgen.writer.odt.dom.HeadingWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.ParagraphWrapper;
import java.util.List;

public class TitleWriter {
    private static TitleWriter writer;

    public static TitleWriter getInstance() {
        if (writer == null) {
            writer = new TitleWriter();
        }
        return writer;
    }

    private TitleWriter() {
    }

    public void write(EOTitle title, ParagraphWrapper paragraph, DocBook2ODTGenerationContext context) {
        List contentList = title.getContent(context.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                paragraph.addText((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, paragraph, context);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, paragraph, context);
                continue;
            }
            if (!(obj instanceof EOUlink)) continue;
            UlinkWriter.getInstance().write((EOUlink)obj, paragraph, context);
        }
    }

    public void write(EOTitle title, HeadingWrapper paragraph, DocBook2ODTGenerationContext context) {
        List contentList = title.getContent(context.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                paragraph.addText((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, paragraph, context);
                continue;
            }
            assert (false);
        }
    }
}

