/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSection;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.AnchorWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.MediaObjectWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TableWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TitleWriter;
import com.arcway.cockpit.docgen.writer.odt.dom.ISectionParent;
import com.arcway.cockpit.docgen.writer.odt.dom.SectionWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.util.List;

public class SectionWriter {
    private static SectionWriter writer;

    public static SectionWriter getInstance() {
        if (writer == null) {
            writer = new SectionWriter();
        }
        return writer;
    }

    private SectionWriter() {
    }

    public void write(EOSection section, ISectionParent parent, int level, StyleMap styleMap, DocBook2ODTGenerationContext context, DocBookPostProcessingProgress progress) throws ReportGenerationException, JvmExternalResourceInteractionException, ReportGenerationCanceledException {
        EOSubtitle subtitle;
        progress.incrementSectionProgress();
        SectionWrapper s = parent.addSection();
        EOTitle title = section.getTitle();
        if (title != null) {
            String style = title.getRole();
            TitleWriter.getInstance().write(title, s.addHeading(level, style), context);
        }
        if ((subtitle = section.getSubtitle()) != null) {
            String style = subtitle.getRole();
            SubTitleWriter.getInstance().write(subtitle, s.addParagraph(style), context);
        }
        List contentList = section.getContent();
        for (Object obj : contentList) {
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, s, context);
            } else if (obj instanceof EOMediaObject) {
                MediaObjectWriter.getInstance().write((EOMediaObject)obj, s, context);
            } else if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, s, context);
            } else if (obj instanceof EOSection) {
                this.write((EOSection)obj, s, level + 1, styleMap, context, progress);
            } else if (obj instanceof EOTable) {
                TableWriter.getInstance().write((EOTable)obj, s, context);
            } else if (obj instanceof EOSimpleList) {
                SimpleListWriter.getInstance().write((EOSimpleList)obj, s, context);
            }
            progress.checkCancelState();
        }
    }
}

