/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.DocBookAnalyzer;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBook;
import com.arcway.cockpit.docgen.writer.docbook.model.EOChapter;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPreface;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.odt.ODFManifestManager;
import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.TableStyleManager;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.ChapterWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.PrefaceWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TitleWriter;
import com.arcway.cockpit.docgen.writer.odt.dom.BodyNodeWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.LengthParser;
import com.arcway.cockpit.docgen.writer.odt.dom.OXTReader;
import com.arcway.cockpit.docgen.writer.odt.dom.PageLayoutStyleInfo;
import com.arcway.cockpit.docgen.writer.odt.dom.TemplateContent;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class DocumentWriter {
    private static final ILogger logger = Logger.getLogger(DocumentWriter.class);
    private static DocumentWriter writer;

    public static DocumentWriter getInstance() {
        if (writer == null) {
            writer = new DocumentWriter();
        }
        return writer;
    }

    private DocumentWriter() {
    }

    public void write(EOBook docBook, File odtDirectory, OXTReader oxtFile, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ODFManifestManager odfManifestManager, ReportJob reportJob, IProgressMonitor progressMonitor) throws ReportGenerationCanceledException, ReportGenerationException, JvmExternalResourceInteractionException {
        DocBookAnalyzer analyzer = new DocBookAnalyzer();
        DocBookPostProcessingProgress progress = new DocBookPostProcessingProgress(progressMonitor, analyzer.countChaptersAndSections(docBook));
        BodyNodeWrapper body = new BodyNodeWrapper(oxtFile, styleMap);
        TemplateContent templateContent = body.getTemplateContent();
        TableStyleManager tableStyleManager = new TableStyleManager(styleMap, oxtFile.getDocument(), templateContent.getTemplateMasterTables());
        DocBook2ODTGenerationContext context = new DocBook2ODTGenerationContext(odtDirectory, reportJob, oxtFile.getProjectLocale(), styleMap, graphicsAndFilesStore, odfManifestManager, tableStyleManager);
        DocumentWriter.determinePageSize(context);
        ArrayList docBookContentList = new ArrayList(docBook.getContent());
        progress.checkCancelState();
        this.writeCoverSheet(docBook, docBookContentList, body, styleMap, context);
        progress.checkCancelState();
        body.appendTemplateContent(templateContent.getDocumentNucleus());
        progress.checkCancelState();
        this.writeMainChapters(body, docBookContentList, styleMap, context, progress);
        progress.checkCancelState();
        tableStyleManager.adjustAutomaticDocumentTableStyles();
        progress.checkCancelState();
        oxtFile.getDocumentRootElement().normalize();
        oxtFile.write();
    }

    private static void determinePageSize(DocBook2ODTGenerationContext context) {
        HashMap<String, PageLayoutStyleInfo.PageDimensions> allPageDimensionsMap = new HashMap<String, PageLayoutStyleInfo.PageDimensions>();
        for (PageLayoutStyleInfo pageLayout : context.getStyleMap().getPageLayoutStyles()) {
            try {
                allPageDimensionsMap.put(pageLayout.getName(), pageLayout.getPageDimensions());
            }
            catch (LengthParser.LengthParseException e) {
                logger.error("Page dimensions contained in the OpenDocument Text template are missing or could not be read. - will ignore this page definition: " + pageLayout.getName(), (Throwable)e);
            }
        }
        double maxRectWidthInMM = 0.0;
        double maxRectHeightInMM = 0.0;
        boolean isFirstPageDimension = true;
        for (PageLayoutStyleInfo.PageDimensions pageDimensions : allPageDimensionsMap.values()) {
            if (isFirstPageDimension) {
                maxRectWidthInMM = pageDimensions.getPageWidthWithoutMargins();
                maxRectHeightInMM = pageDimensions.getPageHeightWithoutMargins();
            } else {
                maxRectWidthInMM = Math.min(maxRectWidthInMM, pageDimensions.getPageWidthWithoutMargins());
                maxRectHeightInMM = Math.min(maxRectHeightInMM, pageDimensions.getPageHeightWithoutMargins());
            }
            isFirstPageDimension = false;
        }
        if (maxRectWidthInMM < 0.1 || maxRectHeightInMM < 0.1) {
            maxRectWidthInMM = 165.0;
            maxRectHeightInMM = 252.0;
            logger.debug("Could not extract useable page/margin dimensions from the OpenDocument Text template - will use defaults: A4 page, portrait, with 45mm total margins for top+bottom and left+right.");
        } else {
            StringBuffer messageBuf = new StringBuffer();
            messageBuf.append("Found the following page sizes (without margins): ");
            boolean isFirstPageDimension2 = true;
            for (Map.Entry pageDimensionsEntry : allPageDimensionsMap.entrySet()) {
                if (isFirstPageDimension2) {
                    isFirstPageDimension2 = false;
                } else {
                    messageBuf.append("; ");
                }
                messageBuf.append((String)pageDimensionsEntry.getKey());
                messageBuf.append(": width=");
                messageBuf.append(LengthParser.WidthInCmNumberFormat.format(((PageLayoutStyleInfo.PageDimensions)pageDimensionsEntry.getValue()).getPageWidthWithoutMargins() / 10.0));
                messageBuf.append(", heigth=");
                messageBuf.append(LengthParser.WidthInCmNumberFormat.format(((PageLayoutStyleInfo.PageDimensions)pageDimensionsEntry.getValue()).getPageHeightWithoutMargins() / 10.0));
            }
            messageBuf.append("\n");
            messageBuf.append("Will scale embedded images (down) to a maximum width of ");
            messageBuf.append(LengthParser.WidthInCmNumberFormat.format(maxRectWidthInMM / 10.0));
            messageBuf.append(" and a maximum height of ");
            messageBuf.append(LengthParser.WidthInCmNumberFormat.format(maxRectHeightInMM / 10.0));
            messageBuf.append(" to ensure that all images fit on every page.");
            logger.debug(messageBuf.toString());
        }
        context.setMaxRectHeightInPt((int)(maxRectHeightInMM / 25.4 * 72.0));
        context.setMaxRectWidthInPt((int)(maxRectWidthInMM / 25.4 * 72.0));
    }

    private void writeCoverSheet(EOBook docBook, List<?> docBookContentList, BodyNodeWrapper body, StyleMap styleMap, DocBook2ODTGenerationContext context) throws ReportGenerationException, JvmExternalResourceInteractionException {
        EOSubtitle subtitle;
        EOTitle title = docBook.getTitle();
        if (title != null) {
            String style = title.getRole();
            if (style == null) {
                style = "Title";
            }
            TitleWriter.getInstance().write(title, body.addParagraph(style), context);
        }
        if ((subtitle = docBook.getSubtitle()) != null) {
            String style = subtitle.getRole();
            if (style == null) {
                style = "Subtitle";
            }
            SubTitleWriter.getInstance().write(subtitle, body.addParagraph(style), context);
        }
        Iterator<?> contentIter = docBookContentList.iterator();
        while (contentIter.hasNext()) {
            Object obj = contentIter.next();
            if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, body, context);
            } else if (!(obj instanceof EOTable)) {
                if (obj instanceof EOPreface) {
                    PrefaceWriter.getInstance().write((EOPreface)obj, body, context);
                } else if (obj instanceof EOChapter) break;
            }
            contentIter.remove();
        }
    }

    private void writeMainChapters(BodyNodeWrapper body, List<?> docBookContentList, StyleMap styleMap, DocBook2ODTGenerationContext context, DocBookPostProcessingProgress progress) throws ReportGenerationCanceledException, ReportGenerationException, JvmExternalResourceInteractionException {
        for (Object obj : docBookContentList) {
            if (obj instanceof EOChapter) {
                ChapterWriter.getInstance().write((EOChapter)obj, body, styleMap, context, progress);
            }
            progress.checkCancelState();
        }
    }
}

