/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOChapter;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSection;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.AnchorWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.SectionWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TableWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TitleWriter;
import com.arcway.cockpit.docgen.writer.odt.dom.BodyNodeWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.ChapterWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.util.List;

public class ChapterWriter {
    private static ChapterWriter writer;

    public static ChapterWriter getInstance() {
        if (writer == null) {
            writer = new ChapterWriter();
        }
        return writer;
    }

    private ChapterWriter() {
    }

    public void write(EOChapter chapter, BodyNodeWrapper body, StyleMap styleMap, DocBook2ODTGenerationContext context, DocBookPostProcessingProgress progress) throws ReportGenerationCanceledException, ReportGenerationException, JvmExternalResourceInteractionException {
        ChapterWrapper chapterWrapper = body.addChapter();
        EOTitle title = chapter.getTitle();
        String style = title.getRole();
        TitleWriter.getInstance().write(title, chapterWrapper.addHeading(1, style), context);
        EOSubtitle subtitle = chapter.getSubtitle();
        if (subtitle != null) {
            String style2 = subtitle.getRole();
            SubTitleWriter.getInstance().write(subtitle, chapterWrapper.addParagraph(style2), context);
        }
        List contentList = chapter.getContent();
        for (Object obj : contentList) {
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, chapterWrapper, context);
            } else if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, chapterWrapper, context);
            } else if (obj instanceof EOSection) {
                SectionWriter.getInstance().write((EOSection)obj, chapterWrapper, 2, styleMap, context, progress);
            } else if (obj instanceof EOTable) {
                TableWriter.getInstance().write((EOTable)obj, chapterWrapper, context);
            } else if (obj instanceof EOSimpleList) {
                SimpleListWriter.getInstance().write((EOSimpleList)obj, chapterWrapper, context);
            }
            progress.checkCancelState();
        }
        progress.incrementChapterProgress();
    }
}

