/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt;

import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.TableStyleCreationAssistant;
import com.arcway.cockpit.docgen.writer.odt.dom.MasterTableStyleInfo;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableStyleManager {
    private static final ILogger LOGGER = Logger.getLogger(TableStyleManager.class);
    private static final String DEFAULT_TABLE_STYLE_NAME_PREFIX = "Table";
    private final StyleMap styleMap;
    private final Document document;
    private final HashMap<String, MasterTableStyleInfo> masterTableStyles = new HashMap();
    private final HashSet<String> missingTableStyles = new HashSet();
    private int tableStyleSerial = 100;
    private final ArrayList<TableStyleCreationAssistant> tableStyleCreationAssistants = new ArrayList();

    public TableStyleManager(StyleMap styleMap, Document document, Collection<Element> templateMasterTables) {
        this.styleMap = styleMap;
        this.document = document;
        for (Element tableElement : templateMasterTables) {
            MasterTableStyleInfo tableStyleInfo = new MasterTableStyleInfo(tableElement, styleMap);
            this.masterTableStyles.put(tableStyleInfo.getTableName(), tableStyleInfo);
        }
    }

    public void adjustAutomaticDocumentTableStyles() {
        ArrayList<Element> xmlDomStyleElements = new ArrayList<Element>(this.tableStyleCreationAssistants.size() * 10);
        for (TableStyleCreationAssistant tableStyleCreationAssistant : this.tableStyleCreationAssistants) {
            Element table_xmlDomStyleElement = tableStyleCreationAssistant.getTable_xmlDomStyleElement();
            if (table_xmlDomStyleElement != null) {
                xmlDomStyleElements.add(table_xmlDomStyleElement);
            }
            xmlDomStyleElements.addAll(tableStyleCreationAssistant.getColumn_xmlDomStyleElements());
            xmlDomStyleElements.addAll(tableStyleCreationAssistant.getRow_xmlDomStyleElements());
            xmlDomStyleElements.addAll(tableStyleCreationAssistant.getCell_xmlDomStyleElements());
        }
        NodeList automaticStylesElements = this.document.getElementsByTagName("office:automatic-styles");
        Node automaticStylesElement = automaticStylesElements.item(0);
        Node insertionPointSuccessorNode = automaticStylesElement.getFirstChild();
        for (Element styleElement : xmlDomStyleElements) {
            if (insertionPointSuccessorNode == null) {
                automaticStylesElement.appendChild(styleElement);
                continue;
            }
            automaticStylesElement.insertBefore(styleElement, insertionPointSuccessorNode);
        }
    }

    public TableStyleCreationAssistant getTableStyleCreationAssistant(String tabstyle) {
        MasterTableStyleInfo masterTableStyleInfo = this.masterTableStyles.get(tabstyle);
        if (masterTableStyleInfo == null && !this.missingTableStyles.contains(tabstyle)) {
            this.missingTableStyles.add(tabstyle);
            LOGGER.warn("The OpenDocument Text (template) does not contain a master/template table with the name (tabstyle=\"" + tabstyle + "\").");
        }
        ++this.tableStyleSerial;
        String stylename = DEFAULT_TABLE_STYLE_NAME_PREFIX + this.tableStyleSerial;
        TableStyleCreationAssistant tableStyleCreationAssistant = new TableStyleCreationAssistant(this.document, stylename, masterTableStyleInfo);
        this.tableStyleCreationAssistants.add(tableStyleCreationAssistant);
        return tableStyleCreationAssistant;
    }
}

