/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt;

import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TableRowType;
import com.arcway.cockpit.docgen.writer.odt.dom.LengthParser;
import com.arcway.cockpit.docgen.writer.odt.dom.MasterTableStyleInfo;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleFamily;
import com.arcway.lib.java.tuples.Tuple;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TableStyleCreationAssistant {
    private final Document document;
    private final MasterTableStyleInfo masterTableStyleInfo;
    private final String tableStyleName;
    private Element table_xmlDomStyleElement;
    private final ArrayList<Element> column_xmlDomStyleElements = new ArrayList();
    private final LinkedHashMap<TableRowType, Tuple<String, Element>> row_xmlDomStyleElements = new LinkedHashMap();
    private final LinkedHashMap<TableRowType, Tuple<String, Element>> cell_xmlDomStyleElements = new LinkedHashMap();
    private static final String[] ALPHABET = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public TableStyleCreationAssistant(Document document, String tableStyleName, MasterTableStyleInfo masterTableStyleInfo) {
        this.document = document;
        this.tableStyleName = tableStyleName;
        this.masterTableStyleInfo = masterTableStyleInfo;
    }

    public String createTableStyle(double tableWidthInMm) {
        Element tablePropertiesElement;
        if (this.masterTableStyleInfo != null && this.masterTableStyleInfo.getTable_styleInfo() != null) {
            this.table_xmlDomStyleElement = (Element)this.masterTableStyleInfo.getTable_styleInfo().getXmlDomElement().cloneNode(true);
        } else {
            this.table_xmlDomStyleElement = this.document.createElement("style:style");
            this.table_xmlDomStyleElement.setAttribute("style:family", StyleFamily.TABLE.getOdfStyleFamilyName());
        }
        this.table_xmlDomStyleElement.setAttribute("style:name", this.tableStyleName);
        NodeList tablePropertiesElements = this.table_xmlDomStyleElement.getElementsByTagName("style:table-properties");
        if (tablePropertiesElements.getLength() == 1) {
            tablePropertiesElement = (Element)tablePropertiesElements.item(0);
        } else {
            tablePropertiesElement = this.document.createElement("style:table-properties");
            this.table_xmlDomStyleElement.appendChild(tablePropertiesElement);
        }
        tablePropertiesElement.setAttribute("style:width", LengthParser.WidthInCmNumberFormat.format(tableWidthInMm / 10.0));
        tablePropertiesElement.removeAttribute("style:rel-width");
        return this.tableStyleName;
    }

    public String createColumnStyle(int columnIndex, double colWidthInMm) {
        Element tableColumnPropertiesElement;
        Element column_xmlDomStyleElement;
        String columnStyleName = String.valueOf(this.tableStyleName) + "." + this.getTableCellAddressPart_column(columnIndex);
        if (this.masterTableStyleInfo != null && this.masterTableStyleInfo.getColumn_styleInfo() != null) {
            column_xmlDomStyleElement = (Element)this.masterTableStyleInfo.getColumn_styleInfo().getXmlDomElement().cloneNode(true);
        } else {
            column_xmlDomStyleElement = this.document.createElement("style:style");
            column_xmlDomStyleElement.setAttribute("style:family", StyleFamily.TABLE_COLUMN.getOdfStyleFamilyName());
        }
        column_xmlDomStyleElement.setAttribute("style:name", columnStyleName);
        NodeList tableColumnPropertiesElements = column_xmlDomStyleElement.getElementsByTagName("style:table-column-properties");
        if (tableColumnPropertiesElements.getLength() == 1) {
            tableColumnPropertiesElement = (Element)tableColumnPropertiesElements.item(0);
        } else {
            tableColumnPropertiesElement = this.document.createElement("style:table-column-properties");
            column_xmlDomStyleElement.appendChild(tableColumnPropertiesElement);
        }
        tableColumnPropertiesElement.setAttribute("style:column-width", LengthParser.WidthInCmNumberFormat.format(colWidthInMm / 10.0));
        tableColumnPropertiesElement.removeAttribute("style:rel-column-width");
        this.column_xmlDomStyleElements.add(column_xmlDomStyleElement);
        return columnStyleName;
    }

    public String getRowStyle(int rowIndex, TableRowType rowType) {
        Tuple<String, Element> tuple = this.row_xmlDomStyleElements.get((Object)rowType);
        if (tuple == null) {
            tuple = this.createRowStyle(rowIndex, rowType);
            this.row_xmlDomStyleElements.put(rowType, tuple);
        }
        return (String)tuple.getT1();
    }

    private Tuple<String, Element> createRowStyle(int rowIndex, TableRowType rowType) {
        Element row_xmlDomStyleElement;
        String rowStyleName;
        if (this.masterTableStyleInfo != null && this.masterTableStyleInfo.getRow_styleInfo(rowType) != null) {
            rowStyleName = String.valueOf(this.tableStyleName) + "." + this.getTableCellAddressPart_row(rowIndex);
            row_xmlDomStyleElement = (Element)this.masterTableStyleInfo.getRow_styleInfo(rowType).getXmlDomElement().cloneNode(true);
            row_xmlDomStyleElement.setAttribute("style:name", rowStyleName);
        } else {
            rowStyleName = null;
            row_xmlDomStyleElement = null;
        }
        return new Tuple(rowStyleName, row_xmlDomStyleElement);
    }

    public String getCellStyle(int rowIndex, TableRowType rowType) {
        Tuple<String, Element> tuple = this.cell_xmlDomStyleElements.get((Object)rowType);
        if (tuple == null) {
            tuple = this.createCellStyle(rowIndex, rowType);
            this.cell_xmlDomStyleElements.put(rowType, tuple);
        }
        return (String)tuple.getT1();
    }

    private Tuple<String, Element> createCellStyle(int rowIndex, TableRowType rowType) {
        Element cell_xmlDomStyleElement;
        String cellStyleName;
        if (this.masterTableStyleInfo != null && this.masterTableStyleInfo.getCell_styleInfo(rowType) != null) {
            cellStyleName = String.valueOf(this.tableStyleName) + "." + this.getTableCellAddressPart_column(0) + this.getTableCellAddressPart_row(rowIndex);
            cell_xmlDomStyleElement = (Element)this.masterTableStyleInfo.getCell_styleInfo(rowType).getXmlDomElement().cloneNode(true);
            cell_xmlDomStyleElement.setAttribute("style:name", cellStyleName);
        } else {
            cellStyleName = null;
            cell_xmlDomStyleElement = null;
        }
        return new Tuple(cellStyleName, cell_xmlDomStyleElement);
    }

    private String getTableCellAddressPart_row(int rowIndex) {
        return Integer.toString(rowIndex + 1);
    }

    private String getTableCellAddressPart_column(int columnIndex) {
        assert (26 == ALPHABET.length);
        assert (columnIndex < 676);
        int integerIndex = columnIndex;
        int currentDigit = integerIndex % 26;
        String stringIndex = ALPHABET[currentDigit];
        if (integerIndex >= 26) {
            currentDigit = (integerIndex /= 26) % 26;
            stringIndex = String.valueOf(ALPHABET[currentDigit - 1]) + stringIndex;
        }
        return stringIndex;
    }

    protected Element getTable_xmlDomStyleElement() {
        return this.table_xmlDomStyleElement;
    }

    protected ArrayList<Element> getColumn_xmlDomStyleElements() {
        return this.column_xmlDomStyleElements;
    }

    protected ArrayList<Element> getRow_xmlDomStyleElements() {
        ArrayList<Element> xmlDomStyleElements = new ArrayList<Element>(this.row_xmlDomStyleElements.size());
        for (Map.Entry<TableRowType, Tuple<String, Element>> entry : this.row_xmlDomStyleElements.entrySet()) {
            Element xmlDomStyleElement = (Element)entry.getValue().getT2();
            if (xmlDomStyleElement == null) continue;
            xmlDomStyleElements.add(xmlDomStyleElement);
        }
        return xmlDomStyleElements;
    }

    protected ArrayList<Element> getCell_xmlDomStyleElements() {
        ArrayList<Element> xmlDomStyleElements = new ArrayList<Element>(this.cell_xmlDomStyleElements.size());
        for (Map.Entry<TableRowType, Tuple<String, Element>> entry : this.cell_xmlDomStyleElements.entrySet()) {
            Element xmlDomStyleElement = (Element)entry.getValue().getT2();
            if (xmlDomStyleElement == null) continue;
            xmlDomStyleElements.add(xmlDomStyleElement);
        }
        return xmlDomStyleElements;
    }
}

