/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt;

import com.arcway.cockpit.docgen.writer.odt.dom.MultiPurposeStyleInfo;
import com.arcway.cockpit.docgen.writer.odt.dom.OXTReader;
import com.arcway.cockpit.docgen.writer.odt.dom.PageLayoutStyleInfo;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleFamily;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleInfo;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleSrcFile;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleType;
import com.arcway.cockpit.docgen.writer.odt.util.XmlComponentUtil;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringPairKey;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StyleMap {
    private static final ILogger logger = Logger.getLogger(StyleMap.class);
    private final HashMap<StyleFamily, HashMap<String, MultiPurposeStyleInfo>> stylesByFamilyAndName = new HashMap();
    private final HashMap<StyleFamily, HashMap<String, MultiPurposeStyleInfo>> stylesByFamilyAndDisplayName = new HashMap();
    private final HashSet<StringPairKey> missingStyles = new HashSet();
    private final HashMap<String, PageLayoutStyleInfo> pageStylesByName = new HashMap();

    public StyleMap(File odxDirectory, OXTReader oxtFile) throws ParserConfigurationException, SAXException, IOException {
        File odx__styles_xml = new File(odxDirectory, "styles.xml");
        Document styles_xml_document = XmlComponentUtil.readComponentXmlFile(odx__styles_xml);
        this.addStyles(StyleSrcFile.styles_xml, StyleType.office_style, styles_xml_document.getElementsByTagName("office:styles"));
        this.addStyles(StyleSrcFile.styles_xml, StyleType.automatic_style, styles_xml_document.getElementsByTagName("office:automatic-styles"));
        this.addStyles(StyleSrcFile.styles_xml, StyleType.master_style, styles_xml_document.getElementsByTagName("office:master-styles"));
        this.addStyles(StyleSrcFile.content_xml, StyleType.automatic_style, oxtFile.getDocument().getElementsByTagName("office:automatic-styles"));
    }

    private void addStyles(StyleSrcFile styleSrcFile, StyleType styleType, NodeList stylesNodeList) {
        if (stylesNodeList.getLength() > 0) {
            Node stylesNode = stylesNodeList.item(0);
            NodeList styleNodeList = stylesNode.getChildNodes();
            int i = 0;
            while (i < styleNodeList.getLength()) {
                Node styleNode = styleNodeList.item(i);
                String styleNodeName = styleNode.getNodeName();
                if ("style:style".equals(styleNodeName)) {
                    this.addMultiPurposeStyle(MultiPurposeStyleInfo.createMultiPurposeStyleInfo(styleSrcFile, styleType, (Element)styleNode));
                } else if ("style:page-layout".equals(styleNodeName)) {
                    this.addPageStyle(PageLayoutStyleInfo.createPageStyleInfo(styleSrcFile, styleType, (Element)styleNode));
                }
                ++i;
            }
        }
    }

    private void addMultiPurposeStyle(MultiPurposeStyleInfo styleInfo) {
        HashMap<String, MultiPurposeStyleInfo> styleNameInfoMap = this.stylesByFamilyAndName.get(styleInfo.getFamily());
        if (styleNameInfoMap == null) {
            styleNameInfoMap = new HashMap();
            this.stylesByFamilyAndName.put(styleInfo.getFamily(), styleNameInfoMap);
        }
        MultiPurposeStyleInfo replacedInfo = styleNameInfoMap.put(styleInfo.getName(), styleInfo);
        assert (replacedInfo == null) : "ODF spec states that all styles of type style:style within one ODF file are uniquely identified by the attributes style:name and style:family";
        if (StyleType.office_style.equals((Object)styleInfo.getType())) {
            MultiPurposeStyleInfo replacedDisplayNameInfo;
            String style_displayname = styleInfo.getDisplayName();
            HashMap<String, MultiPurposeStyleInfo> styleDisplayNameInfoMap = this.stylesByFamilyAndDisplayName.get(styleInfo.getFamily());
            if (styleDisplayNameInfoMap == null) {
                styleDisplayNameInfoMap = new HashMap();
                this.stylesByFamilyAndDisplayName.put(styleInfo.getFamily(), styleDisplayNameInfoMap);
            }
            if ((replacedDisplayNameInfo = styleDisplayNameInfoMap.put(style_displayname, styleInfo)) != null) {
                logger.info("The OpenDocument Text (template) contains several styles with the same displayname&family (displayname=\"" + style_displayname + "\", family=\"" + styleInfo.getFamily().getOdfStyleFamilyName() + "\").");
            }
        }
    }

    private void addPageStyle(PageLayoutStyleInfo pageLayoutStyleInfo) {
        StyleInfo replacedInfo = this.pageStylesByName.put(pageLayoutStyleInfo.getName(), pageLayoutStyleInfo);
        assert (replacedInfo == null) : "ODF spec states that each style of type style:page-layout within one ODF file is uniquely identified the style:name attribute.";
    }

    public String findStyleByDisplayName(String styleDisplayName, StyleFamily styleFamily) {
        MultiPurposeStyleInfo styleInfo;
        HashMap<String, MultiPurposeStyleInfo> styleDisplayNameInfoMap = this.stylesByFamilyAndDisplayName.get(styleFamily);
        if (styleDisplayNameInfoMap != null && (styleInfo = styleDisplayNameInfoMap.get(styleDisplayName)) != null) {
            return styleInfo.getName();
        }
        StringPairKey missingStyle = new StringPairKey(styleFamily.getOdfStyleFamilyName(), styleDisplayName);
        if (!this.missingStyles.contains(missingStyle)) {
            this.missingStyles.add(missingStyle);
            logger.warn("Missing style: The report references a " + styleFamily.getOdfStyleFamilyName() + " style called \"" + styleDisplayName + "\" that is not defined in the specified output template - will use defaults instead.");
        }
        return null;
    }

    public MultiPurposeStyleInfo findStyleByName(String styleName, StyleFamily styleFamily) {
        HashMap<String, MultiPurposeStyleInfo> styleNameInfoMap = this.stylesByFamilyAndName.get(styleFamily);
        if (styleNameInfoMap != null) {
            MultiPurposeStyleInfo styleInfo = styleNameInfoMap.get(styleName);
            return styleInfo;
        }
        return null;
    }

    public Collection<PageLayoutStyleInfo> getPageLayoutStyles() {
        return Collections.unmodifiableCollection(this.pageStylesByName.values());
    }
}

