/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.tempfiles;

import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.file.tmp.ITempDirectoryProvider;
import com.arcway.lib.file.tmp.ITempFileProvider;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;

public class CockpitTempDirectoryProvider
implements ITempDirectoryProvider {
    private static final ILogger LOGGER = Logger.getLogger(CockpitTempDirectoryProvider.class);
    private final String tempDirectoryPrefix;
    private final String tempFilePrefix;

    public static ITempDirectoryProvider createInstance(String tempDirectoryPrefix, String tempFilePrefix) {
        return new CockpitTempDirectoryProvider(tempDirectoryPrefix, tempFilePrefix);
    }

    private CockpitTempDirectoryProvider(String tempDirectoryPrefix, String tempFilePrefix) {
        this.tempDirectoryPrefix = tempDirectoryPrefix;
        this.tempFilePrefix = tempFilePrefix;
    }

    public ITempFileProvider createTemporaryDirectory() {
        try {
            final SessionTempDirectoryManager.SessionTempDirectory tempDirectory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)this.tempDirectoryPrefix);
            return new ITempFileProvider(){

                public File createTemporaryFile() {
                    try {
                        return SessionTempDirectoryManager.createSessionTempFile((String)CockpitTempDirectoryProvider.this.tempFilePrefix, null, (SessionTempDirectoryManager.SessionTempDirectory)tempDirectory);
                    }
                    catch (JvmExternalResourceInteractionException jeriE) {
                        LOGGER.error("Couldn't create temp file for copied custom property.", (Throwable)jeriE);
                        return null;
                    }
                }
            };
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            LOGGER.error("Couldn't create temp directory for copied custom properties.", (Throwable)jeriE);
            return null;
        }
    }
}

