/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.gui.dialogs;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class WaitDialog
extends IconAndMessageDialog {
    private static final ILogger logger = Logger.getLogger(WaitDialog.class);
    private final ISafeRunnable runnable;
    private String title;

    public WaitDialog(Shell parentShell, ISafeRunnable runnable, String title, String message) {
        super(parentShell);
        assert (runnable != null);
        this.runnable = runnable;
        if (title == null) {
            assert (false);
            this.title = "";
        } else {
            this.title = title;
        }
        if (message == null) {
            assert (false);
            this.message = "";
        } else {
            this.message = message;
        }
    }

    protected Image getImage() {
        return super.getInfoImage();
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        return super.createDialogArea(parent);
    }

    public int open() {
        int status = 0;
        super.setBlockOnOpen(false);
        super.open();
        this.getShell().setText(this.title);
        try {
            this.runnable.run();
        }
        catch (Exception e) {
            if (e instanceof EXServerException) {
                ExceptionDialog dialog = new ExceptionDialog(this.getShell(), (EXServerException)e);
                dialog.open();
            } else {
                ExceptionDialog dialog = new ExceptionDialog(this.getShell(), (Throwable)e);
                dialog.open();
            }
            status = 1;
            logger.error("Wait dialog encountered exception: ", (Throwable)e);
        }
        this.close();
        return status;
    }

    public void setBlockOnOpen(boolean shouldBlock) {
    }

    protected Control createButtonBar(Composite parent) {
        Composite emptyBar = new Composite(parent, 0);
        return emptyBar;
    }
}

