/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractStringListFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StringListFilterItem
extends AbstractFilterItem {
    private final AbstractStringListFilter filter;
    private Text txtValue;
    private String value;

    public StringListFilterItem(String name, AbstractStringListFilter filter) {
        super(name, filter);
        this.filter = filter;
        this.value = filter.getFilterValue();
    }

    @Override
    public void refresh() {
        String filterValue = this.filter.getFilterValue();
        if (filterValue != null) {
            this.txtValue.setText(this.filter.getFilterValue());
        } else {
            this.txtValue.setText("");
        }
    }

    @Override
    public String getFilterInfo() {
        return this.value;
    }

    @Override
    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(1, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        Label lbl = new Label((Composite)group, 0);
        lbl.setText(Messages.getString("StringListFilterItem.Label"));
        this.txtValue = new Text((Composite)group, 2052);
        this.txtValue.setLayoutData((Object)new GridData(768));
        this.txtValue.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                StringListFilterItem.this.txtValue.selectAll();
            }

            public void focusLost(FocusEvent e) {
                StringListFilterItem.this.updateFilter();
                StringListFilterItem.this.fireValueChanged();
            }
        });
        this.refresh();
        return group;
    }

    @Override
    public boolean isNoFilterValuesSet() {
        return this.txtValue.getText().trim().length() == 0;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        return this.txtValue.getText().trim().length() != 0;
    }

    private void updateFilter() {
        this.value = this.txtValue.getText().trim();
        this.setSelected(this.value.length() > 0);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setFilterValue(this.value);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.value = this.filter.getFilterValue();
    }

    @Override
    public void filterHasChanged() {
        this.value = this.filter.getFilterValue();
    }
}

