/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractShortValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ShortListFilterItem
extends AbstractFilterItem {
    private static final String FILTER_INFO_SEPARATOR = ", ";
    private String name = null;
    private final List<String> texts = new ArrayList<String>();
    private final List<Short> shortValues = new ArrayList<Short>();
    private AbstractShortValuesFilter filter = null;
    private final List<Button> tableItems = new ArrayList<Button>();
    private HashSet<Short> passValues;

    public ShortListFilterItem(String name, AbstractShortValuesFilter filter) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        this.passValues = new HashSet<Short>(filter.getPassValues());
    }

    public void addFilterValue(String text, Short value) {
        this.texts.add(text);
        this.shortValues.add(value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        StringBuilder filterInfo = new StringBuilder();
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            if (filterInfo.length() > 0) {
                filterInfo.append(FILTER_INFO_SEPARATOR);
            }
            filterInfo.append(button.getText());
        }
        return filterInfo.toString();
    }

    @Override
    public void refresh() {
        for (Button button : this.tableItems) {
            this.updateValueCheckState(button);
        }
    }

    @Override
    public Control createContent(Composite parent) {
        Group composite = new Group(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.verticalSpacing = 2;
        compositeLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeGD = new GridData(1808);
        composite.setLayoutData((Object)compositeGD);
        composite.setText(this.getName());
        int i = 0;
        while (i < this.texts.size()) {
            Button button = new Button((Composite)composite, 32);
            String text = this.texts.get(i);
            Short value = this.shortValues.get(i);
            button.setText(text);
            button.setData((Object)value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ShortListFilterItem.this.updateFilter();
                    ShortListFilterItem.this.fireValueChanged();
                }
            });
            this.updateValueCheckState(button);
            this.tableItems.add(button);
            ++i;
        }
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ShortListFilterItem.this.tableItems.clear();
            }
        });
        return composite;
    }

    @Override
    public boolean isNoFilterValuesSet() {
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        for (Button button : this.tableItems) {
            if (button.getSelection()) continue;
            return false;
        }
        return true;
    }

    private void updateFilter() {
        boolean activateFilter = false;
        this.passValues.clear();
        for (Button button : this.tableItems) {
            if (!button.getSelection()) continue;
            Short value = (Short)button.getData();
            this.passValues.add(value);
            activateFilter |= true;
        }
        this.setSelected(activateFilter);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setPassValues(this.passValues);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.passValues = new HashSet<Short>(this.filter.getPassValues());
    }

    private void updateValueCheckState(Button button) {
        Short value = (Short)button.getData();
        boolean selected = this.passValues.contains(value);
        button.setSelection(selected);
    }

    @Override
    public void filterHasChanged() {
        this.passValues = new HashSet<Short>(this.filter.getPassValues());
    }
}

