/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import com.arcway.cockpit.cockpitlib.client.filter.gui.SortedTableListFilterItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class InvertibleTableListFilterItem
extends SortedTableListFilterItem {
    private Button isNotInverted;
    private Button isInverted;
    private boolean invert;

    public InvertibleTableListFilterItem(String name, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.invert = filter.isInvert();
    }

    @Override
    public String getFilterInfo() {
        String filterInfo = super.getFilterInfo();
        if (filterInfo != null && filterInfo.length() > 0) {
            if (this.invert) {
                return String.valueOf(Messages.getString("InvertableTableListFilterItem.0")) + filterInfo;
            }
            return filterInfo;
        }
        return null;
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public Control createContent(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(1808));
        Group group = new Group(c, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        group.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.isNotInverted = new Button((Composite)group, 16);
        this.isNotInverted.setText(Messages.getString("InvertableTableListFilterItem.1"));
        this.isNotInverted.setSelection(!this.filter.isInvert());
        this.isInverted = new Button((Composite)group, 16);
        this.isInverted.setText(Messages.getString("InvertableTableListFilterItem.2"));
        this.isInverted.setSelection(this.filter.isInvert());
        this.isNotInverted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InvertibleTableListFilterItem.this.updateFilter();
                InvertibleTableListFilterItem.this.fireValueChanged();
            }
        });
        super.createContent(c);
        return c;
    }

    @Override
    protected void updateFilter() {
        super.updateFilter();
        boolean bl = this.invert = !this.isNotInverted.getSelection();
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setInvert(this.invert);
        super.doConfirmSelection();
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.invert = this.filter.isInvert();
        super.resetFilterValueToFilterState();
    }
}

