/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractIntegerFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import de.plans.lib.util.LongVerifyListener;
import de.plans.lib.util.NumberVerifyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IntegerFilterItem
extends AbstractFilterItem {
    private final AbstractIntegerFilter filter;
    private long firstValue = 0L;
    private long secondValue = 0L;
    private String filterMethod = FILTER_METHOD_ORDER[0];
    private Combo filterMethodCombo;
    private Text val1Text;
    private Text val2Text;
    private static final String[] FILTER_METHOD_ORDER = new String[]{"filtermethod-greater", "filtermethod-less", "filtermethod-between", "filtermethod-equal"};
    private static final String METHOD_NAME_GREATER = ">=";
    private static final String METHOD_NAME_LESS = "<=";
    private static final String METHOD_NAME_BETWEEN = Messages.getString("IntegerFilterItem.FilterMethodBetween");
    private static final String METHOD_NAME_EQUALS = "=";
    private static final String[] FILTER_METHOD_NAMES = new String[]{">=", "<=", METHOD_NAME_BETWEEN, "="};

    public IntegerFilterItem(String name, AbstractIntegerFilter filter) {
        super(name, filter);
        this.filter = filter;
        this.readSettingsFromFilter();
    }

    @Override
    public void doConfirmSelection() {
        this.writeSettingsToFilter();
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.readSettingsFromFilter();
    }

    @Override
    public void refresh() {
        this.filterMethodCombo.select(this.getFilterMethodIndex(this.filterMethod));
        this.val1Text.setText(new Long(this.firstValue).toString());
        this.val2Text.setText(new Long(this.secondValue).toString());
        this.updateSecondValueTextFieldVisibility();
    }

    @Override
    public void filterHasChanged() {
        this.readSettingsFromFilter();
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        String filterMethodName = FILTER_METHOD_NAMES[this.getFilterMethodIndex(this.filterMethod)];
        String filterInfo = String.valueOf(filterMethodName) + " " + this.val1Text.getText();
        if (this.filterMethod.equals("filtermethod-between")) {
            filterInfo = String.valueOf(filterInfo) + " " + Messages.getString("IntegerFilterItem.AND") + " " + this.val2Text.getText();
        }
        return filterInfo;
    }

    @Override
    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(3, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        groupGD.widthHint = 200;
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        this.filterMethodCombo = new Combo((Composite)group, 12);
        GridData filterMethodComboGD = new GridData();
        filterMethodComboGD.widthHint = 50;
        this.filterMethodCombo.setLayoutData((Object)filterMethodComboGD);
        String[] stringArray = FILTER_METHOD_NAMES;
        int n = FILTER_METHOD_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.filterMethodCombo.add(element);
            ++n2;
        }
        this.filterMethodCombo.select(0);
        this.filterMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegerFilterItem.this.updateSecondValueTextFieldVisibility();
                IntegerFilterItem.this.updateFilter();
                IntegerFilterItem.this.fireValueChanged();
            }
        });
        this.val1Text = new Text((Composite)group, 2052);
        GridData firstDateTextGD = new GridData();
        firstDateTextGD.widthHint = 75;
        this.val1Text.setLayoutData((Object)firstDateTextGD);
        this.val1Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IntegerFilterItem.this.val1Text.selectAll();
            }

            public void focusLost(FocusEvent e) {
                IntegerFilterItem.this.updateFilter();
                IntegerFilterItem.this.fireValueChanged();
            }
        });
        this.val1Text.addVerifyListener((VerifyListener)this.createVerifyListener(this.val1Text));
        this.val2Text = new Text((Composite)group, 2052);
        GridData secondDateTextGD = new GridData();
        secondDateTextGD.widthHint = 75;
        secondDateTextGD.horizontalSpan = 2;
        secondDateTextGD.horizontalAlignment = 3;
        this.val2Text.setLayoutData((Object)secondDateTextGD);
        this.val2Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IntegerFilterItem.this.val2Text.selectAll();
            }

            public void focusLost(FocusEvent e) {
                IntegerFilterItem.this.updateFilter();
                IntegerFilterItem.this.fireValueChanged();
            }
        });
        this.val2Text.addVerifyListener((VerifyListener)this.createVerifyListener(this.val2Text));
        this.refresh();
        return group;
    }

    private void updateFilter() {
        this.setSelected(this.isAllFilterValuesSet());
        try {
            this.firstValue = Long.parseLong(this.val1Text.getText());
            if (this.val2Text.isVisible()) {
                this.secondValue = Long.parseLong(this.val2Text.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.filterMethod = FILTER_METHOD_ORDER[this.filterMethodCombo.getSelectionIndex()];
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public boolean isAllFilterValuesSet() {
        return !this.isNoFilterValuesSet();
    }

    @Override
    public boolean isNoFilterValuesSet() {
        return this.val1Text.getText().length() == 0 || this.filterMethodCombo.getText().equals(METHOD_NAME_BETWEEN) && this.val2Text.getText().length() == 0;
    }

    private void updateSecondValueTextFieldVisibility() {
        this.val2Text.setVisible(this.filterMethodCombo.getText().equals(METHOD_NAME_BETWEEN));
    }

    private void readSettingsFromFilter() {
        this.firstValue = this.filter.getFirstValue();
        this.secondValue = this.filter.getSecondValue();
        this.filterMethod = this.filter.getFilterMethod();
    }

    private void writeSettingsToFilter() {
        this.filter.setFirstValue(this.firstValue);
        this.filter.setSecondValue(this.secondValue);
        this.filter.setFilterMethod(this.filterMethod);
    }

    private NumberVerifyListener createVerifyListener(Text textField) {
        return new LongVerifyListener(textField, false);
    }

    private int getFilterMethodIndex(String filterMethod_) {
        int c = 0;
        while (c < FILTER_METHOD_ORDER.length) {
            if (FILTER_METHOD_ORDER[c].equals(filterMethod_)) {
                return c;
            }
            ++c;
        }
        return -1;
    }
}

