/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.gui.FilterItemGroup;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IValueChangedListener;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import com.arcway.cockpit.cockpitlib.client.plugin.CockpitLibPlugin;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FilterDialogPart
implements IValueChangedListener {
    private final List<IFilterItem> filterItemList = new ArrayList<IFilterItem>();
    private final List<FilterItemGroup> groupList = new ArrayList<FilterItemGroup>();
    private Tree filterTree = null;
    private final List<TreeItem> filterTreeItemList = new ArrayList<TreeItem>();
    private ScrolledComposite filterAttributeValuesContainer = null;
    private final Map<IFilterItem, Control> filterItemContents = new HashMap<IFilterItem, Control>();
    private boolean isConfirmNecessary = false;
    private static final ImageDescriptor IMAGE_DESC_FILTER_ACTIVE = ResourceLoader.getImageDescriptor((Plugin)CockpitLibPlugin.getDefault(), (String)"icons/filter_active.gif");
    private Image imageFilterActive = null;
    private static final ImageDescriptor IMAGE_DESC_FILTER_NOT_ACTIVE = ResourceLoader.getImageDescriptor((Plugin)CockpitLibPlugin.getDefault(), (String)"icons/filter_not_active.gif");
    private Image imageFilterNotActive = null;

    public FilterDialogPart() {
    }

    public FilterDialogPart(boolean isConfirmNecessary) {
        this.isConfirmNecessary = isConfirmNecessary;
    }

    public void addItem(IFilterItem item) {
        this.filterItemList.add(item);
        item.setUserConfirmationNecessary(this.isConfirmNecessary);
    }

    public void addGroup(FilterItemGroup group) {
        for (IFilterItem item : group.getAll()) {
            item.setUserConfirmationNecessary(this.isConfirmNecessary);
        }
        this.groupList.add(group);
    }

    public void confirmSelection() {
        for (IFilterItem item : this.getAllFilters()) {
            item.confirmSelection();
        }
    }

    public void discardSelection() {
        for (IFilterItem item : this.getAllFilters()) {
            item.resetAllSettingsToFilterState();
        }
    }

    private Collection<IFilterItem> getAllFilters() {
        ArrayList<IFilterItem> allFilters = new ArrayList<IFilterItem>(this.filterItemList);
        for (FilterItemGroup group : this.groupList) {
            allFilters.addAll(group.getAll());
        }
        return allFilters;
    }

    public Control createContent(Composite parent) {
        this.imageFilterActive = IMAGE_DESC_FILTER_ACTIVE.createImage();
        this.imageFilterNotActive = IMAGE_DESC_FILTER_NOT_ACTIVE.createImage();
        SashForm filterComposite = new SashForm(parent, 0);
        GridData filterCompositeGD = new GridData(4, 4, true, true);
        filterCompositeGD.heightHint = 300;
        filterCompositeGD.widthHint = 300;
        filterComposite.setLayoutData((Object)filterCompositeGD);
        this.createFilterAttributesContainer((Composite)filterComposite);
        this.createFilterAttributeValuesContainer((Composite)filterComposite);
        this.refresh();
        return filterComposite;
    }

    private void createFilterAttributesContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginHeight = 2;
        compositeLayout.marginWidth = 1;
        composite.setLayout((Layout)compositeLayout);
        this.filterTree = new Tree(composite, 2080);
        GridData filterTreeGD = new GridData(4, 4, true, true);
        filterTreeGD.widthHint = 140;
        this.filterTree.setLayoutData((Object)filterTreeGD);
        for (FilterItemGroup group : this.groupList) {
            TreeItem groupTreeItem = new TreeItem(this.filterTree, 0);
            groupTreeItem.setText(group.getName());
            groupTreeItem.setData((Object)group);
            this.filterTreeItemList.add(groupTreeItem);
            for (IFilterItem filterItem : group.getAll()) {
                filterItem.addValueChangedListener(this);
                TreeItem filterTreeItem = new TreeItem(groupTreeItem, 0);
                filterTreeItem.setText(filterItem.getName());
                filterTreeItem.setData((Object)filterItem);
                this.filterTreeItemList.add(filterTreeItem);
            }
        }
        for (IFilterItem filterItem : this.filterItemList) {
            filterItem.addValueChangedListener(this);
            TreeItem filterTreeItem = new TreeItem(this.filterTree, 0);
            filterTreeItem.setText(filterItem.getName());
            filterTreeItem.setData((Object)filterItem);
            this.filterTreeItemList.add(filterTreeItem);
        }
        this.filterTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem item = (TreeItem)event.item;
                if (event.detail == 32) {
                    FilterDialogPart.this.checkItem(item);
                }
                FilterDialogPart.this.selectItem(item);
            }
        });
        this.filterTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (FilterItemGroup group : FilterDialogPart.this.groupList) {
                    for (IFilterItem filterItem : group.getAll()) {
                        filterItem.removeValueChangedListener(FilterDialogPart.this);
                    }
                }
                for (IFilterItem filterItem : FilterDialogPart.this.filterItemList) {
                    filterItem.removeValueChangedListener(FilterDialogPart.this);
                }
                if (FilterDialogPart.this.imageFilterActive != null && !FilterDialogPart.this.imageFilterActive.isDisposed()) {
                    FilterDialogPart.this.imageFilterActive.dispose();
                }
                if (FilterDialogPart.this.imageFilterNotActive != null && !FilterDialogPart.this.imageFilterNotActive.isDisposed()) {
                    FilterDialogPart.this.imageFilterNotActive.dispose();
                }
            }
        });
    }

    private void createFilterAttributeValuesContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginHeight = 2;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        this.filterAttributeValuesContainer = new ScrolledComposite(composite, 768);
        this.filterAttributeValuesContainer.setExpandHorizontal(true);
        this.filterAttributeValuesContainer.setExpandVertical(true);
        this.filterAttributeValuesContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        for (FilterItemGroup group : this.groupList) {
            for (IFilterItem filterItem : group.getAll()) {
                Control control = filterItem.createContent((Composite)this.filterAttributeValuesContainer);
                filterItem.refresh();
                this.filterItemContents.put(filterItem, control);
            }
        }
        for (IFilterItem filterItem : this.filterItemList) {
            Control control = filterItem.createContent((Composite)this.filterAttributeValuesContainer);
            filterItem.refresh();
            this.filterItemContents.put(filterItem, control);
        }
    }

    @Override
    public void valueChanged() {
        this.refresh();
    }

    public void refresh() {
        this.updateCheckStates();
        this.updateFilterInfo();
    }

    private void updateFilterInfo() {
        for (TreeItem treeItem : this.filterTreeItemList) {
            String newText;
            Object data = treeItem.getData();
            if (data == null) continue;
            if (data instanceof IFilterItem) {
                IFilterItem filterItem = (IFilterItem)data;
                if (filterItem.isSelected()) {
                    String filterInfo = filterItem.getFilterInfo();
                    if (filterInfo != null) {
                        String filterName = filterItem.getName();
                        newText = String.valueOf(filterName) + " (" + filterInfo + ")";
                        treeItem.setText(newText);
                    }
                } else {
                    String newText2 = filterItem.getName();
                    treeItem.setText(newText2);
                }
            }
            if (!(data instanceof FilterItemGroup)) continue;
            FilterItemGroup group = (FilterItemGroup)data;
            TreeItem[] children = treeItem.getItems();
            int counter = 0;
            TreeItem[] treeItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem element = treeItemArray[n2];
                if (element.getChecked()) {
                    ++counter;
                }
                ++n2;
            }
            newText = String.valueOf(Messages.getString("FilterDialogPart.3")) + " " + group.getName();
            if (counter > 0) {
                newText = counter < children.length ? String.valueOf(newText) + " (" + counter + " " + Messages.getString("FilterDialogPart.0") + ")" : String.valueOf(newText) + " (" + Messages.getString("FilterDialogPart.1") + ")";
            }
            treeItem.setText(newText);
        }
    }

    private void updateCheckStates() {
        TreeItem[] rootItems;
        TreeItem[] treeItemArray = rootItems = this.filterTree.getItems();
        int n = rootItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem element = treeItemArray[n2];
            Object data = element.getData();
            if (data != null) {
                if (data instanceof FilterItemGroup) {
                    TreeItem[] items = element.getItems();
                    boolean checkGroupItem = false;
                    TreeItem[] treeItemArray2 = items;
                    int n3 = items.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem element2 = treeItemArray2[n4];
                        Object itemData = element2.getData();
                        if (itemData != null && itemData instanceof IFilterItem) {
                            IFilterItem filterItem = (IFilterItem)itemData;
                            boolean itemSelected = filterItem.isSelected();
                            element2.setChecked(itemSelected);
                            checkGroupItem |= itemSelected;
                            this.setItemImage(element2);
                        }
                        ++n4;
                    }
                    element.setChecked(checkGroupItem);
                    this.setItemImage(element);
                } else if (data instanceof IFilterItem) {
                    IFilterItem filterItem = (IFilterItem)data;
                    element.setChecked(filterItem.isSelected());
                    this.setItemImage(element);
                }
            }
            ++n2;
        }
    }

    private void checkItem(TreeItem item) {
        Object data = item.getData();
        if (data instanceof IFilterItem) {
            FilterDialogPart.checkFilterItem(item);
        } else if (data instanceof FilterItemGroup) {
            this.checkGroupItem(item);
        }
    }

    private void setItemImage(TreeItem item) {
        if (item.getChecked()) {
            item.setImage(this.imageFilterActive);
        } else {
            item.setImage(this.imageFilterNotActive);
        }
    }

    private static void checkFilterItem(TreeItem item) {
        IFilterItem filterItem = (IFilterItem)item.getData();
        filterItem.setSelected(item.getChecked());
    }

    private void checkGroupItem(TreeItem item) {
        TreeItem[] children;
        TreeItem[] treeItemArray = children = item.getItems();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem element = treeItemArray[n2];
            element.setChecked(item.getChecked());
            this.checkItem(element);
            ++n2;
        }
    }

    private void selectItem(TreeItem item) {
        this.filterTree.setSelection(new TreeItem[]{item});
        Object data = item.getData();
        if (data instanceof IFilterItem) {
            this.selectFilterItem(item);
        } else if (data instanceof FilterItemGroup) {
            this.selectGroupItem(item);
        }
        this.updateCheckStates();
        this.updateFilterInfo();
    }

    private void selectGroupItem(TreeItem item) {
        assert (item != null);
        this.setFilterAttributeValuesContainerContent(null);
    }

    private void selectFilterItem(TreeItem item) {
        IFilterItem filterItem = (IFilterItem)item.getData();
        Control comp = this.filterItemContents.get(filterItem);
        this.setFilterAttributeValuesContainerContent(comp);
    }

    private void setFilterAttributeValuesContainerContent(Control content) {
        if (content != null) {
            this.filterAttributeValuesContainer.setMinSize(content.computeSize(-1, -1));
        } else {
            this.filterAttributeValuesContainer.setMinSize(1, 1);
        }
        this.filterAttributeValuesContainer.setContent(content);
    }
}

