/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractDateValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DateFilterItem
extends AbstractFilterItem {
    private static final String FILTER_EQUALS = Messages.getString("DateFilterItem.0");
    private static final String FILTER_LESS_THAN = Messages.getString("DateFilterItem.1");
    private static final String FILTER_GREATER_THAN = Messages.getString("DateFilterItem.2");
    private static final String FILTER_NULL = Messages.getString("DateFilterItem.4");
    private static final String FILTER_BETWEEN = Messages.getString("DateFilterItem.5");
    private static Map<String, String> filterMethodMap = new HashMap<String, String>(5);
    private static Map<String, String> filterMethodDisplay;
    private String name = null;
    private AbstractDateValuesFilter filter = null;
    private Combo filterMethodCombo = null;
    private DateTime firstDateWidget = null;
    private DateTime secondDateWidget = null;
    private String filterMethod;
    private Date firstDate;
    private Date secondDate;
    private final Calendar cal;

    static {
        filterMethodMap.put("is", FILTER_EQUALS);
        filterMethodMap.put("before", FILTER_LESS_THAN);
        filterMethodMap.put("after", FILTER_GREATER_THAN);
        filterMethodMap.put("null", FILTER_NULL);
        filterMethodMap.put("between", FILTER_BETWEEN);
        filterMethodDisplay = new HashMap<String, String>(5);
        filterMethodDisplay.put(FILTER_EQUALS, "is");
        filterMethodDisplay.put(FILTER_LESS_THAN, "before");
        filterMethodDisplay.put(FILTER_GREATER_THAN, "after");
        filterMethodDisplay.put(FILTER_NULL, "null");
        filterMethodDisplay.put(FILTER_BETWEEN, "between");
    }

    public DateFilterItem(String name, AbstractDateValuesFilter filter) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        this.filterMethod = filter.getFilterMethod();
        this.firstDate = filter.getFirstDateValue();
        this.secondDate = filter.getSecondDateValue();
        this.cal = Calendar.getInstance();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        String filterInfo = filterMethodMap.get(this.filterMethod);
        DateFormat dateFormat = DateFormat.getDateInstance();
        if (!this.filterMethod.equals("null")) {
            this.cal.set(5, this.firstDateWidget.getDay());
        }
        this.cal.set(2, this.firstDateWidget.getMonth());
        this.cal.set(1, this.firstDateWidget.getYear());
        filterInfo = String.valueOf(filterInfo) + " " + dateFormat.format(this.cal.getTime());
        if (this.filterMethod.equals("between")) {
            filterInfo = String.valueOf(filterInfo) + " " + Messages.getString("DateFilterItem.7") + " ";
            this.cal.set(5, this.secondDateWidget.getDay());
            this.cal.set(2, this.secondDateWidget.getMonth());
            this.cal.set(1, this.secondDateWidget.getYear());
            filterInfo = String.valueOf(filterInfo) + " " + dateFormat.format(this.cal.getTime());
        }
        return filterInfo;
    }

    @Override
    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(3, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        groupGD.widthHint = 200;
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        this.filterMethodCombo = new Combo((Composite)group, 12);
        GridData filterMethodComboGD = new GridData();
        filterMethodComboGD.widthHint = 50;
        this.filterMethodCombo.setLayoutData((Object)filterMethodComboGD);
        this.filterMethodCombo.add(FILTER_EQUALS);
        this.filterMethodCombo.add(FILTER_LESS_THAN);
        this.filterMethodCombo.add(FILTER_GREATER_THAN);
        this.filterMethodCombo.add(FILTER_NULL);
        this.filterMethodCombo.add(FILTER_BETWEEN);
        this.filterMethodCombo.select(0);
        this.filterMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateFilterItem.this.enableDateFields();
                DateFilterItem.this.updateFilter();
                DateFilterItem.this.fireValueChanged();
            }
        });
        this.firstDateWidget = new DateTime((Composite)group, 32);
        this.firstDateWidget.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DateFilterItem.this.updateFilter();
                DateFilterItem.this.fireValueChanged();
            }
        });
        GridData firstDateWidgetGD = new GridData();
        firstDateWidgetGD.widthHint = 75;
        this.firstDateWidget.setLayoutData((Object)firstDateWidgetGD);
        this.secondDateWidget = new DateTime((Composite)group, 32);
        this.secondDateWidget.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DateFilterItem.this.updateFilter();
                DateFilterItem.this.fireValueChanged();
            }
        });
        GridData secondDateWidgetGD = new GridData();
        secondDateWidgetGD.widthHint = 75;
        secondDateWidgetGD.horizontalSpan = 2;
        secondDateWidgetGD.horizontalAlignment = 3;
        this.secondDateWidget.setLayoutData((Object)secondDateWidgetGD);
        this.refresh();
        return group;
    }

    private void enableDateFields() {
        if (this.filterMethodCombo.getText().equals(FILTER_BETWEEN)) {
            this.showFirstDate(true);
            this.showSecondDate(true);
        } else if (this.filterMethodCombo.getText().equals(FILTER_NULL)) {
            this.showFirstDate(false);
            this.showSecondDate(false);
        } else {
            this.showFirstDate(true);
            this.showSecondDate(false);
        }
    }

    @Override
    public boolean isNoFilterValuesSet() {
        boolean noValuesSet = true;
        DateFormat dateFormat = DateFormat.getDateInstance();
        this.cal.set(5, this.firstDateWidget.getDay());
        this.cal.set(2, this.firstDateWidget.getMonth());
        this.cal.set(1, this.firstDateWidget.getYear());
        String filterInfo = dateFormat.format(this.cal.getTime());
        return noValuesSet &= filterInfo.length() == 0;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        boolean allValuesSet = true;
        DateFormat dateFormat = DateFormat.getDateInstance();
        this.cal.set(5, this.firstDateWidget.getDay());
        this.cal.set(2, this.firstDateWidget.getMonth());
        this.cal.set(1, this.firstDateWidget.getYear());
        String filterInfo = dateFormat.format(this.cal.getTime());
        return allValuesSet &= filterInfo.length() > 0;
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setFilterValue(this.filterMethod);
        this.filter.setDateValue(this.firstDate, this.secondDate);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.filterMethod = this.filter.getFilterMethod();
        this.firstDate = this.filter.getDateValue();
        this.secondDate = this.filter.getSecondDateValue();
    }

    private void updateFilter() {
        boolean activateFilter = false;
        this.setSelected(activateFilter |= this.firstDateWidget.getDay() > 0);
        this.cal.set(5, this.firstDateWidget.getDay());
        this.cal.set(2, this.firstDateWidget.getMonth());
        this.cal.set(1, this.firstDateWidget.getYear());
        Date _firstDate = this.cal.getTime();
        this.cal.set(5, this.secondDateWidget.getDay());
        this.cal.set(2, this.secondDateWidget.getMonth());
        this.cal.set(1, this.secondDateWidget.getYear());
        Date _secondDate = this.cal.getTime();
        this.firstDate = _firstDate;
        this.secondDate = _secondDate;
        String shownFilterMethod = filterMethodDisplay.get(this.filterMethodCombo.getText());
        if (shownFilterMethod != null) {
            this.filterMethod = shownFilterMethod;
        }
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void refresh() {
        this.showSecondDate(false);
        if (this.filterMethod.equals("is")) {
            this.filterMethodCombo.select(0);
        }
        if (this.filterMethod.equals("before")) {
            this.filterMethodCombo.select(1);
        }
        if (this.filterMethod.equals("after")) {
            this.filterMethodCombo.select(2);
        }
        if (this.filterMethod.equals("null")) {
            this.filterMethodCombo.select(3);
        }
        if (this.filterMethod.equals("between")) {
            this.filterMethodCombo.select(4);
        }
        Date firstDateTimestamp = this.firstDate;
        this.cal.setTime(firstDateTimestamp);
        this.firstDateWidget.setDay(this.cal.get(5));
        this.firstDateWidget.setMonth(this.cal.get(2));
        this.firstDateWidget.setYear(this.cal.get(1));
        Date secondDateTimestamp = this.secondDate;
        this.cal.setTime(secondDateTimestamp);
        this.secondDateWidget.setDay(this.cal.get(5));
        this.secondDateWidget.setMonth(this.cal.get(2));
        this.secondDateWidget.setYear(this.cal.get(1));
        this.enableDateFields();
    }

    private void showFirstDate(boolean value) {
        this.firstDateWidget.setVisible(value);
    }

    private void showSecondDate(boolean value) {
        this.secondDateWidget.setVisible(value);
    }

    @Override
    public void filterHasChanged() {
        this.filterMethod = this.filter.getFilterMethod();
        this.firstDate = this.filter.getFirstDateValue();
        this.secondDate = this.filter.getSecondDateValue();
    }
}

