/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractBooleanValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class BooleanFilterItem
extends AbstractFilterItem {
    private String name = null;
    private AbstractBooleanValueFilter filter = null;
    private Button checkBoolean = null;
    private boolean value;

    public BooleanFilterItem(String name, AbstractBooleanValueFilter filter) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        this.value = filter.getValue();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilterInfo() {
        return this.value ? Messages.getString("BooleanFilterItem.0") : Messages.getString("BooleanFilterItem.1");
    }

    @Override
    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        this.checkBoolean = new Button((Composite)group, 32);
        this.checkBoolean.setLayoutData((Object)new GridData(768));
        this.checkBoolean.setText(this.name);
        this.checkBoolean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BooleanFilterItem.this.updateFilter();
                BooleanFilterItem.this.fireValueChanged();
            }
        });
        this.update();
        return group;
    }

    @Override
    public boolean isNoFilterValuesSet() {
        return !this.value;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        return this.value;
    }

    private void updateFilter() {
        this.value = this.checkBoolean.getSelection();
        super.setSelected(true);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setValue(this.value);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.value = this.filter.getValue();
    }

    private void update() {
        this.checkBoolean.setSelection(this.value);
    }

    @Override
    public void refresh() {
        this.checkBoolean.setSelection(this.value);
    }

    @Override
    public void filterHasChanged() {
        this.value = this.filter.getValue();
    }
}

