/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.lib.eclipse.gui.viewers.UsableCheckboxTreeViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractTreeListFilterItem<T>
extends AbstractFilterItem {
    private static final String SEPARATOR = ", ";
    private final String name;
    private final AbstractTextValuesFilter filter;
    private final ITreeListFilterDataProvider<T> dataProvider;
    private final boolean selectAncestorsAutomatically;
    private final List<String> passValues;
    private UsableCheckboxTreeViewer treeViewer;

    public AbstractTreeListFilterItem(String name, AbstractTextValuesFilter filter, boolean selectAncestorsAutomatically) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        this.dataProvider = this.getDataProvider();
        this.selectAncestorsAutomatically = selectAncestorsAutomatically;
        this.passValues = new ArrayList<String>(filter.getPassValues());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setPassValues(this.passValues);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.doDiscardSelection();
    }

    @Override
    public void filterHasChanged() {
        this.doDiscardSelection();
    }

    private void doDiscardSelection() {
        this.passValues.clear();
        this.passValues.addAll(this.filter.getPassValues());
    }

    @Override
    public void refresh() {
        if (this.treeViewer != null) {
            this.treeViewer.setCheckedElements(this.dataProvider.getItemsForUIDs(this.passValues).toArray());
        }
    }

    @Override
    public Control createContent(Composite parent) {
        this.dataProvider.flushCache();
        this.treeViewer = this.selectAncestorsAutomatically ? new UsableCheckboxTreeViewer(parent, 2) : new UsableCheckboxTreeViewer(parent, 3);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setInput(new Object());
        this.treeViewer.setUncheckableElements(this.dataProvider.getAllUnselectableItems());
        Collection<T> checkedElements = this.dataProvider.getItemsForUIDs(this.passValues);
        this.treeViewer.setCheckedElements(checkedElements.toArray());
        this.treeViewer.expandAll();
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AbstractTreeListFilterItem.this.updateFilter();
                AbstractTreeListFilterItem.this.fireValueChanged();
            }
        });
        return this.treeViewer.getControl();
    }

    protected void updateFilter() {
        this.passValues.clear();
        Object[] objectArray = this.treeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement;
            Object item = checkedElement = objectArray[n2];
            this.passValues.add(this.dataProvider.getUID(item));
            ++n2;
        }
        this.setSelected(!this.passValues.isEmpty());
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        StringBuffer filterInfo = new StringBuffer();
        Object[] objectArray = this.treeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement;
            Object item = checkedElement = objectArray[n2];
            filterInfo.append(this.dataProvider.getLabel(item));
            filterInfo.append(SEPARATOR);
            ++n2;
        }
        if (filterInfo.length() > 0) {
            return filterInfo.substring(0, filterInfo.length() - SEPARATOR.length());
        }
        return "";
    }

    @Override
    public boolean isAllFilterValuesSet() {
        return false;
    }

    @Override
    public boolean isNoFilterValuesSet() {
        return this.treeViewer.getCheckedElements().length == 0;
    }

    protected abstract ITreeListFilterDataProvider<T> getDataProvider();

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List rootItems = AbstractTreeListFilterItem.this.dataProvider.getRootItems();
            return rootItems != null ? rootItems.toArray() : new Object[]{};
        }

        public Object[] getChildren(Object parentElement) {
            Object parent = parentElement;
            List<Object> children = AbstractTreeListFilterItem.this.dataProvider.getChildren(parent);
            return children != null ? children.toArray() : new Object[]{};
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static interface ITreeListFilterDataProvider<T> {
        public void flushCache();

        public List<? extends T> getRootItems();

        public List<? extends T> getChildren(T var1);

        public Set<? extends T> getAllUnselectableItems();

        public boolean isItemSelectable(T var1);

        public String getLabel(T var1);

        public Image getImage(T var1);

        public String getUID(T var1);

        public Collection<? extends T> getItemsForUIDs(Collection<String> var1);
    }

    private class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public String getText(Object element) {
            Object item = element;
            String label = AbstractTreeListFilterItem.this.dataProvider.getLabel(item);
            if (!AbstractTreeListFilterItem.this.dataProvider.isItemSelectable(item)) {
                label = "[" + label + "]";
            }
            return label;
        }

        public Image getImage(Object element) {
            Object item = element;
            return AbstractTreeListFilterItem.this.dataProvider.getImage(item);
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

