/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IValueChangedListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFilterItem
implements IFilterItem {
    private final List valueChangedListener = new ArrayList();
    private final String name;
    private final AbstractFilter filter;
    private boolean selected;
    private boolean applyFilterChanges = true;
    private boolean isUserConfirmationNecessary = false;

    public AbstractFilterItem(String name, AbstractFilter filter) {
        assert (filter != null) : "filter is null";
        assert (name != null) : "name must not be null";
        this.name = name;
        this.filter = filter;
        filter.setFilterItem(this);
        this.selected = filter.isActive();
    }

    protected boolean isUserConfirmationNecessary() {
        return this.isUserConfirmationNecessary;
    }

    @Override
    public void confirmSelection() {
        this.applyFilterChanges = false;
        this.doConfirmSelection();
        this.filter.setActive(this.selected);
        this.applyFilterChanges = true;
    }

    public abstract void doConfirmSelection();

    @Override
    public final void resetAllSettingsToFilterState() {
        this.selected = this.filter.isActive();
        this.resetFilterValueToFilterState();
    }

    protected abstract void resetFilterValueToFilterState();

    @Override
    public void setUserConfirmationNecessary(boolean confirmNecessary) {
        this.isUserConfirmationNecessary = confirmNecessary;
    }

    @Override
    public void addValueChangedListener(IValueChangedListener listener) {
        assert (listener != null) : "ValueChangedListener is null";
        this.valueChangedListener.add(listener);
    }

    @Override
    public void removeValueChangedListener(IValueChangedListener listener) {
        assert (listener != null) : "ValueChangedListener is null";
        this.valueChangedListener.remove(listener);
    }

    protected void fireValueChanged() {
        for (IValueChangedListener listener : this.valueChangedListener) {
            listener.valueChanged();
        }
    }

    @Override
    public abstract void refresh();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selection) {
        this.selected = selection;
        if (!this.isUserConfirmationNecessary) {
            this.confirmSelection();
        }
    }

    @Override
    public AbstractFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractFilterItem)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AbstractFilterItem filterItem = (AbstractFilterItem)obj;
        if (this.filter == null || filterItem.getFilter() == null) {
            return false;
        }
        return this.filter.getFilterID().equals(filterItem.getFilter().getFilterID());
    }

    public int hashCode() {
        if (this.filter == null) {
            return super.hashCode();
        }
        return this.filter.getFilterID().hashCode();
    }

    public abstract void filterHasChanged();

    @Override
    public void filterChanged() {
        if (this.applyFilterChanges) {
            this.filterHasChanged();
            this.resetAllSettingsToFilterState();
        }
    }
}

