/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractIntegerFilter
extends AbstractFilter {
    public static final String FILTER_METHOD_GREATER = "filtermethod-greater";
    public static final String FILTER_METHOD_LESS = "filtermethod-less";
    public static final String FILTER_METHOD_BETWEEN = "filtermethod-between";
    public static final String FILTER_METHOD_EQUALS = "filtermethod-equal";
    private static final char SEPARATOR = ':';
    private long firstValue;
    private long secondValue;
    private String filterMethod;

    public AbstractIntegerFilter() {
        this.resetValue();
    }

    @Override
    public String getFilterValue() {
        return String.valueOf(this.filterMethod) + ':' + this.firstValue + ':' + this.secondValue;
    }

    @Override
    public void setFilterValue(String value) {
        try {
            ArrayList parts = StringUtil.split((String)value, (char)':', (int)-1);
            this.filterMethod = (String)parts.get(0);
            this.firstValue = Long.parseLong((String)parts.get(1));
            this.secondValue = Long.parseLong((String)parts.get(2));
        }
        catch (NumberFormatException nfE) {
            this.resetValue();
        }
        catch (ArrayIndexOutOfBoundsException aioobE) {
            this.resetValue();
        }
        super.setFilterValue(value);
    }

    @Override
    public void resetValue() {
        this.filterMethod = FILTER_METHOD_GREATER;
        this.firstValue = 0L;
        this.secondValue = 0L;
    }

    @Override
    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        long objectsValue = this.getIntegerAttribute(element);
        if (this.filterMethod.equals(FILTER_METHOD_GREATER)) {
            return objectsValue >= this.firstValue;
        }
        if (this.filterMethod.equals(FILTER_METHOD_LESS)) {
            return objectsValue <= this.firstValue;
        }
        if (this.filterMethod.equals(FILTER_METHOD_BETWEEN)) {
            return objectsValue >= this.firstValue && objectsValue <= this.secondValue;
        }
        if (this.filterMethod.equals(FILTER_METHOD_EQUALS)) {
            return objectsValue == this.firstValue;
        }
        return true;
    }

    public long getFirstValue() {
        return this.firstValue;
    }

    public long getSecondValue() {
        return this.secondValue;
    }

    public String getFilterMethod() {
        return this.filterMethod;
    }

    public void setFirstValue(long value) {
        this.firstValue = value;
    }

    public void setSecondValue(long value) {
        this.secondValue = value;
    }

    public void setFilterMethod(String method) {
        this.filterMethod = method;
    }

    protected abstract long getIntegerAttribute(Object var1);
}

