/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractDateValuesFilter
extends AbstractFilter {
    private static final ILogger logger = Logger.getLogger(AbstractDateValuesFilter.class);
    private static final char SEMICOLON = ';';
    public static final String FILTER_EQUALS = "is";
    public static final String FILTER_LESS_THAN = "before";
    public static final String FILTER_GREATER_THAN = "after";
    public static final String FILTER_BETWEEN = "between";
    public static final String FILTER_NULL = "null";
    private String filterMethod = "is";
    private Date dateValue = null;
    private Date secondDate = null;

    @Override
    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        return this.doesItemPassFilter(element);
    }

    private boolean doesItemPassFilter(Object element) {
        Timestamp date = this.getDateAttribute(element);
        if (this.isFilterOnNULL()) {
            return date == null;
        }
        if (date != null) {
            Calendar value = Calendar.getInstance();
            value.setTime(date);
            Calendar firstValue = null;
            if (this.getFirstDateValue() != null) {
                firstValue = Calendar.getInstance();
                firstValue.setTime(this.getFirstDateValue());
            }
            Calendar secondValue = null;
            if (this.getSecondDateValue() != null) {
                secondValue = Calendar.getInstance();
                secondValue.setTime(this.getSecondDateValue());
            }
            if (this.isFilterOnEquals()) {
                return firstValue != null && this.isSameDay(value, firstValue);
            }
            if (this.isFilterOnAfter()) {
                return firstValue != null && this.isSameDayOrAfter(value, firstValue);
            }
            if (this.isFilterOnBefore()) {
                return firstValue != null && this.isSameDayOrBefore(value, firstValue);
            }
            if (this.isFilterOnBetween()) {
                return firstValue != null && secondValue != null && this.isSameDayOrAfter(value, firstValue) && this.isSameDayOrBefore(value, secondValue);
            }
            return true;
        }
        return false;
    }

    public void filterOnEquals() {
        this.filterMethod = FILTER_EQUALS;
    }

    public void filterOnAfter() {
        this.filterMethod = FILTER_GREATER_THAN;
    }

    public void filterOnBefore() {
        this.filterMethod = FILTER_LESS_THAN;
    }

    public void filterOnNull() {
        this.filterMethod = FILTER_NULL;
    }

    public void filterOnBetween() {
        this.filterMethod = FILTER_BETWEEN;
    }

    public boolean isFilterOnEquals() {
        return this.filterMethod.equals(FILTER_EQUALS);
    }

    public boolean isFilterOnBefore() {
        return this.filterMethod.equals(FILTER_LESS_THAN);
    }

    public boolean isFilterOnAfter() {
        return this.filterMethod.equals(FILTER_GREATER_THAN);
    }

    public boolean isFilterOnNULL() {
        return this.filterMethod.equals(FILTER_NULL);
    }

    public boolean isFilterOnBetween() {
        return this.filterMethod.equals(FILTER_BETWEEN);
    }

    public String getFilterMethod() {
        return this.filterMethod;
    }

    public void init(String valueString) {
        if (valueString != null && valueString.length() > 0) {
            long time;
            ArrayList values = StringUtil.split((String)valueString, (char)';');
            if (values.size() > 0) {
                this.filterMethod = (String)values.get(0);
            }
            if (values.size() > 1) {
                time = Long.parseLong((String)values.get(1));
                this.dateValue = new Date(time);
            }
            if (values.size() > 2) {
                time = Long.parseLong((String)values.get(2));
                this.secondDate = new Date(time);
            }
        } else {
            this.dateValue = null;
            this.secondDate = null;
        }
    }

    public String getSettingsAsString() {
        StringBuilder valueString = new StringBuilder();
        Date date = this.getDateValue();
        Date secondDateTmp = this.getSecondDateValue();
        valueString.append(this.filterMethod);
        valueString.append(';');
        valueString.append(new Long(date.getTime()).toString());
        valueString.append(';');
        valueString.append(new Long(secondDateTmp.getTime()).toString());
        return valueString.toString();
    }

    public void setDateValue(String dateString) {
        assert (dateString != null) : "dateString is null";
        this.setDateValue(dateString, dateString);
    }

    public void setDateValue(String startDate, String endDate) {
        assert (startDate != null) : "startDate string is null";
        assert (endDate != null) : "endDate string is null";
        try {
            DateFormat dateFormat = DateFormat.getDateInstance();
            this.dateValue = dateFormat.parse(startDate);
            this.secondDate = dateFormat.parse(endDate);
        }
        catch (ParseException e) {
            logger.error("setDateValue(startDate = " + startDate + ", endDate = " + endDate + ") - Parsing date values failed", (Throwable)e);
            this.dateValue = null;
            this.secondDate = null;
        }
    }

    public void setDateValue(Date date) {
        assert (date != null) : "date is null";
        this.setDateValue(date, date);
    }

    public void setDateValue(Date startDate, Date endDate) {
        assert (startDate != null) : "startDate is null";
        assert (endDate != null) : "endDate is null";
        this.dateValue = startDate;
        this.secondDate = endDate;
    }

    public void setDateValue(long date) {
        this.setDateValue(date, date);
    }

    public void setDateValue(long startDate, long endDate) {
        this.dateValue = new Date(startDate);
        this.secondDate = new Date(endDate);
    }

    public Date getDateValue() {
        if (this.dateValue != null) {
            return this.dateValue;
        }
        return new Date();
    }

    public Date getFirstDateValue() {
        return this.getDateValue();
    }

    public Date getSecondDateValue() {
        if (this.secondDate != null) {
            return this.secondDate;
        }
        return new Date();
    }

    protected abstract Timestamp getDateAttribute(Object var1);

    @Override
    public String getFilterValue() {
        return this.getSettingsAsString();
    }

    @Override
    public void setFilterValue(String value) {
        this.init(value);
        super.setFilterValue(value);
    }

    @Override
    public void resetValue() {
        this.setFilterValue("is;" + System.currentTimeMillis());
    }

    public void setFilterMethod(String method) {
        this.filterMethod = method;
    }

    private boolean isSameDay(Calendar c1, Calendar c2) {
        return c1.get(5) == c2.get(5) && c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }

    private boolean isSameDayOrAfter(Calendar c1, Calendar c2) {
        return c1.after(c2) || this.isSameDay(c1, c2);
    }

    private boolean isSameDayOrBefore(Calendar c1, Calendar c2) {
        return this.isSameDayOrAfter(c2, c1);
    }
}

