/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.files.atomic;

import com.arcway.cockpit.cockpitlib.client.files.IContentWriter;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileKey;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileSetTransactionAbortedException;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileSetTransactionManager;
import com.arcway.cockpit.cockpitlib.client.files.atomic.IFileSetTransaction;
import com.arcway.cockpit.cockpitlib.client.files.atomic.InvalidContentAssignmentException;
import com.arcway.cockpit.cockpitlib.client.files.atomic.ModificationFile;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileSetTransaction
implements IFileSetTransaction {
    private static final ILogger LOGGER = Logger.getLogger(FileSetTransaction.class);
    private boolean terminated;
    private final FileSetTransactionManager transactionManager;
    private final HashMap<String, ModificationFile> currentlyValidFileSet;
    private final Map<String, ModificationFile> currentlyValidFileSet_ro;
    private final Set<ModificationFile> modificationFilesInUseAtStartOfTransaction;
    private final Set<ModificationFile> modificationTmpFiles;
    private final Set<ModificationFile> modificationTmpFiles_ro;

    public FileSetTransaction(FileSetTransactionManager transactionManager, HashMap<String, ModificationFile> currentlyValidFileSet) {
        assert (transactionManager != null);
        assert (currentlyValidFileSet != null);
        this.terminated = false;
        this.transactionManager = transactionManager;
        this.currentlyValidFileSet = currentlyValidFileSet;
        this.currentlyValidFileSet_ro = Collections.unmodifiableMap(this.currentlyValidFileSet);
        this.modificationFilesInUseAtStartOfTransaction = new HashSet<ModificationFile>(currentlyValidFileSet.values());
        this.modificationTmpFiles = new HashSet<ModificationFile>();
        this.modificationTmpFiles_ro = Collections.unmodifiableSet(this.modificationTmpFiles);
    }

    private boolean isModificationFileNameUnused(ModificationFile modificationTmpFile) {
        assert (!this.terminated);
        return !this.modificationFilesInUseAtStartOfTransaction.contains(modificationTmpFile) && !this.modificationTmpFiles.contains(modificationTmpFile);
    }

    public void markAsTerminated() {
        this.terminated = true;
    }

    public Map<String, ModificationFile> getCurrentlyValidFileSet() {
        return this.currentlyValidFileSet_ro;
    }

    public Set<ModificationFile> getModificationTmpFiles() {
        return this.modificationTmpFiles_ro;
    }

    @Override
    public ModificationFile allocateTmpFile(FileKey.FileNameConvention fileContentInfo) throws IOException, JvmExternalResourceInteractionException {
        assert (!this.terminated);
        File file = null;
        long MAX_TRIES = 256L;
        long i = 0L;
        while (i < 256L && file == null) {
            ModificationFile candidate = fileContentInfo.getFileProposal(this.transactionManager.getModFileDirectory(), i);
            if (this.isModificationFileNameUnused(candidate)) {
                file = candidate;
            }
            ++i;
        }
        if (file == null) {
            String msg = "Unable to allocate ModificationTmpFile. Gave up after 256 attempts.";
            LOGGER.error(msg);
            throw new IOException(msg);
        }
        FileHelper.ensureDirectoryExistance((File)file.getParentFile());
        this.modificationTmpFiles.add((ModificationFile)file);
        return file;
    }

    @Override
    public void assignContent(FileKey key, FileKey sourceKey) throws InvalidContentAssignmentException {
        assert (!this.terminated);
        assert (key != null);
        assert (sourceKey != null);
        assert (!sourceKey.equals(key)) : "Self assignment is legal, but is probably caused by a Bug.";
        assert (key.getFileNameConvention().equals(sourceKey.getFileNameConvention()));
        ModificationFile modificationFile = this.currentlyValidFileSet.get(sourceKey.getFileKeyID());
        if (modificationFile == null) {
            assert (false) : "Could also be deemed legal, but is probably caused by a Bug.";
            throw new InvalidContentAssignmentException("There is currently no content assigned to source FileKey: " + sourceKey);
        }
        this.currentlyValidFileSet.put(key.getFileKeyID(), modificationFile);
    }

    @Override
    public void assignContent(FileKey key, IContentWriter contentWriter) throws IOException, InvalidContentAssignmentException, JvmExternalResourceInteractionException {
        assert (!this.terminated);
        assert (key != null);
        assert (contentWriter != null);
        ModificationFile modificationFile = this.allocateTmpFile(key.getFileNameConvention());
        FileOutputStream modificationFileStream = null;
        OutputStream bufferedModificationFileStream = null;
        try {
            modificationFileStream = new FileOutputStream(modificationFile);
            bufferedModificationFileStream = new BufferedOutputStream(modificationFileStream);
            contentWriter.write(bufferedModificationFileStream);
        }
        finally {
            try {
                if (bufferedModificationFileStream != null) {
                    bufferedModificationFileStream.close();
                }
            }
            finally {
                if (modificationFileStream != null) {
                    ((OutputStream)modificationFileStream).close();
                }
            }
        }
        this.assignContent(key, modificationFile);
    }

    @Override
    public void assignContent(FileKey key, ModificationFile modificationFile) throws InvalidContentAssignmentException {
        assert (!this.terminated);
        assert (this.modificationTmpFiles.contains(modificationFile));
        assert (key.getFileNameConvention().isCompliantFile(this.transactionManager.getModFileDirectory(), modificationFile));
        try {
            if (modificationFile.length() == 0L) {
                throw new InvalidContentAssignmentException("Content File does either not exist or is empty: " + modificationFile);
            }
        }
        catch (Exception e) {
            throw new InvalidContentAssignmentException("Problem while accessing Content File: " + modificationFile, e);
        }
        this.currentlyValidFileSet.put(key.getFileKeyID(), modificationFile);
    }

    @Override
    public ModificationFile getContent(FileKey key) {
        assert (!this.terminated);
        return this.currentlyValidFileSet.get(key.getFileKeyID());
    }

    @Override
    public void removeContent(FileKey key) {
        assert (!this.terminated);
        ModificationFile removedContent = this.currentlyValidFileSet.remove(key.getFileKeyID());
        assert (removedContent != null);
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void commit() throws FileSetTransactionAbortedException {
        assert (!this.terminated);
        this.transactionManager.commitTransaction(this);
    }

    @Override
    public void rollback() {
        assert (!this.terminated);
        this.transactionManager.rollbackTransaction(this);
    }
}

