/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.files.atomic;

import com.arcway.cockpit.cockpitlib.client.files.atomic.ModificationFile;
import java.io.File;

public class FileKey {
    private final String fileKeyID;
    private final FileNameConvention fileNameConvention;

    public FileKey(String fileKeyIDComponent1, FileNameConvention fileNameConvention) {
        assert (fileKeyIDComponent1 != null);
        assert (fileNameConvention != null);
        this.fileKeyID = FileKey.computeFileKeyIDString(new String[]{fileKeyIDComponent1});
        this.fileNameConvention = fileNameConvention;
    }

    public FileKey(String[] fileKeyIDComponents, FileNameConvention fileNameConvention) {
        assert (fileKeyIDComponents != null);
        assert (fileNameConvention != null);
        this.fileKeyID = FileKey.computeFileKeyIDString(fileKeyIDComponents);
        this.fileNameConvention = fileNameConvention;
    }

    public int hashCode() {
        return this.fileKeyID.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) assert (false);
        return obj instanceof FileKey && this.fileKeyID.equals(((FileKey)obj).fileKeyID);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.fileKeyID;
    }

    public String getFileKeyID() {
        return this.fileKeyID;
    }

    public FileNameConvention getFileNameConvention() {
        return this.fileNameConvention;
    }

    private static String computeFileKeyIDString(String[] fileKeyIDComponents) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < fileKeyIDComponents.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append('[');
            buffer.append(fileKeyIDComponents[i]);
            buffer.append(']');
            ++i;
        }
        return buffer.toString();
    }

    public static class FileNameConvention {
        private final String subdirectoryName;
        private final String filePrefix;
        private final String fileExtension;

        public FileNameConvention(String filePrefix, String fileExtension) {
            this(filePrefix, fileExtension, null, false);
        }

        public FileNameConvention(String filePrefix, String fileExtension, String subdirectoryName) {
            this(filePrefix, fileExtension, subdirectoryName, true);
        }

        private FileNameConvention(String filePrefix, String fileExtension, String subdirectoryName, boolean doCheckSubdirectoryName) {
            assert (doCheckSubdirectoryName == (subdirectoryName != null));
            assert (!filePrefix.equalsIgnoreCase("idx"));
            this.subdirectoryName = subdirectoryName;
            this.fileExtension = fileExtension;
            this.filePrefix = filePrefix;
        }

        public int hashCode() {
            return this.filePrefix.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof FileNameConvention && (this.subdirectoryName == ((FileNameConvention)obj).subdirectoryName || this.subdirectoryName != null && this.subdirectoryName.equals(((FileNameConvention)obj).subdirectoryName)) && this.filePrefix.equals(((FileNameConvention)obj).filePrefix) && this.fileExtension.equals(((FileNameConvention)obj).fileExtension);
        }

        public ModificationFile getFileProposal(File modFileRootDirectory, long v) {
            if (this.subdirectoryName == null) {
                return new ModificationFile(modFileRootDirectory, String.valueOf(this.filePrefix) + Long.toHexString(v) + this.fileExtension);
            }
            return new ModificationFile(new File(modFileRootDirectory, this.subdirectoryName), String.valueOf(this.filePrefix) + Long.toHexString(v) + this.fileExtension);
        }

        public boolean isCompliantFile(File modFileRootDirectory, ModificationFile modificationFile) {
            boolean isCompliantFileName;
            String fileName = modificationFile.getName();
            boolean bl = isCompliantFileName = fileName.startsWith(this.filePrefix) && fileName.endsWith(this.fileExtension);
            if (isCompliantFileName && this.subdirectoryName != null) {
                isCompliantFileName = new File(modFileRootDirectory, this.subdirectoryName).equals(modificationFile.getParentFile());
            }
            return isCompliantFileName;
        }
    }
}

