/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.files;

import com.arcway.cockpit.cockpitlib.client.files.IContentReader;
import com.arcway.cockpit.cockpitlib.client.files.IContentWriter;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class AtomicFileWriter {
    private static final ILogger logger = Logger.getLogger(AtomicFileWriter.class);

    public static void writeIntoFileAtomically(File targetFile, IContentWriter writer) throws IOException {
        File tempFile = File.createTempFile("writer", "." + FileHelper.getFileExtension((File)targetFile), targetFile.getParentFile());
        boolean tempFileMovedToTarget = false;
        try {
            try (BufferedOutputStream tempFileOutputStream = new BufferedOutputStream(new FileOutputStream(tempFile));){
                writer.write(tempFileOutputStream);
            }
            assert (tempFile.length() > 0L);
            try {
                if (targetFile.exists()) {
                    FileHelper.deleteExistingFileOrDirectory((File)targetFile);
                }
                FileHelper.moveFile((File)tempFile, (File)targetFile);
                tempFileMovedToTarget = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (!tempFileMovedToTarget) {
                try {
                    FileHelper.deleteFileOrDirectory((File)tempFile);
                }
                catch (JvmExternalResourceInteractionException jeri) {
                    logger.error("Problem while deleting obsolete temporary file: " + tempFile, (Throwable)jeri);
                }
            }
        }
    }

    public static void readFromFile(File sourceFile, IContentReader reader) throws EXDecoderException, IOException {
        if (sourceFile.exists()) {
            reader.readFile(sourceFile);
        }
    }

    private AtomicFileWriter() {
    }
}

