/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.data.jpa;

import java.io.File;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.jpa.osgi.PersistenceProvider;

public class JPAPersistenceUnit {
    private final EntityManagerFactory emf;

    public JPAPersistenceUnit(String persistenceUnitName, File dbPath, ClassLoader classLoader) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("eclipselink.target-database", "org.eclipse.persistence.platform.database.HSQLPlatform");
        properties.put("javax.persistence.jdbc.driver", "org.hsqldb.jdbcDriver");
        properties.put("javax.persistence.jdbc.url", "jdbc:hsqldb:file:" + dbPath + ";shutdown=true");
        properties.put("javax.persistence.jdbc.user", "SA");
        properties.put("javax.persistence.jdbc.password", "");
        properties.put("eclipselink.connection-pool.default.min", "1");
        properties.put("eclipselink.ddl-generation", "create-tables");
        properties.put("eclipselink.ddl-generation.output-mode", "database");
        properties.put("eclipselink.classloader", classLoader);
        properties.put("shared-cache-mode", "NONE");
        properties.put("persistence-unit-caching-type", "NONE");
        properties.put("eclipselink.cache.shared.default", Boolean.FALSE.toString());
        properties.put("eclipselink.cache.type.default", "NONE");
        properties.put("eclipselink.jdbc.batch-writing", "JDBC");
        properties.put("eclipselink.jdbc.batch-writing.size", "1000");
        properties.put("eclipselink.jdbc.cache-statements", Boolean.TRUE.toString());
        properties.put("eclipselink.logging.level", "INFO");
        properties.put("eclipselink.logging.timestamp", Boolean.FALSE.toString());
        properties.put("eclipselink.logging.session", Boolean.TRUE.toString());
        properties.put("eclipselink.logging.thread", Boolean.FALSE.toString());
        File hsqlPropertiesFile = new File(dbPath.getParentFile(), String.valueOf(dbPath.getName()) + ".properties");
        boolean databaseAlreadyExists = hsqlPropertiesFile.exists();
        if (!databaseAlreadyExists) {
            try (EntityManagerFactory initialEmf = null;){
                initialEmf = new PersistenceProvider().createEntityManagerFactory(persistenceUnitName, properties);
                try (EntityManager initialEM = null;){
                    initialEM = initialEmf.createEntityManager();
                }
            }
        }
        properties.put("eclipselink.ddl-generation", "none");
        this.emf = new PersistenceProvider().createEntityManagerFactory(persistenceUnitName, properties);
        assert (this.emf != null);
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public void destruct() {
        assert (this.emf.isOpen());
        if (this.emf != null) {
            this.emf.close();
        }
    }
}

