/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.datamanager;

import com.arcway.cockpit.client.base.datamanager.AtomicModificationDataAccessor;
import com.arcway.cockpit.cockpitlib.client.data.jpa.JPAEOCoDec;
import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileKey;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.lib.xml.encoding.XMLDecoderPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public final class XMLDataAccessor<EO extends EOEncodableObject>
implements IXMLDataAccessor<EO> {
    private static final ILogger logger = Logger.getLogger(XMLDataAccessor.class);
    private final FileKey fileKey;
    private final IEncodableObjectFactory encodableObjectFactory;
    private final AtomicModificationDataAccessor atomicXMLFilesAccessor;
    private IFileContentProviderForXMLFiles<EO> currentFileContentInCaseThatItsNotYetWrittenToDisc = null;

    public XMLDataAccessor(FileKey fileKey, IEncodableObjectFactory encodableObjectFactory, AtomicModificationDataAccessor atomicXMLFilesAccessor) {
        this.fileKey = fileKey;
        this.encodableObjectFactory = encodableObjectFactory;
        this.atomicXMLFilesAccessor = atomicXMLFilesAccessor;
    }

    public FileKey getFileKey() {
        return this.fileKey;
    }

    public EO read() throws IOException, EXDecoderException {
        Object currentFileContent;
        if (this.currentFileContentInCaseThatItsNotYetWrittenToDisc != null) {
            EOEncodableObject fileContentAfterUpdate = this.currentFileContentInCaseThatItsNotYetWrittenToDisc.getFileContent();
            if (fileContentAfterUpdate != null) {
                logger.debug("XML file is re-read before it was written to disc (this should be avoided)", (Throwable)new Exception());
                File tempFile = File.createTempFile("XML", ".xml");
                try {
                    FileOutputStream fileContentAsOutputStream = new FileOutputStream(tempFile);
                    try {
                        try {
                            this.writeStream(fileContentAfterUpdate, fileContentAsOutputStream);
                        }
                        catch (EXEncoderException e) {
                            throw e.toNewIOException("Unable to return (copy of) file content.");
                        }
                    }
                    finally {
                        try {
                            fileContentAsOutputStream.close();
                        }
                        catch (Exception e) {
                            logger.debug("Unable to close file stream after write failure", (Throwable)e);
                        }
                    }
                    currentFileContent = this.readFile(tempFile);
                }
                finally {
                    try {
                        FileHelper.deleteExistingFileOrDirectory((File)tempFile);
                    }
                    catch (JvmExternalResourceInteractionException jeri) {
                        logger.debug("Unable to delete obsolete temp file:", (Throwable)jeri);
                    }
                }
            }
            currentFileContent = null;
        } else {
            final ArrayList eos = new ArrayList(1);
            this.atomicXMLFilesAccessor.readModificationFile(this, new AtomicModificationDataAccessor.IContentReader(){

                @Override
                public void readXMLData(String xmldata) throws EXDecoderException, IOException {
                    eos.add((EOEncodableObject)JPAEOCoDec.convertXmlStringToNewEO((String)xmldata, (XMLDecoder)new XMLDecoder(), (IEncodableObjectFactory)XMLDataAccessor.this.encodableObjectFactory));
                }
            });
            Iterator i = eos.iterator();
            currentFileContent = i.hasNext() ? (EOEncodableObject)i.next() : null;
        }
        return (EO)currentFileContent;
    }

    public void write(final IFileContentProviderForXMLFiles<EO> fileContentProvider) {
        this.atomicXMLFilesAccessor.doWithDelayedWriteThrough(new Runnable(){

            @Override
            public void run() {
                if (fileContentProvider != null) {
                    XMLDataAccessor.this.currentFileContentInCaseThatItsNotYetWrittenToDisc = fileContentProvider;
                } else {
                    XMLDataAccessor.this.currentFileContentInCaseThatItsNotYetWrittenToDisc = (IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(null);
                }
            }
        });
    }

    private void writeStream(EO eo, OutputStream targetStream) throws EXEncoderException {
        assert (eo != null);
        eo.writeToXMLStream(targetStream, true);
    }

    private EO readFile(File inputFile) throws EXDecoderException, IOException {
        return (EO)((EOEncodableObject)XMLDecoderPool.decodeXMLFile((File)inputFile, (IEncodableObjectFactory)this.encodableObjectFactory, (boolean)true));
    }

    public AtomicModificationDataAccessor.IContentUpdateWriter getContentUpdateWriter() {
        if (this.currentFileContentInCaseThatItsNotYetWrittenToDisc == null) {
            return null;
        }
        final EOEncodableObject fileContent = this.currentFileContentInCaseThatItsNotYetWrittenToDisc.getFileContent();
        return new AtomicModificationDataAccessor.IContentUpdateWriter(){

            @Override
            public boolean isUpdatedContentEmpty() {
                return fileContent == null;
            }

            @Override
            public String getContentAsString() throws EXEncoderException {
                return JPAEOCoDec.encode((EncodableObjectBase)fileContent);
            }
        };
    }

    public void contentUpdateCommittedToDisc() {
        this.currentFileContentInCaseThatItsNotYetWrittenToDisc = null;
    }
}

