/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.datamanager;

import com.arcway.cockpit.client.base.datamanager.AbstractDifferentialModificationManager;
import com.arcway.cockpit.client.base.datamanager.DataManagerModificationAccess;
import com.arcway.cockpit.client.base.datamanager.IModificationEntityProvider;
import com.arcway.cockpit.client.base.datamanager.XMLDataAccessor;
import com.arcway.cockpit.cockpitlib.client.Messages;
import com.arcway.cockpit.cockpitlib.client.data.jpa.IModificationEntity;
import com.arcway.cockpit.cockpitlib.client.data.jpa.OpaqueModificationString;
import com.arcway.cockpit.cockpitlib.client.data.jpa.ProjectClientDBManager;
import com.arcway.cockpit.cockpitlib.client.files.IModificationAccessTransactionListeners;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileKey;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileSetTransactionAbortedException;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileTransactionManagerInitialisationFailed;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class AtomicModificationDataAccessor {
    private static final ILogger logger = Logger.getLogger(AtomicModificationDataAccessor.class);
    private static final int ManagedEntitiesClearThreshold = 100;
    private static final int DelayedWriteThroughInitialLevel = 0;
    private static final int ModificationBootstrapInProgressInitialLevel = 0;
    private final ProjectClientDBManager projectClientDBManager;
    private final HashMap<FileKey, IModificationAccessTransactionListeners> modificationAccessTransactionListeners = new HashMap();
    private final HashMap<FileKey, XMLDataAccessor<? extends EOEncodableObject>> opaqueXmlStringAccessors = new HashMap();
    private final HashMap<Object, AbstractDifferentialModificationManager<?, ?>> differentialModificationManagers = new HashMap();
    private Throwable corruptInMemoryState = null;
    private Throwable diskStateOutOfSync = null;
    private int delayedWriteThroughLevel = 0;
    private int modificationBootstrapInProgressLevel = 0;
    private boolean dirtyUpdateSinceLastDelayedWriteThroughCompleted = false;

    public AtomicModificationDataAccessor(File dataDirectory) throws FileTransactionManagerInitialisationFailed {
        try {
            this.projectClientDBManager = new ProjectClientDBManager(dataDirectory);
        }
        catch (Throwable th) {
            throw new FileTransactionManagerInitialisationFailed("Unable to initialize clientProjectDataDBManager", th);
        }
    }

    public <EO extends EOEncodableObject> IXMLDataAccessor<EO> getXMLFileAccessor(FileKey fileKey, IEncodableObjectFactory encodableObjectFactory) {
        return this.getXMLFileAccessor(fileKey, encodableObjectFactory, null);
    }

    public <EO extends EOEncodableObject> IXMLDataAccessor<EO> getXMLFileAccessor(FileKey fileKey, IEncodableObjectFactory encodableObjectFactory, IModificationAccessTransactionListeners xmlFileAccessTransactionListener) {
        XMLDataAccessor<Object> fileAccessor = this.opaqueXmlStringAccessors.get(fileKey);
        if (fileAccessor == null) {
            assert (!this.modificationAccessTransactionListeners.containsKey(fileKey));
            fileAccessor = new XMLDataAccessor(fileKey, encodableObjectFactory, this);
            this.opaqueXmlStringAccessors.put(fileKey, fileAccessor);
            if (xmlFileAccessTransactionListener != null) {
                this.modificationAccessTransactionListeners.put(fileKey, xmlFileAccessTransactionListener);
            }
        }
        return fileAccessor;
    }

    public DataManagerModificationAccess getDataManagerModificationAccess(AbstractEncodableObjectFactory p_eoFactory) {
        return new DataManagerModificationAccess(this, p_eoFactory);
    }

    public void registerDifferentialModificationManager(AbstractDifferentialModificationManager<?, ?> modificationManager) {
        AbstractDifferentialModificationManager<?, ?> oldValue = this.differentialModificationManagers.put(modificationManager.getDifferentialModificationManagerID(), modificationManager);
        assert (oldValue == null);
    }

    public void executeModificationBootstrapRunnable(final BootstrapRunnable bootstrapRunnable) {
        assert (this.modificationBootstrapInProgressLevel == 0);
        ++this.modificationBootstrapInProgressLevel;
        try {
            this.doWithDelayedWriteThrough(new Runnable(){

                @Override
                public void run() {
                    bootstrapRunnable.run();
                }
            });
        }
        finally {
            --this.modificationBootstrapInProgressLevel;
            assert (this.modificationBootstrapInProgressLevel == 0);
        }
    }

    private boolean isModificationBootstrapInProgress() {
        return this.modificationBootstrapInProgressLevel > 0;
    }

    public void doWithDelayedWriteThrough(Runnable todo) {
        this.prepareStartOfWorkUnit(WorkUnitDemarcationType.DelayedWriteThroughWork);
        try {
            try {
                todo.run();
            }
            catch (Throwable th) {
                if (this.corruptInMemoryState == null) {
                    this.corruptInMemoryState = th;
                    this.diskStateOutOfSync = th;
                }
                logger.fatal("An exception has occurred during transaction execution. The in-memory-state may be corrupt, now.", th);
                this.finalizeWorkUnit(WorkUnitDemarcationType.DelayedWriteThroughWork);
            }
        }
        finally {
            this.finalizeWorkUnit(WorkUnitDemarcationType.DelayedWriteThroughWork);
        }
    }

    private void prepareStartOfWorkUnit(WorkUnitDemarcationType workUnitDemarcationType) {
        if (!this.dirtyUpdateSinceLastDelayedWriteThroughCompleted && this.delayedWriteThroughLevel == 0) {
            this.projectClientDBManager.createNewEntityManagerAndStartTransaction();
            this.notifyTransactionListenersAboutTransactionStart();
        }
        if (workUnitDemarcationType == WorkUnitDemarcationType.DelayedWriteThroughWork) {
            ++this.delayedWriteThroughLevel;
        } else {
            assert (workUnitDemarcationType == WorkUnitDemarcationType.DeprecatedExplicitWriteAtWorkCompletion);
            if (this.delayedWriteThroughLevel == 0) {
                this.dirtyUpdateSinceLastDelayedWriteThroughCompleted = true;
                logger.error("DirtyUpdates should still work as well as before but are not wanted anymore");
            }
        }
    }

    private void finalizeWorkUnit(WorkUnitDemarcationType workUnitDemarcationType) {
        boolean commitWorkUnitTransaction;
        if (workUnitDemarcationType == WorkUnitDemarcationType.DelayedWriteThroughWork) {
            assert (this.delayedWriteThroughLevel > 0);
            --this.delayedWriteThroughLevel;
            commitWorkUnitTransaction = this.delayedWriteThroughLevel == 0;
        } else {
            assert (workUnitDemarcationType == WorkUnitDemarcationType.DeprecatedExplicitWriteAtWorkCompletion);
            boolean bl = commitWorkUnitTransaction = this.dirtyUpdateSinceLastDelayedWriteThroughCompleted && this.delayedWriteThroughLevel == 0;
        }
        if (commitWorkUnitTransaction) {
            boolean success;
            assert (this.delayedWriteThroughLevel == 0);
            this.delayedWriteThroughLevel = 0;
            this.dirtyUpdateSinceLastDelayedWriteThroughCompleted = false;
            if (this.corruptInMemoryState != null) {
                AtomicModificationDataAccessor.showCorruptInMemoryStateHint();
                success = false;
            } else {
                Throwable diskStateOutOfSync_beforeSync = this.diskStateOutOfSync;
                Throwable failureOrVeto = this.askTransactionListenersForVetos();
                if (failureOrVeto == null) {
                    boolean doRecoveryInsteadOfFlush = this.diskStateOutOfSync != null;
                    this.diskStateOutOfSync = null;
                    failureOrVeto = this.syncModificationsToDisk(doRecoveryInsteadOfFlush);
                    success = failureOrVeto == null && this.diskStateOutOfSync == null;
                } else {
                    success = false;
                }
                if (!success) {
                    if (failureOrVeto != null) {
                        logger.fatal("Syncing modifications to disk was not possible due to failureOrVeto.  The disk state is out of synch with the in-memory-state, now. Reason: ", failureOrVeto);
                    }
                    if (this.diskStateOutOfSync != null) {
                        logger.fatal("Syncing modifications to disk was not possible due to failure.  The disk state is out of synch with the in-memory-state, now. Reason: ", this.diskStateOutOfSync);
                    }
                    if (diskStateOutOfSync_beforeSync != null) {
                        this.diskStateOutOfSync = diskStateOutOfSync_beforeSync;
                    } else if (failureOrVeto != null) {
                        this.diskStateOutOfSync = failureOrVeto;
                    } else assert (this.diskStateOutOfSync != null);
                }
                assert (success == (this.diskStateOutOfSync == null)) : "There must be a cause for the disk state being/becomming out of sync.";
                if (success) {
                    if (diskStateOutOfSync_beforeSync != null) {
                        AtomicModificationDataAccessor.showDiskStateInSyncAgainHint();
                    }
                } else {
                    AtomicModificationDataAccessor.showDiskStateOutOfSyncHint();
                }
            }
            this.notifyTransactionListenersAboutTransactionCompletion(success);
        }
    }

    private Throwable syncModificationsToDisk(boolean doRecoveryInsteadOfFlush) {
        assert (this.diskStateOutOfSync == null);
        try {
            HashMap<Class<? extends IModificationEntity<?>>, ModificationUpdatesForEntityClass<? extends IModificationEntity<?>, ?>> cummulatedModificationChanges = this.depleteModificationsOfDifferentialModificationManagers();
            if (doRecoveryInsteadOfFlush) {
                this.projectClientDBManager.abortPendingTransactionAndEnsureEntityManagerIsClosed();
                this.projectClientDBManager.createNewEntityManagerAndStartTransaction();
                for (AbstractDifferentialModificationManager<?, ?> differentialModificationManager : this.differentialModificationManagers.values()) {
                    differentialModificationManager.reconstructModificationElements();
                    if (this.diskStateOutOfSync == null) continue;
                    throw this.diskStateOutOfSync;
                }
            } else {
                AtomicModificationDataAccessor.addDelayedDifferentialUpdatesToRunningTransaction(this.projectClientDBManager.getEntityManager(), cummulatedModificationChanges);
            }
            this.addOpaqModificationsToRunningTransaction(this.projectClientDBManager.getEntityManager());
            this.projectClientDBManager.commitTransactionAndCloseEntityManager();
            this.clearOpaqModificationDeltas();
            return null;
        }
        catch (Throwable th) {
            this.projectClientDBManager.abortPendingTransactionAndEnsureEntityManagerIsClosed();
            logger.fatal(th);
            return new FileSetTransactionAbortedException("Problem while persisting modifications to disk.", th);
        }
    }

    private static void addDelayedDifferentialUpdatesToRunningTransaction(EntityManager em, HashMap<Class<? extends IModificationEntity<?>>, ModificationUpdatesForEntityClass<? extends IModificationEntity<?>, ?>> cummulatedModificationChanges) throws EXEncoderException {
        long deleteCount = 0L;
        boolean atLeastOneRemoved = false;
        for (ModificationUpdatesForEntityClass<IModificationEntity<?>, ?> modificationUpdatesForEntityClass : cummulatedModificationChanges.values()) {
            for (Map.Entry entry : modificationUpdatesForEntityClass.entitiesToDelete.entrySet()) {
                atLeastOneRemoved = true;
                assert (em.contains(entry.getValue()));
                em.remove(entry.getValue());
                ++deleteCount;
            }
        }
        if (atLeastOneRemoved) {
            em.flush();
        }
        em.clear();
        long insertCount = 0L;
        for (ModificationUpdatesForEntityClass<IModificationEntity<?>, ?> modificationUpdatesForEntityClass : cummulatedModificationChanges.values()) {
            int numNewManagedEntities = 0;
            for (Map.Entry entry : ((ModificationUpdatesForEntityClass)modificationUpdatesForEntityClass).entitiesToAdd.entrySet()) {
                Object newEntity = ((IModificationEntityProvider)entry.getValue()).createModificationEntity();
                em.persist(newEntity);
                if (++numNewManagedEntities >= 100) {
                    em.flush();
                    em.clear();
                    numNewManagedEntities = 0;
                }
                ++insertCount;
            }
            if (numNewManagedEntities <= 0) continue;
            em.flush();
            em.clear();
        }
        logger.debug("deleteCount: " + deleteCount + " insertCount:" + insertCount);
    }

    private void addOpaqModificationsToRunningTransaction(EntityManager em) throws EXEncoderException {
        for (Map.Entry<FileKey, XMLDataAccessor<? extends EOEncodableObject>> fileAccessorEntry : this.opaqueXmlStringAccessors.entrySet()) {
            FileKey fileKey = fileAccessorEntry.getKey();
            XMLDataAccessor<? extends EOEncodableObject> fileAccessor = fileAccessorEntry.getValue();
            IContentUpdateWriter updateWriter = fileAccessor.getContentUpdateWriter();
            if (updateWriter == null) continue;
            Query query = em.createNamedQuery("OpaqueModificationString_deleteByAccessKey");
            query.setParameter("accessKey", (Object)fileKey.getFileKeyID());
            int executeUpdate = query.executeUpdate();
            assert (executeUpdate == 0 || executeUpdate == 1);
            if (!updateWriter.isUpdatedContentEmpty()) {
                OpaqueModificationString opaqueModificationString = new OpaqueModificationString(fileKey.getFileKeyID(), updateWriter.getContentAsString());
                em.persist((Object)opaqueModificationString);
                em.flush();
            }
            em.clear();
        }
    }

    private void clearOpaqModificationDeltas() {
        for (XMLDataAccessor<? extends EOEncodableObject> fileAccessor : this.opaqueXmlStringAccessors.values()) {
            fileAccessor.contentUpdateCommittedToDisc();
        }
    }

    private HashMap<Class<? extends IModificationEntity<?>>, ModificationUpdatesForEntityClass<? extends IModificationEntity<?>, ?>> depleteModificationsOfDifferentialModificationManagers() {
        HashMap cummulatedModificationUpdates = new HashMap();
        for (AbstractDifferentialModificationManager<?, ?> differentialModificationManager : this.differentialModificationManagers.values()) {
            Class<?> classOfManagedEntities = differentialModificationManager.getClassOfManagedEntities();
            ModificationUpdatesForEntityClass<Object, ?> modificationUpdatesForEntityClass = cummulatedModificationUpdates.get(classOfManagedEntities);
            if (modificationUpdatesForEntityClass == null) {
                modificationUpdatesForEntityClass = differentialModificationManager.new_ModificationUpdatesForEntityClass();
                cummulatedModificationUpdates.put(classOfManagedEntities, modificationUpdatesForEntityClass);
            }
            differentialModificationManager.handOverModificationUpdates_untyped(modificationUpdatesForEntityClass);
        }
        return cummulatedModificationUpdates;
    }

    public boolean isInMemoryStateConsistent() {
        return this.corruptInMemoryState == null;
    }

    public boolean isDiskStateInSynchWithInMemoryState() {
        return this.diskStateOutOfSync == null;
    }

    public void readModificationFile(XMLDataAccessor<? extends EOEncodableObject> fileAccessor, IContentReader contentReader) throws EXDecoderException, IOException {
        try {
            EntityManager em = this.projectClientDBManager.getEntityManager();
            String accessKey = fileAccessor.getFileKey().getFileKeyID();
            assert (accessKey != null);
            TypedQuery query = em.createNamedQuery("OpaqueModificationString_readByAccessKey", String.class);
            query.setParameter("accessKey", (Object)accessKey);
            List resultList = query.getResultList();
            if (!resultList.isEmpty()) {
                assert (resultList.size() == 1);
                contentReader.readXMLData((String)resultList.get(0));
            }
        }
        catch (EXDecoderException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable th) {
            IOException ioex = new IOException("Problem while accessing Modification File " + fileAccessor.getFileKey().getFileKeyID());
            ioex.initCause(th);
            throw ioex;
        }
    }

    private static void showCorruptInMemoryStateHint() {
        Shell shell = EclipseSWTHelper.getShell();
        if (shell != null) {
            MessageDialog.openError((Shell)shell, (String)Messages.getString((String)"AtomicXMLFilesAccessor.Error.CorruptInMemeoryState.Title"), (String)Messages.getString((String)"AtomicXMLFilesAccessor.Error.CorruptInMemeoryState.Message"));
        }
    }

    private static void showDiskStateOutOfSyncHint() {
        Shell shell = EclipseSWTHelper.getShell();
        if (shell != null) {
            MessageDialog.openError((Shell)shell, (String)Messages.getString((String)"AtomicXMLFilesAccessor.Error.DiskStateOutOfSync.Title"), (String)Messages.getString((String)"AtomicXMLFilesAccessor.Error.DiskStateOutOfSync.Message"));
        }
    }

    private static void showDiskStateInSyncAgainHint() {
        Shell shell = EclipseSWTHelper.getShell();
        if (shell != null) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString((String)"AtomicXMLFilesAccessor.Hint.DiskStateInSyncAgain.Title"), (String)Messages.getString((String)"AtomicXMLFilesAccessor.Hint.DiskStateInSyncAgain.Message"));
        }
    }

    public void bootstrapModificationData(IBootstrapModificationAccessor bootstrapAccessor) throws ModificationBootstrapFailure {
        boolean isIntegrityCheck = false;
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            isIntegrityCheck |= "checkModificationIntegrity".equals(e.getMethodName());
            ++n2;
        }
        assert (isIntegrityCheck || this.isModificationBootstrapInProgress());
        if (this.diskStateOutOfSync == null) {
            try {
                bootstrapAccessor.run(this.projectClientDBManager.getEntityManager());
            }
            catch (Exception e) {
                ModificationBootstrapFailure ex = new ModificationBootstrapFailure("Unable to read disk state ", e);
                logger.error((Throwable)ex);
                throw ex;
            }
        } else {
            ModificationBootstrapFailure ex = new ModificationBootstrapFailure("Attempt to read outdated and possibly corrupted disk state ");
            logger.error((Throwable)ex);
            throw ex;
        }
    }

    public void prepareModificationDataUpdate(IModificationUpdatePreparer updatePreparer) {
        this.prepareStartOfWorkUnit(WorkUnitDemarcationType.DeprecatedExplicitWriteAtWorkCompletion);
        if (this.diskStateOutOfSync == null) {
            try {
                updatePreparer.run(this.projectClientDBManager.getEntityManager());
            }
            catch (Throwable th) {
                if (this.diskStateOutOfSync == null) {
                    this.diskStateOutOfSync = th;
                } else assert (false);
                logger.error("Disk state no longer in sync with in memory state ", th);
            }
        }
    }

    @Deprecated
    public void saveModificationsIfSavingIsEnabled() {
        this.finalizeWorkUnit(WorkUnitDemarcationType.DeprecatedExplicitWriteAtWorkCompletion);
    }

    private void notifyTransactionListenersAboutTransactionStart() {
        for (IModificationAccessTransactionListeners transactionListener : this.modificationAccessTransactionListeners.values()) {
            transactionListener.xmlFileAccessTransactionStarted();
        }
    }

    private Throwable askTransactionListenersForVetos() {
        Throwable result = null;
        for (IModificationAccessTransactionListeners transactionListener : this.modificationAccessTransactionListeners.values()) {
            Throwable veto = transactionListener.canXMLFileAccessTransactionBeSaved();
            if (result != null || veto == null) continue;
            result = veto;
        }
        return result;
    }

    private void notifyTransactionListenersAboutTransactionCompletion(boolean success) {
        for (IModificationAccessTransactionListeners transactionListener : this.modificationAccessTransactionListeners.values()) {
            transactionListener.xmlFileAccessTransactionCompleted(success);
        }
    }

    public void destruct(String projectUID) {
        try {
            this.projectClientDBManager.destruct();
        }
        catch (Exception e) {
            logger.error("Problem during clientProjectDataDBManager shutdown for Project " + projectUID + ": " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static interface BootstrapRunnable {
        public void run();
    }

    public static interface IBootstrapModificationAccessor {
        public void run(EntityManager var1) throws Exception;
    }

    public static interface IContentReader {
        public void readXMLData(String var1) throws EXDecoderException, IOException;
    }

    static interface IContentUpdateWriter {
        public boolean isUpdatedContentEmpty();

        public String getContentAsString() throws EXEncoderException;
    }

    public static interface IModificationUpdatePreparer {
        public void run(EntityManager var1) throws Exception;
    }

    public static class ModificationBootstrapFailure
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ModificationBootstrapFailure(String message, Throwable cause) {
            super(message, cause);
        }

        public ModificationBootstrapFailure(String message) {
            super(message);
        }
    }

    public static class ModificationUpdatesForEntityClass<T_ENTITY extends IModificationEntity<T_ENTITY_KEY>, T_ENTITY_KEY> {
        public final Class<T_ENTITY> entityClass;
        public final HashMap<T_ENTITY_KEY, T_ENTITY> entitiesToDelete;
        private final HashMap<T_ENTITY_KEY, IModificationEntityProvider<?>> entitiesToAdd;

        public ModificationUpdatesForEntityClass(Class<T_ENTITY> entityClass) {
            this.entityClass = entityClass;
            this.entitiesToDelete = new HashMap();
            this.entitiesToAdd = new HashMap();
        }

        public void addUpdates(HashMap<T_ENTITY_KEY, T_ENTITY> existingElementsToDelete, HashMap<T_ENTITY_KEY, ? extends IModificationEntityProvider<T_ENTITY>> newElementsToAdd) {
            assert (!new HashSet<T_ENTITY_KEY>(this.entitiesToDelete.keySet()).removeAll(existingElementsToDelete.keySet()));
            assert (!new HashSet<T_ENTITY_KEY>(this.entitiesToAdd.keySet()).removeAll(newElementsToAdd.keySet()));
            this.entitiesToDelete.putAll(existingElementsToDelete);
            this.entitiesToAdd.putAll(newElementsToAdd);
        }
    }

    private static enum WorkUnitDemarcationType {
        DelayedWriteThroughWork,
        DeprecatedExplicitWriteAtWorkCompletion;

    }
}

