/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.datamanager;

import com.arcway.cockpit.client.base.datamanager.AccessAgentModificationAccess;
import com.arcway.cockpit.client.base.datamanager.DataAccessAgent;
import com.arcway.cockpit.client.base.datamanager.DataManagerModificationAccess;
import com.arcway.cockpit.client.base.datamanager.IDataHandler;
import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.IModelTransactionManager;
import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider2;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractDataManager<T, T_UID, T_Datatype, T_EO extends EOGenericCockpitDatabaseData> {
    private static final ILogger logger = Logger.getLogger(AbstractDataManager.class);
    private IDataHandler<T, T_UID, T_Datatype, T_EO> dataHandler;
    private String projectUid;
    private IProjectAgent projectAgent;
    private PropertyChangesManager propertyChangesManager;
    private IMapRW_<T_Datatype, DataAccessAgent<T, T_UID, T_Datatype, T_EO>> accessAgents;
    private DataManagerModificationAccess dataManagerModificationAccess;
    private boolean hasUncommitedChanges = false;
    private boolean isAsynchronousUpdateRunning = false;
    private IMapRW_<T_Datatype, PropertyChanges<T>> recentChanges;
    private static final int SERVER_PACKAGE_TYPE_ADDEDITEMS = 1;
    private static final int SERVER_PACKAGE_TYPE_UPDATEDITEMS = 2;
    private static final int SERVER_PACKAGE_TYPE_REMOVEDITEMS = 3;

    public void init(String projectUid_, IProjectAgent projectAgent_, PropertyChangesManager propertyChangesManager_) {
        assert (projectUid_ != null);
        assert (projectAgent_ != null);
        this.propertyChangesManager = propertyChangesManager_;
        this.projectUid = projectUid_;
        this.projectAgent = projectAgent_;
    }

    public void construct(AbstractEncodableObjectFactory p_eoFactory) {
        assert (this.projectUid != null);
        assert (this.projectAgent != null);
        this.dataHandler = this.createDataHandler();
        this.dataManagerModificationAccess = this.projectAgent.getAtomicModificationDataAccessor().getDataManagerModificationAccess(p_eoFactory);
        String usageContext = "Project-UID=" + this.projectUid;
        DataAccessAgent.IModificationDiscardCallback<T, T_Datatype> modificationCallback = this.createModificationCallback();
        this.accessAgents = new HashMap_(this.getDataTypeIDHasher());
        Collection<T_Datatype> dataTypeIDs = this.getDataTypes();
        for (T_Datatype dataTypeID : dataTypeIDs) {
            AccessAgentModificationAccess accessAgentModificationAccess = this.dataManagerModificationAccess.createAccessAgentModificationAccess(this.getDataTypeIDAsString(dataTypeID));
            DataAccessAgent accessAgent = this.createDataAccessAgent(dataTypeID, usageContext, modificationCallback, accessAgentModificationAccess);
            this.accessAgents.put(dataTypeID, accessAgent);
        }
    }

    protected abstract String getModuleID();

    public abstract String getDisplayNameForData();

    public abstract Image getImageForData();

    protected abstract Collection<T_Datatype> getDataTypes();

    protected abstract IHasher_<? super T_Datatype> getDataTypeIDHasher();

    protected abstract String getDataTypeIDAsString(T_Datatype var1);

    protected abstract T_Datatype getDataTypeIDFromString(String var1);

    protected DataAccessAgent<T, T_UID, T_Datatype, T_EO> createDataAccessAgent(T_Datatype dataTypeID, String usageContext, DataAccessAgent.IModificationDiscardCallback<T, T_Datatype> modificationCallback, AccessAgentModificationAccess<T, T_UID, T_EO> accessAgentModificationAccess) {
        DataAccessAgent<T, T_UID, T_Datatype, T_EO> accessAgent = new DataAccessAgent<T, T_UID, T_Datatype, T_EO>();
        accessAgent.construct(dataTypeID, usageContext, this.dataHandler, modificationCallback, accessAgentModificationAccess);
        return accessAgent;
    }

    public abstract IDataLabelProvider2<T_Datatype> getDataLabelProvider2();

    protected abstract IDataHandler<T, T_UID, T_Datatype, T_EO> createDataHandler();

    protected abstract DataAccessAgent.IModificationDiscardCallback<T, T_Datatype> createModificationCallback();

    protected final String getProjectUID() {
        return this.projectUid;
    }

    public IProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    private <T_PC> void storePropertyChange(Object addedItem, Object modifiedItem, Object deletedItem, Class<T_PC> clazz, boolean isAsynchronousUpdate) {
        PropertyChanges<T_PC> changes = new PropertyChanges<T_PC>(clazz.cast(addedItem), clazz.cast(modifiedItem), clazz.cast(deletedItem), isAsynchronousUpdate);
        this.propertyChangesManager.signalPropertyChanges(changes, clazz);
    }

    private <T_PC> void storePropertyChange(Collection<?> addedItems, Collection<?> modifiedItems, Collection<?> deletedItems, Class<T_PC> clazz, boolean isAsynchronousUpdate) {
        ArrayList<T_PC> addedItems_ = new ArrayList<T_PC>();
        if (addedItems != null) {
            for (Object addedItem : addedItems) {
                addedItems_.add(clazz.cast(addedItem));
            }
        }
        ArrayList<T_PC> modifiedItems_ = new ArrayList<T_PC>();
        if (modifiedItems != null) {
            for (Object modifiedItem : modifiedItems) {
                modifiedItems_.add(clazz.cast(modifiedItem));
            }
        }
        ArrayList<T_PC> deletedItems_ = new ArrayList<T_PC>();
        if (deletedItems != null) {
            for (Object deletedItem : deletedItems) {
                deletedItems_.add(clazz.cast(deletedItem));
            }
        }
        PropertyChanges changes = new PropertyChanges(addedItems_, modifiedItems_, deletedItems_, isAsynchronousUpdate);
        this.propertyChangesManager.signalPropertyChanges(changes, clazz);
    }

    protected PropertyChangesManager getPropertyChangesManager() {
        return this.propertyChangesManager;
    }

    private boolean isInTransaction() {
        return this.projectAgent.getModelTransactionManager().isInTransaction();
    }

    public IModelTransactionManager getModelTransactionManager() {
        return this.projectAgent.getModelTransactionManager();
    }

    public T getItem(T_Datatype dataTypeUID, T_UID itemUID) {
        assert (dataTypeUID != null);
        assert (itemUID != null);
        DataAccessAgent accessAgent = (DataAccessAgent)this.accessAgents.getByKey(dataTypeUID);
        if (accessAgent != null) {
            return accessAgent.getItem(itemUID);
        }
        return null;
    }

    public Collection<T> getAllItems(T_Datatype dataTypeID) {
        assert (dataTypeID != null);
        return ((DataAccessAgent)this.accessAgents.getByKey(dataTypeID)).getAllItems();
    }

    public boolean itemExists(T_UID UID, T_Datatype dataTypeUID) {
        assert (UID != null) : "UID must not be null";
        assert (dataTypeUID != null) : "dataTypeUID must not be null";
        return this.getItem(dataTypeUID, UID) != null;
    }

    public boolean itemExistsOnServer(T_UID UID, T_Datatype dataTypeID) {
        assert (UID != null) : "UID must not be null";
        assert (dataTypeID != null) : "dataTypeID must not be null";
        DataAccessAgent accessAgent = (DataAccessAgent)this.accessAgents.getByKey(dataTypeID);
        return accessAgent != null && accessAgent.itemExistsOnServer(UID);
    }

    public boolean isNew(T_UID uid, T_Datatype dataTypeID) {
        assert (uid != null) : "uid must not be null";
        assert (dataTypeID != null) : "dataTypeID must not be null";
        DataAccessAgent accessAgent = (DataAccessAgent)this.accessAgents.getByKey(dataTypeID);
        return accessAgent != null && accessAgent.isNew(uid);
    }

    public boolean isModified(T_UID uid, T_Datatype dataTypeID) {
        assert (uid != null) : "uid must not be null";
        assert (dataTypeID != null) : "dataTypeID must not be null";
        DataAccessAgent accessAgent = (DataAccessAgent)this.accessAgents.getByKey(dataTypeID);
        return accessAgent != null && accessAgent.isUpdated(uid);
    }

    public boolean isDeleted(T_UID uid, T_Datatype dataTypeID) {
        assert (uid != null) : "uid must not be null";
        assert (dataTypeID != null) : "dataTypeID must not be null";
        DataAccessAgent accessAgent = (DataAccessAgent)this.accessAgents.getByKey(dataTypeID);
        return accessAgent != null && accessAgent.isRemoved(uid);
    }

    public final Collection<T> getLocallyAddedItems(T_Datatype dataTypeID) {
        return ((DataAccessAgent)this.accessAgents.getByKey(dataTypeID)).getAddedItems();
    }

    public final Collection<T> getLocallyUpdatedItems(T_Datatype dataTypeID) {
        return ((DataAccessAgent)this.accessAgents.getByKey(dataTypeID)).getUpdatedItems();
    }

    public final Collection<T> getLocallyRemovedItems(T_Datatype dataTypeID) {
        return ((DataAccessAgent)this.accessAgents.getByKey(dataTypeID)).getRemovedItems();
    }

    public void addItem(T item) {
        this.addItem(item, true);
    }

    public void addItem(T item, boolean setModificationData) {
        assert (item != null);
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - addItem", (Throwable)new Exception());
        }
        ((DataAccessAgent)this.accessAgents.getByKey(this.dataHandler.getDataTypeForItem(item))).addItem(item, setModificationData);
        this.saveChanges();
        this.setUncommitedChanges(true);
        this.storePropertyChange(item, null, null, item.getClass(), false);
    }

    public void itemPropertiesModified(T item) {
        this.itemPropertiesModified(item, true, new ArrayList());
    }

    public void itemPropertiesModified(final T[] items) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - itemPropertiesModified", (Throwable)new Exception());
        }
        this.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < items.length - 1) {
                    AbstractDataManager.this.itemPropertiesModified(items[i], false);
                    ++i;
                }
                AbstractDataManager.this.itemPropertiesModified(items[items.length - 1], true);
            }
        });
    }

    public void itemPropertiesModified(T item, boolean updateGUI) {
        this.itemPropertiesModified(item, updateGUI, new ArrayList());
    }

    protected final void itemPropertiesModified(T item, boolean updateGUI, List<T> visitedElements) {
        assert (item != null);
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - itemPropertiesModified", (Throwable)new Exception());
        }
        if (visitedElements != null) {
            visitedElements.add(item);
        }
        ((DataAccessAgent)this.accessAgents.getByKey(this.dataHandler.getDataTypeForItem(item))).modifyItem(item);
        this.saveChanges();
        this.setUncommitedChanges(true);
        this.callbackItemPropertiesModified(item, updateGUI);
        if (updateGUI) {
            this.storePropertyChange(null, item, null, item.getClass(), false);
        }
    }

    public T removeItem(T item) {
        T removedItem;
        assert (item != null);
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - removeItem", (Throwable)new Exception());
        }
        if ((removedItem = this.removeItem_internal(item)) != null) {
            this.storePropertyChange(null, null, item, item.getClass(), false);
        }
        return removedItem;
    }

    public void removeItems(Collection<? extends T> items) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - removeItems", (Throwable)new Exception());
        }
        HashMap_ removedItems = new HashMap_(this.getDataTypeIDHasher());
        for (T itemToRemove : items) {
            T removedItem = this.removeItem_internal(itemToRemove);
            if (removedItem == null) continue;
            this.addModuleDataItemToDataTypeMap((IMapRW_<T_Datatype, ArrayList<T>>)removedItems, removedItem);
        }
        for (IEntry_ typeEntry : removedItems.asJavaCollection()) {
            ArrayList itemCollection = (ArrayList)typeEntry.getValue();
            if (itemCollection.size() <= 0) continue;
            this.storePropertyChange(null, null, itemCollection, itemCollection.get(0).getClass(), false);
        }
    }

    private T removeItem_internal(T itemToRemove) {
        T removedItem = ((DataAccessAgent)this.accessAgents.getByKey(this.dataHandler.getDataTypeForItem(itemToRemove))).removeItem(itemToRemove);
        this.saveChanges();
        this.setUncommitedChanges(true);
        if (removedItem != null) {
            this.callbackItemRemoved(removedItem);
        }
        return removedItem;
    }

    private void addModuleDataItemToDataTypeMap(IMapRW_<T_Datatype, ArrayList<T>> map, T item) {
        T_Datatype dataType = this.dataHandler.getDataTypeForItem(item);
        if (map.containsKey(dataType)) {
            ((Collection)map.getByKey(dataType)).add(item);
        } else {
            ArrayList<T> newList = new ArrayList<T>();
            newList.add(item);
            map.put(dataType, newList);
        }
    }

    protected final void internallyRemoveItem(T item) {
        ((DataAccessAgent)this.accessAgents.getByKey(this.dataHandler.getDataTypeForItem(item))).removeItem(item);
    }

    public void initServerState(EOList<? extends T_EO>[] serverDataLists) {
        String userName = this.projectAgent.getUserData(true).getUser().getDisplayName();
        if (serverDataLists != null) {
            EOList<? extends T_EO>[] eOListArray = serverDataLists;
            int n = serverDataLists.length;
            int n2 = 0;
            while (n2 < n) {
                EOList<? extends T_EO> serverDataList = eOListArray[n2];
                DataAccessAgent accessAgent = (DataAccessAgent)this.accessAgents.getByKey(this.getDataTypeIDFromString(serverDataList.getRole()));
                if (accessAgent != null) {
                    Collection<T> serverStateItems = this.convertFromEO((Collection<? extends T_EO>)serverDataList);
                    accessAgent.initServerState(userName, serverStateItems);
                }
                ++n2;
            }
        }
    }

    public EOFrameDataModification<T_EO> getCreationAndModificationChangesForCommit() {
        EOList allAddedItems = new EOList();
        EOList allModifiedItems = new EOList();
        for (IEntry_ entry : this.accessAgents.asJavaCollection()) {
            Object dataTypeID = entry.getKey();
            DataAccessAgent accessAgent = (DataAccessAgent)entry.getValue();
            EOList<T_EO> addedItems = this.convertToEO(accessAgent.getAddedItems());
            EOList<T_EO> updatedItems = this.convertToEO(accessAgent.getUpdatedItems());
            this.callbackPrepareAddedAndUpdatedItemsForCommit(dataTypeID, Collections.unmodifiableList(addedItems), Collections.unmodifiableList(updatedItems));
            allAddedItems.addAll(addedItems);
            allModifiedItems.addAll(updatedItems);
        }
        EOFrameDataModification modificationContainer = new EOFrameDataModification(this.getModuleID(), allAddedItems, allModifiedItems, new EOList());
        return modificationContainer;
    }

    public EOFrameDataModification<T_EO> getDeletionChangesForCommit() {
        EOList allDeletedItems = new EOList();
        for (IEntry_ entry : this.accessAgents.asJavaCollection()) {
            DataAccessAgent accessAgent = (DataAccessAgent)entry.getValue();
            allDeletedItems.addAll(this.convertToEO(accessAgent.getRemovedItems()));
        }
        EOFrameDataModification modificationContainer = new EOFrameDataModification(this.getModuleID(), new EOList(), new EOList(), allDeletedItems);
        return modificationContainer;
    }

    public void handleCommitResponse(EOFrameDataModification<T_EO> modificationContainer) {
        EOList removedItems;
        EOList updatedItems;
        assert (modificationContainer != null) : "response is null";
        EOList addedItems = modificationContainer.getCreatedData();
        if (addedItems != null && !addedItems.isEmpty()) {
            this.handleCommitResponsePackage(addedItems, 1);
        }
        if ((updatedItems = modificationContainer.getModifiedData()) != null && !updatedItems.isEmpty()) {
            this.handleCommitResponsePackage(updatedItems, 2);
        }
        if ((removedItems = modificationContainer.getDeletedData()) != null && !removedItems.isEmpty()) {
            this.handleCommitResponsePackage(removedItems, 3);
        }
    }

    private void handleCommitResponsePackage(EOList<T_EO> commitResponsePackage, int packageType) {
        assert (packageType == 1 || packageType == 2 || packageType == 3);
        IMap_<T_Datatype, List<T>> responseItemsByType = this.getModificationDataByType(commitResponsePackage);
        for (IEntry_ entryForDataType : responseItemsByType.asJavaCollection()) {
            Object dataTypeID = entryForDataType.getKey();
            DataAccessAgent accessAgent = (DataAccessAgent)this.accessAgents.getByKey(dataTypeID);
            Collection responseItems = (Collection)entryForDataType.getValue();
            if (!responseItems.isEmpty()) {
                Collection failedItems = null;
                if (packageType == 1) {
                    failedItems = accessAgent.handleCommitOfAddedItems(responseItems);
                } else if (packageType == 2) {
                    failedItems = accessAgent.handleCommitOfUpdatedItems(responseItems);
                } else if (packageType == 3) {
                    failedItems = accessAgent.handleCommitOfRemovedItems(responseItems);
                }
                if (failedItems != null && !failedItems.isEmpty()) {
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append("ModuleLib.PersistencyAgent.handleResponse() - ");
                    errorMessage.append("ModuleLib.PersistencyAgent.handleResponse() - ");
                    errorMessage.append("Failed to commit ").append(failedItems.size()).append(" ");
                    if (packageType == 1) {
                        errorMessage.append("added items");
                    } else if (packageType == 2) {
                        errorMessage.append("updated items");
                    } else if (packageType == 3) {
                        errorMessage.append("removed items");
                    }
                    errorMessage.append(" of type: ").append(dataTypeID);
                    logger.error(errorMessage.toString());
                    responseItems.removeAll(failedItems);
                }
            }
            PropertyChanges<Collection> changes = new PropertyChanges<Collection>(packageType == 1 ? responseItems : null, packageType == 2 ? responseItems : null, packageType == 3 ? responseItems : null);
            this.propertyChangesManager.signalPropertyChanges(changes, this.dataHandler.getClassForDataTypeID(dataTypeID));
        }
    }

    public void finishCommit() {
        this.saveChanges();
        this.setUncommitedChanges(false);
        this.callbackCommitCompleted();
        this.storePropertyChange(null, this, null, this.getClass(), false);
    }

    protected abstract String getRequestGroupID();

    public void handleAsynchronousUpdate(EOFrameDataModification<T_EO> updatePackage) {
        EOList removedItems;
        EOList updatedItems;
        EOList addedItems;
        assert (updatePackage != null) : "response is null";
        if (!this.isAsynchronousUpdateRunning) {
            this.callbackAsynchronousUpdateStarted();
            this.isAsynchronousUpdateRunning = true;
        }
        if ((addedItems = updatePackage.getCreatedData()) != null && !addedItems.isEmpty()) {
            this.handleAsynchronousUpdatePackage(addedItems, 1);
        }
        if ((updatedItems = updatePackage.getModifiedData()) != null && !updatedItems.isEmpty()) {
            this.handleAsynchronousUpdatePackage(updatedItems, 2);
        }
        if ((removedItems = updatePackage.getDeletedData()) != null && !removedItems.isEmpty()) {
            this.handleAsynchronousUpdatePackage(removedItems, 3);
        }
    }

    private void handleAsynchronousUpdatePackage(EOList<T_EO> asynchronousUpdatePackage, int packageType) {
        assert (packageType == 1 || packageType == 2 || packageType == 3);
        IMap_<T_Datatype, List<T>> asynchronouslyUpdatedItemsByType = this.getModificationDataByType(asynchronousUpdatePackage);
        for (IEntry_ entryForDataType : asynchronouslyUpdatedItemsByType.asJavaCollection()) {
            PropertyChanges<Object> changes;
            Object dataTypeID = entryForDataType.getKey();
            DataAccessAgent accessAgent = (DataAccessAgent)this.accessAgents.getByKey(dataTypeID);
            Collection asynchronouslyUpdatedItems = (Collection)entryForDataType.getValue();
            if (!asynchronouslyUpdatedItems.isEmpty()) {
                if (packageType == 1) {
                    accessAgent.handleAsynchronousUpdateOfAddedItems(asynchronouslyUpdatedItems);
                } else if (packageType == 2) {
                    accessAgent.handleAsynchronousUpdateOfUpdatedItems(asynchronouslyUpdatedItems);
                } else if (packageType == 3) {
                    accessAgent.handleAsynchronousUpdateOfRemovedItems(asynchronouslyUpdatedItems);
                }
            }
            if (this.recentChanges == null) {
                this.recentChanges = new HashMap_(this.getDataTypeIDHasher());
            }
            if ((changes = (PropertyChanges)this.recentChanges.getByKey(dataTypeID)) == null) {
                changes = new PropertyChanges(true);
            }
            changes = new PropertyChanges(packageType == 1 ? asynchronouslyUpdatedItems : changes.getCreatedElements(), packageType == 2 ? asynchronouslyUpdatedItems : changes.getModifiedElements(), packageType == 3 ? asynchronouslyUpdatedItems : changes.getDeletedElements(), true);
            this.recentChanges.put(dataTypeID, changes);
        }
    }

    public void finishServerUpdate() {
        this.saveChanges();
        this.setUncommitedChanges(false);
        this.callbackAsynchronousUpdateCompleted();
        this.storePropertyChange(null, this, null, this.getClass(), true);
        if (this.recentChanges != null) {
            for (IEntry_ entry : this.recentChanges.asJavaCollection()) {
                Object dataTypeID = entry.getKey();
                PropertyChanges changes = (PropertyChanges)entry.getValue();
                this.propertyChangesManager.signalPropertyChanges(changes, this.dataHandler.getClassForDataTypeID(dataTypeID));
            }
        }
        this.recentChanges = null;
        this.isAsynchronousUpdateRunning = false;
    }

    private IMap_<T_Datatype, List<T>> getModificationDataByType(EOList<T_EO> modificationData) {
        HashMap_ map_typeID_items = new HashMap_(this.getDataTypeIDHasher());
        for (T item : this.convertFromEO((Collection<? extends T_EO>)modificationData)) {
            T_Datatype dataTypeID = this.dataHandler.getDataTypeForItem(item);
            ArrayList<T> listForDatatype = (ArrayList<T>)map_typeID_items.getByKey(dataTypeID);
            if (listForDatatype == null) {
                listForDatatype = new ArrayList<T>();
                map_typeID_items.put(dataTypeID, listForDatatype);
            }
            listForDatatype.add(item);
        }
        return map_typeID_items;
    }

    public void initLocalModifications() throws EXCorruptProjectData {
        boolean anyLocalModifications = false;
        for (DataAccessAgent accessAgent : this.accessAgents.values()) {
            accessAgent.initLocalModifications();
            if (!accessAgent.hasModifications()) continue;
            anyLocalModifications = true;
        }
        if (anyLocalModifications) {
            this.setUncommitedChanges(false);
        }
    }

    public void clearLocalModifications() {
        for (DataAccessAgent dataAccessAgent : this.accessAgents.values()) {
            dataAccessAgent.clearLocalModifications();
        }
        this.saveChanges();
        this.setUncommitedChanges(false);
    }

    @Deprecated
    private void saveChanges() {
        this.dataManagerModificationAccess.write();
    }

    private EOList<EOFrameDataModification<T_EO>> getLocalModifications() {
        EOList modificationContainers = new EOList();
        for (IEntry_ entry : this.accessAgents.asJavaCollection()) {
            Object dataTypeID = entry.getKey();
            String dataTypeIDAsString = this.getDataTypeIDAsString(dataTypeID);
            DataAccessAgent accessAgent = (DataAccessAgent)entry.getValue();
            EOList<T_EO> addedItemEOs = this.convertToEO(accessAgent.getAddedItems());
            EOList<T_EO> updatedItemEOs = this.convertToEO(accessAgent.getUpdatedItems());
            EOList<T_EO> removedItemEOs = this.convertToEO(accessAgent.getRemovedItems());
            EOFrameDataModification modificationContainer = new EOFrameDataModification(dataTypeIDAsString, addedItemEOs, updatedItemEOs, removedItemEOs);
            modificationContainers.add((EncodableObjectBase)modificationContainer);
        }
        return modificationContainers;
    }

    private EOList<T_EO> convertToEO(List<T> items) {
        EOList eoList = new EOList(items.size());
        for (T item : items) {
            eoList.add(this.dataHandler.getEOForItem(item));
        }
        return eoList;
    }

    private Collection<T> convertFromEO(Collection<? extends T_EO> eoItems) {
        ArrayList<T> itemlist = new ArrayList<T>(eoItems.size());
        for (EOGenericCockpitDatabaseData item : eoItems) {
            itemlist.add(this.dataHandler.getItemForEO(item));
        }
        return itemlist;
    }

    protected void setUncommitedChanges(boolean force) {
        boolean oldState = this.hasUncommitedChanges;
        if (!force) {
            this.hasUncommitedChanges = false;
            for (DataAccessAgent agent : this.accessAgents.values()) {
                if (!agent.hasModifications()) continue;
                this.hasUncommitedChanges = true;
                break;
            }
        } else {
            this.hasUncommitedChanges = true;
        }
        if (!oldState && this.hasUncommitedChanges || oldState && !this.hasUncommitedChanges) {
            this.projectAgent.fireCommitStateChange();
        }
    }

    public boolean hasUncommitedChanges() {
        return this.hasUncommitedChanges;
    }

    protected abstract void callbackItemPropertiesModified(T var1, boolean var2);

    protected abstract void callbackItemRemoved(T var1);

    protected abstract void callbackPrepareAddedAndUpdatedItemsForCommit(T_Datatype var1, List<T_EO> var2, List<T_EO> var3);

    protected abstract void callbackCommitCompleted();

    protected abstract void callbackAsynchronousUpdateStarted();

    protected abstract void callbackAsynchronousUpdateCompleted();
}

