/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.modelelementidtool.ui;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.modelelementidtool.model.ModelElementIDTool;
import com.arcway.cockpit.frame.modelelementidtool.ui.UpdateIDsDialog;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class UpdateModelElementIDsActionDelegate
implements IViewActionDelegate {
    private IViewPart viewPart = null;
    private String projectUID = null;
    private Collection<IUniqueElement> selectedUniqueElements = null;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        assert (this.viewPart != null);
        this.updateProjectUIDAndSelectedUniqueElements(selection);
        action.setEnabled(this.calculateEnabled());
    }

    private boolean calculateEnabled() {
        boolean enabled;
        if (this.projectUID != null) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
            if (projectAgent != null) {
                Collection<IAttributeType> idDisablerAttributeTypes = ModelElementIDTool.getIDDisablerAttributeTypes((IFrameProjectAgent)projectAgent);
                Collection<IAttributeType> idAttributeTypes = ModelElementIDTool.getIDAttributeTypes((IFrameProjectAgent)projectAgent);
                Collection<IAttributeType> combinedNameAttributeTypes = ModelElementIDTool.getCombinedNameAttributeTypes((IFrameProjectAgent)projectAgent);
                enabled = !idDisablerAttributeTypes.isEmpty() && !idAttributeTypes.isEmpty() && !combinedNameAttributeTypes.isEmpty() && !this.selectedUniqueElements.isEmpty();
            } else {
                enabled = false;
            }
        } else {
            enabled = false;
        }
        return enabled;
    }

    private void updateProjectUIDAndSelectedUniqueElements(ISelection selection) {
        HashSet<String> projectUIDs = new HashSet<String>();
        HashSet<IUniqueElement> currentlySelectedUniqueElements = new HashSet<IUniqueElement>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof IUniqueElement)) continue;
                IUniqueElement uniqueElement = (IUniqueElement)element;
                projectUIDs.add(uniqueElement.getProjectUID());
                currentlySelectedUniqueElements.add(uniqueElement);
            }
        }
        if (projectUIDs.size() == 1) {
            this.projectUID = (String)projectUIDs.iterator().next();
            this.selectedUniqueElements = currentlySelectedUniqueElements;
        } else {
            this.projectUID = null;
            this.selectedUniqueElements = null;
        }
    }

    public void run(IAction action) {
        ProjectAgent projectAgent;
        assert (this.viewPart != null);
        if (this.calculateEnabled() && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID)) != null) {
            Collection<IAttributeType> idDisablerAttributeTypes = ModelElementIDTool.getIDDisablerAttributeTypes((IFrameProjectAgent)projectAgent);
            Collection<IAttributeType> idAttributeTypes = ModelElementIDTool.getIDAttributeTypes((IFrameProjectAgent)projectAgent);
            Collection<IAttributeType> combinedNameAttributeTypes = ModelElementIDTool.getCombinedNameAttributeTypes((IFrameProjectAgent)projectAgent);
            Shell shell = this.viewPart.getViewSite().getShell();
            UpdateIDsDialog updateDialog = new UpdateIDsDialog(shell, this.selectedUniqueElements.size(), idDisablerAttributeTypes, idAttributeTypes, combinedNameAttributeTypes);
            updateDialog.setBlockOnOpen(true);
            if (updateDialog.open() == 0) {
                Collection<Object> problems;
                IAttributeType idDisablerAttributeType = updateDialog.getIDDisablerAttributeType();
                IAttributeType idAttributeType = updateDialog.getIDAttributeType();
                IAttributeType combinedNameAttributeType = updateDialog.getCombinedNameAttributeType();
                try {
                    projectAgent.getFrameServerProxy().refreshProject();
                    ModelElementIDTool idTool = new ModelElementIDTool((IFrameProjectAgent)projectAgent, idDisablerAttributeType, idAttributeType, combinedNameAttributeType, this.selectedUniqueElements);
                    problems = idTool.process();
                }
                catch (ServerNotAvailableException e) {
                    problems = Collections.singletonList(new ModificationProblem((Exception)((Object)e), ""));
                }
                catch (EXServerException e) {
                    problems = Collections.singletonList(new ModificationProblem((Exception)((Object)e), ""));
                }
                catch (LoginCanceledException e) {
                    problems = Collections.singletonList(new ModificationProblem((Exception)((Object)e), ""));
                }
                catch (UnknownServerException e) {
                    problems = Collections.singletonList(new ModificationProblem((Exception)((Object)e), ""));
                }
                ModificationProblemsDialog resultDialog = new ModificationProblemsDialog(problems, shell);
                resultDialog.setBlockOnOpen(true);
                resultDialog.open();
            }
        }
    }
}

