/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.modelelementidtool.model;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeBoolean;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementRW;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.frame.modelelementidtool.ui.Messages;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class ModelElementIDTool {
    private static final ILogger LOGGER = Logger.getLogger(ModelElementIDTool.class);
    private static final String ID_FORMAT = "0000";
    private final IFrameProjectAgent projectAgent;
    private final IAttributeType idDisablerAttributeType;
    private final IAttributeType idAttributeType;
    private final IAttributeType combinedNameAttributeType;
    private final Set<String> uniqueElementUIDsToProcess = new HashSet<String>();
    private final Set<IUniqueElement> notEnabledUniqueElementsWithIDs = new HashSet<IUniqueElement>();
    private final Set<IUniqueElement> uniqueElementsWithNoID = new HashSet<IUniqueElement>();
    private final Map<String, IUniqueElement> uniqueIDs2ModelElement = new HashMap<String, IUniqueElement>();
    private final Map<String, Collection<IUniqueElement>> duplicateIDs2ModelElements = new HashMap<String, Collection<IUniqueElement>>();
    private final Map<String, Integer> idPrefix2highestID = new HashMap<String, Integer>();

    public static Collection<IAttributeType> getIDDisablerAttributeTypes(IFrameProjectAgent projectAgent) {
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        for (IAttributeType attributeType : projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes("com.arcway.cockpit.uniqueelement")) {
            if (!attributeType.getDataType().getID().equals(DataTypeBoolean.getSingleInstance().getID())) continue;
            attributeTypes.add(attributeType);
        }
        return attributeTypes;
    }

    public static Collection<IAttributeType> getIDAttributeTypes(IFrameProjectAgent projectAgent) {
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        for (IAttributeType attributeType : projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes("com.arcway.cockpit.uniqueelement")) {
            if (!attributeType.getDataType().getID().equals("string")) continue;
            attributeTypes.add(attributeType);
        }
        return attributeTypes;
    }

    public static Collection<IAttributeType> getCombinedNameAttributeTypes(IFrameProjectAgent projectAgent) {
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        for (IAttributeType attributeType : projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes("com.arcway.cockpit.uniqueelement")) {
            if (!(attributeType.getDataType() instanceof DataTypeString)) continue;
            attributeTypes.add(attributeType);
        }
        return attributeTypes;
    }

    public ModelElementIDTool(IFrameProjectAgent projectAgent, IAttributeType idDisablerAttributeType, IAttributeType idAttributeType, IAttributeType combinedNameAttributeType, Collection<IUniqueElement> uniqueElements) {
        this.projectAgent = projectAgent;
        this.idDisablerAttributeType = idDisablerAttributeType;
        this.idAttributeType = idAttributeType;
        this.combinedNameAttributeType = combinedNameAttributeType;
        assert (idAttributeType.getDataType() instanceof DataTypeString);
        assert (combinedNameAttributeType.getDataType() instanceof DataTypeString);
        for (IUniqueElement uniqueElement : uniqueElements) {
            this.uniqueElementUIDsToProcess.add(uniqueElement.getUID());
        }
        for (IUniqueElement uniqueElement : projectAgent.getFrameUniqueElementMgr().getUniqueElements()) {
            this.add(uniqueElement);
        }
    }

    private void add(IUniqueElement uniqueElement) {
        String currentId = this.getID(uniqueElement);
        if (this.isEnabled(uniqueElement)) {
            String idPrefix = this.getIDPrefix(uniqueElement);
            int currentIdInt = this.parseID(idPrefix, currentId);
            if (currentId != null && currentId.length() > 0) {
                int highestIdInt = Math.max(this.getHighestIdInt(idPrefix), currentIdInt);
                this.idPrefix2highestID.put(idPrefix, highestIdInt);
                Collection<IUniqueElement> duplicateElements = this.duplicateIDs2ModelElements.get(currentId);
                if (duplicateElements == null) {
                    IUniqueElement duplicateElement = this.uniqueIDs2ModelElement.remove(currentId);
                    if (duplicateElement == null) {
                        this.uniqueIDs2ModelElement.put(currentId, uniqueElement);
                    } else {
                        duplicateElements = new ArrayList<IUniqueElement>();
                        duplicateElements.add(duplicateElement);
                        duplicateElements.add(uniqueElement);
                        this.duplicateIDs2ModelElements.put(currentId, duplicateElements);
                    }
                } else {
                    duplicateElements.add(uniqueElement);
                }
            } else {
                this.uniqueElementsWithNoID.add(uniqueElement);
            }
        } else if (currentId != null && currentId.length() > 0) {
            this.notEnabledUniqueElementsWithIDs.add(uniqueElement);
        }
    }

    public Collection<IModificationProblem> process() {
        final ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                problems.addAll(ModelElementIDTool.this.detectDuplicateIDs());
                problems.addAll(ModelElementIDTool.this.releaseIDs());
                problems.addAll(ModelElementIDTool.this.allocateIDs());
                problems.addAll(ModelElementIDTool.this.updateCombinedName());
            }
        });
        if (problems.isEmpty()) {
            problems.add((IModificationProblem)new ModificationProblem(Messages.getString("NothingDoneCause"), Messages.getString("NothingDoneConsequence"), 4));
        }
        return problems;
    }

    private Collection<IModificationProblem> detectDuplicateIDs() {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        for (Collection<IUniqueElement> modelElementsWithSameID : this.duplicateIDs2ModelElements.values()) {
            StringBuffer warningMessage = new StringBuffer();
            for (IUniqueElement uniqueElement : modelElementsWithSameID) {
                if (warningMessage.length() > 0) {
                    warningMessage.append(", ");
                }
                warningMessage.append('\"');
                warningMessage.append(this.calculateCombinedName(uniqueElement));
                warningMessage.append('\"');
            }
            problems.add((IModificationProblem)new ModificationProblem(Messages.getString("DuplicateIDCause"), NLS.bind((String)Messages.getString("DuplicateIDConsequence"), (Object)warningMessage.toString()), 3));
        }
        return problems;
    }

    private Collection<IModificationProblem> releaseIDs() {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        StringBuffer successMessage = new StringBuffer();
        for (IUniqueElement uniqueElement : this.notEnabledUniqueElementsWithIDs) {
            if (!this.uniqueElementUIDsToProcess.contains(uniqueElement.getUID())) continue;
            IUniqueElementRW uniqueElementRW = (IUniqueElementRW)uniqueElement;
            String id = "";
            Attribute idAttribute = new Attribute(this.idAttributeType.getAttributeTypeID(), (Object)id);
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            uniqueElementRW.requestAttributeModificationPermission((IAttribute)idAttribute, (ILocksAndPermissionsTransactionController)transactionController);
            Collection currentProblems = transactionController.execute();
            if (currentProblems.isEmpty()) {
                try {
                    uniqueElementRW.setAttribute((IAttribute)idAttribute);
                    if (successMessage.length() > 0) {
                        successMessage.append(", ");
                    }
                    successMessage.append('\"');
                    successMessage.append(this.calculateCombinedName(uniqueElement));
                    successMessage.append('\"');
                }
                catch (ExInvalidAttributeType e) {
                    LOGGER.error("Unexpected error while releasing unique element id.", (Throwable)e);
                }
                catch (ExInvalidDataType e) {
                    LOGGER.error("Unexpected error while releasing unique element id.", (Throwable)e);
                }
                catch (EXNoPermission e) {
                    LOGGER.error("Unexpected error while releasing unique element id.", (Throwable)e);
                }
                catch (EXNoLock e) {
                    LOGGER.error("Unexpected error while releasing unique element id.", (Throwable)e);
                }
                continue;
            }
            problems.addAll(currentProblems);
        }
        if (successMessage.length() > 0) {
            problems.add((IModificationProblem)new ModificationProblem(Messages.getString("IDReleasedCause"), NLS.bind((String)Messages.getString("IDReleasedConsequence"), (Object)successMessage.toString()), 4));
        }
        return problems;
    }

    private Collection<IModificationProblem> allocateIDs() {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        StringBuffer successMessage = new StringBuffer();
        for (IUniqueElement uniqueElement : this.uniqueElementsWithNoID) {
            if (!this.uniqueElementUIDsToProcess.contains(uniqueElement.getUID())) continue;
            IUniqueElementRW uniqueElementRW = (IUniqueElementRW)uniqueElement;
            String idPrefix = this.getIDPrefix(uniqueElement);
            int highestIdInt = this.getHighestIdInt(idPrefix);
            int idInt = highestIdInt + 1;
            String id = this.calculateID(idPrefix, idInt);
            Attribute idAttribute = new Attribute(this.idAttributeType.getAttributeTypeID(), (Object)id);
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            uniqueElementRW.requestAttributeModificationPermission((IAttribute)idAttribute, (ILocksAndPermissionsTransactionController)transactionController);
            Collection currentProblems = transactionController.execute();
            if (currentProblems.isEmpty()) {
                try {
                    uniqueElementRW.setAttribute((IAttribute)idAttribute);
                    this.idPrefix2highestID.put(idPrefix, idInt);
                    if (successMessage.length() > 0) {
                        successMessage.append(", ");
                    }
                    successMessage.append('\"');
                    successMessage.append(this.calculateCombinedName(uniqueElement));
                    successMessage.append('\"');
                }
                catch (ExInvalidAttributeType e) {
                    LOGGER.error("Unexpected error while allocating unique element id.", (Throwable)e);
                }
                catch (ExInvalidDataType e) {
                    LOGGER.error("Unexpected error while allocating unique element id.", (Throwable)e);
                }
                catch (EXNoPermission e) {
                    LOGGER.error("Unexpected error while allocating unique element id.", (Throwable)e);
                }
                catch (EXNoLock e) {
                    LOGGER.error("Unexpected error while allocating unique element id.", (Throwable)e);
                }
                continue;
            }
            problems.addAll(currentProblems);
        }
        if (successMessage.length() > 0) {
            problems.add((IModificationProblem)new ModificationProblem(Messages.getString("IDGeneratedCause"), NLS.bind((String)Messages.getString("IDGeneratedConsequence"), (Object)successMessage.toString()), 4));
        }
        return problems;
    }

    private Collection<IModificationProblem> updateCombinedName() {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        StringBuffer successMessage = new StringBuffer();
        for (IUniqueElement uniqueElement : this.projectAgent.getFrameUniqueElementMgr().getUniqueElements()) {
            String updatedCombinedName;
            if (!this.uniqueElementUIDsToProcess.contains(uniqueElement.getUID())) continue;
            IUniqueElementRW uniqueElementRW = (IUniqueElementRW)uniqueElement;
            String currentCombinedName = this.getCombinedName(uniqueElement);
            if (currentCombinedName == null) {
                currentCombinedName = "";
            }
            if ((updatedCombinedName = this.calculateCombinedName(uniqueElement)).equals(currentCombinedName)) continue;
            Attribute combinedNameAttribute = new Attribute(this.combinedNameAttributeType.getAttributeTypeID(), (Object)updatedCombinedName);
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            uniqueElementRW.requestAttributeModificationPermission((IAttribute)combinedNameAttribute, (ILocksAndPermissionsTransactionController)transactionController);
            Collection currentProblems = transactionController.execute();
            if (currentProblems.isEmpty()) {
                try {
                    uniqueElementRW.setAttribute((IAttribute)combinedNameAttribute);
                    if (successMessage.length() > 0) {
                        successMessage.append(", ");
                    }
                    successMessage.append('\"');
                    successMessage.append(this.calculateCombinedName(uniqueElement));
                    successMessage.append('\"');
                }
                catch (ExInvalidAttributeType e) {
                    LOGGER.error("Unexpected error while updating unique element's combined name.", (Throwable)e);
                }
                catch (ExInvalidDataType e) {
                    LOGGER.error("Unexpected error while updating unique element's combined name.", (Throwable)e);
                }
                catch (EXNoPermission e) {
                    LOGGER.error("Unexpected error while updating unique element's combined name.", (Throwable)e);
                }
                catch (EXNoLock e) {
                    LOGGER.error("Unexpected error while updating unique element's combined name.", (Throwable)e);
                }
                continue;
            }
            problems.addAll(currentProblems);
        }
        if (successMessage.length() > 0) {
            problems.add((IModificationProblem)new ModificationProblem(Messages.getString("CombinedNameUpdatedCause"), NLS.bind((String)Messages.getString("IDGeneratedConsequence"), (Object)successMessage.toString()), 4));
        }
        return problems;
    }

    private String calculateCombinedName(IUniqueElement uniqueElement) {
        String id = this.getID(uniqueElement);
        String name = this.getName(uniqueElement);
        String combinedName = id != null && id.length() > 0 && name != null && name.length() > 0 ? String.valueOf(id) + ' ' + name : (id != null && id.length() > 0 ? id : (name != null ? name : ""));
        return combinedName;
    }

    private String calculateID(String idPrefix, int idInt) {
        String idPart = idInt == 0 ? null : String.valueOf(idPrefix) + this.idNumberPart(idInt);
        return idPart;
    }

    private String idNumberPart(int idInt) {
        String idNumberPart = Integer.toString(idInt);
        int lenght = Math.max(ID_FORMAT.length(), idNumberPart.length());
        idNumberPart = ID_FORMAT + idNumberPart;
        idNumberPart = idNumberPart.substring(idNumberPart.length() - lenght);
        return idNumberPart;
    }

    private int parseID(String idPrefix, String id) {
        int idInt;
        if (id == null) {
            idInt = 0;
        } else if (id.trim().length() == 0) {
            idInt = 0;
        } else if (id.startsWith(idPrefix)) {
            int pos = idPrefix.length();
            String idNumberPart = id.substring(pos);
            try {
                idInt = Integer.parseInt(idNumberPart);
            }
            catch (NumberFormatException e) {
                idInt = 0;
            }
        } else {
            idInt = -1;
        }
        return idInt;
    }

    private boolean isEnabled(IUniqueElement uniqueElement) {
        IAttribute idAttribute = this.getIDDisablerAttribute(uniqueElement);
        Boolean isDisabled = idAttribute != null ? (Boolean)idAttribute.getAttributeValue() : null;
        return isDisabled == null || isDisabled == false;
    }

    private String getID(IUniqueElement uniqueElement) {
        IAttribute idAttribute = this.getIDAttribute(uniqueElement);
        String id = idAttribute != null ? ((String)idAttribute.getAttributeValue()).trim() : null;
        return id;
    }

    private String getName(IUniqueElement uniqueElement) {
        IAttribute idAttribute = this.getNameAttribute(uniqueElement);
        String name = idAttribute != null ? ((String)idAttribute.getAttributeValue()).trim() : null;
        return name;
    }

    private String getCombinedName(IUniqueElement uniqueElement) {
        IAttribute idAttribute = this.getCombinedNameAttribute(uniqueElement);
        String combinedName = idAttribute != null ? (String)idAttribute.getAttributeValue() : null;
        return combinedName;
    }

    private IAttribute getIDDisablerAttribute(IUniqueElement uniqueElement) {
        return this.getAttribute(uniqueElement, this.idDisablerAttributeType.getAttributeTypeID());
    }

    private IAttribute getIDAttribute(IUniqueElement uniqueElement) {
        return this.getAttribute(uniqueElement, this.idAttributeType.getAttributeTypeID());
    }

    private IAttribute getNameAttribute(IUniqueElement uniqueElement) {
        return this.getAttribute(uniqueElement, UniqueElementAttributeTypesProvider.ATTRID_DISPLAY_NAME);
    }

    private IAttribute getCombinedNameAttribute(IUniqueElement uniqueElement) {
        return this.getAttribute(uniqueElement, this.combinedNameAttributeType.getAttributeTypeID());
    }

    private IAttribute getAttribute(IUniqueElement uniqueElement, IAttributeTypeID attributeTypeID) {
        IAttribute attribute = uniqueElement.getAttribute(attributeTypeID);
        return attribute;
    }

    private String getIDPrefix(IUniqueElement uniqueElement) {
        IConstructionElementTypeDescription constructionElementTypeDescription;
        String modelElementTypeID = uniqueElement.getElementTypeID();
        try {
            constructionElementTypeDescription = ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(modelElementTypeID);
        }
        catch (EXConstructionElementTypeUnknown e) {
            constructionElementTypeDescription = IConstructionElementTypeDescription.UNKNOWN;
        }
        String language = this.projectAgent.getProject().getLanguage();
        Locale locale = language != null && language.length() > 0 ? new Locale(language) : Locale.ENGLISH;
        return constructionElementTypeDescription.getDefaultIDPrefix(locale).trim();
    }

    private int getHighestIdInt(String idPrefix) {
        Integer highestIDAsInteger = this.idPrefix2highestID.get(idPrefix);
        int highestIdInt = highestIDAsInteger != null ? highestIDAsInteger : 0;
        return highestIdInt;
    }
}

