/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import java.util.HashMap;

public final class StyleFamily {
    private static final HashMap<String, StyleFamily> knownStyleFamilies = new HashMap();
    public static final StyleFamily PARAGRAPH = new StyleFamily("paragraph");
    public static final StyleFamily TABLE = new StyleFamily("table");
    public static final StyleFamily TABLE_COLUMN = new StyleFamily("table-column");
    public static final StyleFamily TABLE_ROW = new StyleFamily("table-row");
    public static final StyleFamily TABLE_CELL = new StyleFamily("table-cell");
    private final String styleFamily;

    private StyleFamily(String styleFamily) {
        assert (styleFamily != null);
        assert (!knownStyleFamilies.containsKey(styleFamily));
        this.styleFamily = styleFamily;
        knownStyleFamilies.put(styleFamily, this);
    }

    public static StyleFamily getStyleFamily(String styleFamily) {
        StyleFamily result = knownStyleFamilies.get(styleFamily);
        if (result == null) {
            result = new StyleFamily(new String(styleFamily));
        }
        return result;
    }

    public String getOdfStyleFamilyName() {
        return this.styleFamily;
    }

    public int hashCode() {
        return this.styleFamily.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.styleFamily.equals(((StyleFamily)obj).styleFamily);
    }
}

