/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.dom.AnchorWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.IAnchorParent;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleFamily;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HeadingWrapper
implements IAnchorParent {
    private final Element heading;
    private final Document document;
    private final Locale projectLocale;
    private final StyleMap styleMap;

    public HeadingWrapper(Document document, Node parent, int outlinelevel, String style_displayname, StyleMap styleMap, Locale projectLocale) {
        String style_name;
        this.document = document;
        this.projectLocale = projectLocale;
        this.styleMap = styleMap;
        Element heading_ = document.createElement("text:h");
        this.heading = (Element)parent.appendChild(heading_);
        this.heading.setAttribute("text:outline-level", "" + outlinelevel);
        if (style_displayname != null && style_displayname.length() > 0 && (style_name = styleMap.findStyleByDisplayName(style_displayname, StyleFamily.PARAGRAPH)) != null) {
            this.heading.setAttribute("text:style-name", style_name);
        }
    }

    public void addText(String text) {
        Text t = this.document.createTextNode(text);
        this.heading.appendChild(t);
    }

    @Override
    public AnchorWrapper addAnchor(String anchorId, String anchorName) {
        return new AnchorWrapper(this.document, this.heading, anchorId, anchorName);
    }
}

