/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt;

import com.arcway.cockpit.docgen.writer.docbook.model.EOBook;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.odt.ModulePlugin;
import com.arcway.cockpit.docgen.writer.odt.util.XmlComponentUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ODFMetaDataManager {
    private final File odf__meta_xml;

    public ODFMetaDataManager(File odfRootDirectory) {
        this.odf__meta_xml = new File(odfRootDirectory, "meta.xml");
    }

    public void updateMetaInformation(EOBook docBook) throws ParserConfigurationException, SAXException, IOException {
        Element dcDateNode;
        Date currentDate = new Date(System.currentTimeMillis());
        Document odfManifestDocument = XmlComponentUtil.readComponentXmlFile(this.odf__meta_xml);
        NodeList officeMetaNodes = odfManifestDocument.getElementsByTagName("office:meta");
        assert (officeMetaNodes.getLength() == 1);
        Element officeMetaNode = (Element)officeMetaNodes.item(0);
        NodeList metadataNodes = officeMetaNode.getChildNodes();
        while (metadataNodes.getLength() > 0) {
            officeMetaNode.removeChild(metadataNodes.item(0));
        }
        Element newMetaGeneratorNode = this.getMetaGeneratorInfo(odfManifestDocument);
        NodeList metaGeneratorNodes = officeMetaNode.getElementsByTagName("meta:generator");
        if (metaGeneratorNodes.getLength() == 1) {
            Element metaGeneratorNode = (Element)metaGeneratorNodes.item(0);
            officeMetaNode.replaceChild(newMetaGeneratorNode, metaGeneratorNode);
        } else {
            officeMetaNode.appendChild(newMetaGeneratorNode);
        }
        Element newDcTitleNode = this.getDcTitleInfo(odfManifestDocument, docBook);
        NodeList dcTitleNodes = officeMetaNode.getElementsByTagName("dc:title");
        if (dcTitleNodes.getLength() == 1) {
            Element dcTitleNode = (Element)dcTitleNodes.item(0);
            officeMetaNode.replaceChild(newDcTitleNode, dcTitleNode);
        } else {
            officeMetaNode.appendChild(newDcTitleNode);
        }
        Element newDcSubjectNode = this.getDcSubjectInfo(odfManifestDocument, docBook);
        NodeList dcSubjectNodes = officeMetaNode.getElementsByTagName("dc:subject");
        if (dcSubjectNodes.getLength() == 1) {
            Element dcSubjectNode = (Element)dcSubjectNodes.item(0);
            officeMetaNode.replaceChild(newDcSubjectNode, dcSubjectNode);
        } else {
            officeMetaNode.appendChild(newDcSubjectNode);
        }
        Element newDcDateNode = this.getMetaCreationDateInfo(odfManifestDocument, currentDate);
        NodeList dcDateNodes = officeMetaNode.getElementsByTagName("meta:creation-date");
        if (dcDateNodes.getLength() == 1) {
            dcDateNode = (Element)dcDateNodes.item(0);
            officeMetaNode.replaceChild(newDcDateNode, dcDateNode);
        } else {
            officeMetaNode.appendChild(newDcDateNode);
        }
        newDcDateNode = this.getDcDateInfo(odfManifestDocument, currentDate);
        dcDateNodes = officeMetaNode.getElementsByTagName("dc:date");
        if (dcDateNodes.getLength() == 1) {
            dcDateNode = (Element)dcDateNodes.item(0);
            officeMetaNode.replaceChild(newDcDateNode, dcDateNode);
        } else {
            officeMetaNode.appendChild(newDcDateNode);
        }
        XmlComponentUtil.write(odfManifestDocument, this.odf__meta_xml);
    }

    private Element getMetaGeneratorInfo(Document odfManifestDocument) {
        Dictionary pluginHeaders = ModulePlugin.getDefault().getBundle().getHeaders();
        Object pluginVersionHeader = pluginHeaders.get("Bundle-Version");
        String pluginVersion = pluginVersionHeader != null ? pluginVersionHeader.toString() : "Vunknown";
        String osgiArch = Platform.getOSArch();
        String osgiOS = Platform.getOS();
        Element newMetaGeneratorNode = odfManifestDocument.createElement("meta:generator");
        Text generatorTextNode = odfManifestDocument.createTextNode("ARCWAY-Cockpit/" + pluginVersion + "$" + osgiOS + "$" + osgiArch);
        newMetaGeneratorNode.appendChild(generatorTextNode);
        return newMetaGeneratorNode;
    }

    private Element getDcTitleInfo(Document odfManifestDocument, EOBook docBook) {
        String titleString = "";
        EOTitle docTitle = docBook.getTitle();
        if (docTitle != null) {
            titleString = docTitle.getContentAsString();
        }
        Element newDcTitleNode = odfManifestDocument.createElement("dc:title");
        Text dcTitleTextNode = odfManifestDocument.createTextNode(titleString);
        newDcTitleNode.appendChild(dcTitleTextNode);
        return newDcTitleNode;
    }

    private Element getDcSubjectInfo(Document odfManifestDocument, EOBook docBook) {
        String subjectString = "";
        EOSubtitle docSubtitle = docBook.getSubtitle();
        if (docSubtitle != null) {
            subjectString = docSubtitle.getContentAsString();
        }
        Element newDcSubjectNode = odfManifestDocument.createElement("dc:subject");
        Text dcSubjectTextNode = odfManifestDocument.createTextNode(subjectString);
        newDcSubjectNode.appendChild(dcSubjectTextNode);
        return newDcSubjectNode;
    }

    private Element getMetaCreationDateInfo(Document odfManifestDocument, Date date) {
        Element newDcDateNode = odfManifestDocument.createElement("meta:creation-date");
        Text dcDateTextNode = odfManifestDocument.createTextNode(ODFMetaDataManager.getW3CDTF_Seconds_TimeString(date));
        newDcDateNode.appendChild(dcDateTextNode);
        return newDcDateNode;
    }

    private Element getDcDateInfo(Document odfManifestDocument, Date date) {
        Element newDcDateNode = odfManifestDocument.createElement("dc:date");
        Text dcDateTextNode = odfManifestDocument.createTextNode(ODFMetaDataManager.getW3CDTF_Seconds_TimeString(date));
        newDcDateNode.appendChild(dcDateTextNode);
        return newDcDateNode;
    }

    private static String getW3CDTF_Seconds_TimeString(Date date) {
        SimpleDateFormat W3CDTFormatWithSecondsAccuracyButWithoutTZDPart = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String w3CDTF_Minutes = W3CDTFormatWithSecondsAccuracyButWithoutTZDPart.format(date);
        return w3CDTF_Minutes;
    }
}

