/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.riverland_crmdocumentationmodule.xmladapter.importer;

import com.arcway.cockpit.genericmodule.client.gui.adapter.GenericModuleImportableData;
import com.arcway.cockpit.genericmodule.client.gui.adapter.IGenericModuleImportAdapter;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.riverland_crmdocumentationmodule.xmladapter.importer.ImportWizardContribution;
import com.arcway.cockpit.genericmodule.riverland_crmdocumentationmodule.xmladapter.importer.Messages;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportFailedException;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.AttributeAndEnumValueMappings;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.AttributeMappingPageContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportAdapter;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportableData;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataFactory;
import com.arcway.lib.codec.data.lib.generic.AbstractElementaryDataType;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsProject;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.RepositoryObjects;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.importexport.RepositorySnippetForImport;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLImporter
implements IGenericModuleImportAdapter {
    private static final String NAMESPACE = "rcrmd";
    private static final String NAMESPACE_PREFIX = "rcrmd:";
    private static final String TAG_NAME_OBJECTS = "rcrmd:Objects";
    private static final String TAG_NAME_PROPERIES = "rcrmd:Properties";
    private static final String ATTRIBUTE_NAME_PROPERTY_VALUESAMPLE = "valueSample";
    private static final String TAG_NAME_CHILDREN = "rcrmd:Children";
    private static final String TAG_NAME_RELATIONS = "rcrmd:Relations";
    private static final String ATTRIBUTE_NAME_CONTRIBUTION_OBJECTTYPE = "objectType";
    private static final String ATTRIBUTE_NAME_CONTRIBUTION_IDTYPE = "idType";
    private static final String ATTRIBUTE_VALUE_CONTRIBUTION_IDTYPE_COCKPITID = "cockpit-id";
    private static final String ATTRIBUTE_NAME_CONTRIBUTION_IDSAMPLE = "idSample";
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private ImportWizardContribution importWizardContribution;

    public void construct(String moduleID_, String objectTypeID) {
        this.moduleID = moduleID_;
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID_);
    }

    public IImportWizardContribution getWizardContribution() {
        if (this.importWizardContribution == null) {
            this.importWizardContribution = new ImportWizardContribution(this.moduleID, this.moduleSpecification);
        }
        return this.importWizardContribution;
    }

    public boolean isUsingAttributeMapping() {
        return false;
    }

    public List<AttributeMappingPageContribution> getAttributeMappingPageContributions(List<?> parameterList, Locale expectedLocale, IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        return null;
    }

    public IImportableData getImportableData(List<?> parameterList, List<AttributeAndEnumValueMappings> configuredAttributeMappings, Locale expectedLocale, IRepositoryInterfaceRO repositoryInterface, final IImportAdapter.ICockpitObjectIDGenerator idGenerator, final IProgressDisplay progressMonitor, Shell shell) throws ExportOrImportFailedException {
        GenericModuleImportableData dataToBeImported = new GenericModuleImportableData(true);
        final ObjectWrapper errorMessage = new ObjectWrapper(null);
        final ArrayList<String> warningMessages = new ArrayList<String>();
        final RepositorySnippetForImport repositorySnippet = new RepositorySnippetForImport();
        File xmlFile = new File((String)parameterList.get(0));
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            document = documentBuilder.parse(xmlFile);
        }
        catch (IOException ioE) {
            errorMessage.setWrappedObject((Object)("Error: IOException when parsing XML file: " + ioE.getMessage() + "\n"));
        }
        catch (SAXException sE) {
            errorMessage.setWrappedObject((Object)("Error: SAXException when parsing XML file: " + sE.getMessage() + "\n"));
        }
        catch (ParserConfigurationException pcE) {
            errorMessage.setWrappedObject((Object)("Error: ParserConfigurationException when parsing XML file: " + pcE.getMessage() + "\n"));
        }
        if (document != null) {
            progressMonitor.beginQuantifiedTask(Messages.getString("XMLImporter.TaskName"), 2, false);
            final String taskNameObjects = Messages.getString("XMLImporter.SubTaskName.Objects");
            progressMonitor.reportQuantifiedProgress(0, taskNameObjects);
            final List<Element> objectsElementList = XMLImporter.getChildrenByTag(document.getDocumentElement(), TAG_NAME_OBJECTS);
            if (objectsElementList.size() > 1) {
                warningMessages.add("More than one \"rcrmd:Objects\" node. Ignoring all but the first.");
            }
            if (!objectsElementList.isEmpty()) {
                RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                    public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                        XMLImporter.handleObjects(((Element)objectsElementList.get(0)).getChildNodes(), null, repositorySnapshot, idGenerator, repositorySnippet, (ObjectWrapper<String>)errorMessage, warningMessages, progressMonitor, taskNameObjects);
                    }
                });
            }
            if (errorMessage.getWrappedObject() == null) {
                final String taskNameRelations = Messages.getString("XMLImporter.SubTaskName.Relations");
                progressMonitor.reportQuantifiedProgress(1, taskNameRelations);
                final List<Element> relationsElementList = XMLImporter.getChildrenByTag(document.getDocumentElement(), TAG_NAME_RELATIONS);
                if (relationsElementList.size() > 1) {
                    warningMessages.add("More than one \"rcrmd:Relations\" node. Ignoring all but the first.");
                }
                if (!relationsElementList.isEmpty()) {
                    RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                        public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                            XMLImporter.handleRelations(((Element)relationsElementList.get(0)).getChildNodes(), repositorySnapshot, repositorySnippet, warningMessages, progressMonitor, taskNameRelations);
                        }
                    });
                }
            }
            progressMonitor.endTask();
        }
        boolean canImport = true;
        if (errorMessage.getWrappedObject() != null) {
            MessageDialog.openError((Shell)shell, (String)Messages.getString("ErrorDuringImport.Title"), (String)NLS.bind((String)Messages.getString("ErrorDuringImport.Message"), (Object)errorMessage.getWrappedObject()));
            canImport = false;
        } else if (!warningMessages.isEmpty()) {
            final StringBuilder warningMessagesText = new StringBuilder();
            for (String warningMessage : warningMessages) {
                warningMessagesText.append("- ").append(warningMessage).append("\n");
            }
            MessageDialog dialog = new MessageDialog(shell, Messages.getString("WarningsDuringImport.Title"), null, Messages.getString("WarningsDuringImport.Message"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

                protected void configureShell(Shell shell_) {
                    super.configureShell(shell_);
                    this.setShellStyle(this.getShellStyle() | 0x10000000);
                }

                protected Point getInitialSize() {
                    return new Point(400, 400);
                }

                protected Control createCustomArea(Composite parent) {
                    GridLayoutFactory.fillDefaults().applyTo(parent);
                    StyledText text = new StyledText(parent, 2890);
                    GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)text);
                    text.setText(warningMessagesText.toString());
                    return text;
                }
            };
            canImport = dialog.open() == 0;
        }
        dataToBeImported.canImport = canImport;
        if (canImport) {
            dataToBeImported.repositorySnippet = repositorySnippet;
        }
        return dataToBeImported;
    }

    public void abortImport() {
    }

    private static void handleObjects(NodeList childrenNodes, IRepositoryObjectReference parentReference, IRepositorySnapshotRO repositorySnapshot, IImportAdapter.ICockpitObjectIDGenerator idGenerator, RepositorySnippetForImport repositorySnippet, ObjectWrapper<String> errorMessage, List<String> warningMessages, IProgressDisplay progressMonitor, String taskName) throws EXNotReproducibleSnapshot {
        Object parentObjectTypeID = parentReference != null ? parentReference.getObjectTypeID() : COTIDsProject.OBJECT_TYPE_ID;
        IRepositoryObjectType parentObjectType = repositorySnapshot.getTypeManager().getObjectType((IRepositoryObjectTypeID)parentObjectTypeID);
        int objectCount = 0;
        int objectNodeIndex = 0;
        while (objectNodeIndex < childrenNodes.getLength()) {
            Node objectNode = childrenNodes.item(objectNodeIndex);
            if (objectNode instanceof Element) {
                Element objectElement = (Element)objectNode;
                ++objectCount;
                if (progressMonitor != null) {
                    progressMonitor.beginUnquantifiedTask(String.valueOf(taskName) + " (" + Messages.getString("XMLImporter.TaskName.Element") + " " + objectCount + ")", false);
                }
                final String objectTypeIDAsString = objectElement.getTagName().substring(NAMESPACE_PREFIX.length());
                IRepositoryObjectTypeID objectTypeID = new IRepositoryObjectTypeID(){

                    public String toCanonicalString() {
                        return objectTypeIDAsString;
                    }
                };
                IRepositoryObjectType objectType = repositorySnapshot.getTypeManager().findObjectType(objectTypeID);
                if (objectType != null && objectType.canBeInstanciated()) {
                    if (parentObjectType.findParentRelationContributionTypeOfChildObjectType(objectType) != null) {
                        IRepositoryData idSample;
                        HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
                        List<Element> propertiesElementList = XMLImporter.getChildrenByTag(objectElement, TAG_NAME_PROPERIES);
                        if (propertiesElementList.size() > 1) {
                            warningMessages.add("Warning: More than one \"rcrmd:Properties\" node. Ignoring all but the first one.");
                        }
                        if (!propertiesElementList.isEmpty()) {
                            NodeList propertyNodes = propertiesElementList.get(0).getChildNodes();
                            int propertyNodeIndex = 0;
                            while (propertyNodeIndex < propertyNodes.getLength()) {
                                Node propertyNode = propertyNodes.item(propertyNodeIndex);
                                if (propertyNode instanceof Element) {
                                    Element propertyElement = (Element)propertyNode;
                                    final String propertyTypeIDAsString = propertyElement.getTagName().substring(NAMESPACE_PREFIX.length());
                                    IRepositoryPropertyTypeID propertyTypeID = new IRepositoryPropertyTypeID(){

                                        public String toCanonicalString() {
                                            return propertyTypeIDAsString;
                                        }
                                    };
                                    IRepositoryPropertyType propertyType = RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)objectType, (IRepositoryPropertyTypeID)propertyTypeID);
                                    if (propertyType != null) {
                                        Tuple<IRepositoryData, String> dataAndErrorMessage = XMLImporter.createRepositoryDataFromSample(propertyType, propertyElement.getAttribute(ATTRIBUTE_NAME_PROPERTY_VALUESAMPLE));
                                        IRepositoryData data = null;
                                        if (dataAndErrorMessage.getT1() != null) {
                                            data = (IRepositoryData)dataAndErrorMessage.getT1();
                                        } else {
                                            warningMessages.add("Warning: Ignored property of type " + propertyTypeIDAsString + " for object of type " + objectTypeIDAsString + ", because " + (String)dataAndErrorMessage.getT2() + ".");
                                        }
                                        if (data != null) {
                                            propertySamples.put((Object)propertyTypeID, (Object)new RepositoryPropertySample(data));
                                        }
                                    } else {
                                        warningMessages.add("Warning: Ignored property of type " + propertyTypeIDAsString + " for object of type " + objectTypeIDAsString + ", because no such property type exists.");
                                    }
                                }
                                ++propertyNodeIndex;
                            }
                        }
                        IRepositoryObject existingObject = null;
                        IRepositoryPropertyTypeID idPropertyTypeID = RepositoryObjectTypes.findIDPropertyTypeID((IRepositoryObjectType)objectType);
                        if (idPropertyTypeID != null && (idSample = ((IRepositoryPropertySample)propertySamples.getByKey((Object)idPropertyTypeID)).getValue()) != null) {
                            existingObject = repositorySnapshot.findObjectByIDProperty(RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)objectType, (IRepositoryPropertyTypeID)idPropertyTypeID), idSample);
                        }
                        IRepositoryPropertySetSample objectID = existingObject != null ? RepositoryObjects.getObjectID(existingObject) : idGenerator.generateNewCockpitObjectUID();
                        propertySamples.put((Object)idGenerator.getCockpitObjectUIDPropertyTypeID(), (Object)((IRepositoryPropertySample)objectID.getPropertySamples().iterator().next()));
                        RepositoryObjectSample objectSample = new RepositoryObjectSample(objectTypeID, null, (IMap_)propertySamples);
                        RepositoryObjectSampleWithParentObjectReference objectSampleWithParentReference = new RepositoryObjectSampleWithParentObjectReference((IRepositoryObjectSample)objectSample, parentReference);
                        repositorySnippet.addExplicitObject(objectSampleWithParentReference);
                        List<Element> childObjectsElementList = XMLImporter.getChildrenByTag(objectElement, TAG_NAME_CHILDREN);
                        if (childObjectsElementList.size() > 1) {
                            warningMessages.add("Warning: More than one \"rcrmd:Children\" node. Ignoring all but the first one.");
                        }
                        if (!childObjectsElementList.isEmpty()) {
                            XMLImporter.handleObjects(childObjectsElementList.get(0).getChildNodes(), (IRepositoryObjectReference)new RepositoryObjectReference(objectTypeID, objectID), repositorySnapshot, idGenerator, repositorySnippet, errorMessage, warningMessages, null, null);
                        }
                    } else {
                        warningMessages.add("Warning: Ignored object of type " + objectTypeIDAsString + ", because it can not be a child of an object of type " + parentObjectType.getRepositoryObjectTypeID().toCanonicalString() + ".");
                    }
                } else if (objectType == null) {
                    warningMessages.add("Warning: Ignored object of unknown type: " + objectTypeIDAsString + ".");
                } else {
                    warningMessages.add("Warning: Ignored object of not instantiable type: " + objectTypeIDAsString + ".");
                }
            }
            ++objectNodeIndex;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void handleRelations(NodeList relationNodes, IRepositorySnapshotRO repositorySnapshot, RepositorySnippetForImport repositorySnippet, List<String> warningMessages, IProgressDisplay progressMonitor, String taskName) throws EXNotReproducibleSnapshot {
        createdContextObjects = new HashSet_(IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER);
        relationCount = 0;
        relationNodeIndex = 0;
        while (relationNodeIndex < relationNodes.getLength()) {
            block20: {
                block21: {
                    relationNode = relationNodes.item(relationNodeIndex);
                    if (!(relationNode instanceof Element)) break block20;
                    relationElement = (Element)relationNode;
                    progressMonitor.beginUnquantifiedTask(String.valueOf(taskName) + " (" + Messages.getString("XMLImporter.TaskName.Element") + " " + ++relationCount + ")", false);
                    relationTypeIDAsString = relationElement.getTagName().substring("rcrmd:".length());
                    relationTypeID = new IRepositoryRelationTypeID(){

                        public String toCanonicalString() {
                            return relationTypeIDAsString;
                        }
                    };
                    relationType = repositorySnapshot.getTypeManager().findCrossLinkRelationType(relationTypeID);
                    if (relationType == null || !relationType.canBeInstanciated()) break block21;
                    contributionMap = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
                    idSamples = new ArrayList<String>();
                    allRelationContributionTypes = relationType.getAllRelationContributionTypes();
                    requiredContributions = new HashMap_(allRelationContributionTypes.size(), IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
                    for (ICrossLinkRepositoryRelationContributionType contributionType : allRelationContributionTypes) {
                        requiredContributions.put((Object)contributionType.getRepositoryRelationContributionRoleID(), (Object)contributionType);
                    }
                    canImportRelation = true;
                    relationContributionNodes = relationNode.getChildNodes();
                    relationContributionNodeIndex = 0;
                    while (relationContributionNodeIndex < relationContributionNodes.getLength() && canImportRelation) {
                        block22: {
                            relationContributionNode = relationContributionNodes.item(relationContributionNodeIndex);
                            if (!(relationContributionNode instanceof Element)) break block22;
                            relationContributionElement = (Element)relationContributionNode;
                            relationContributionRoleIDAsString = relationContributionElement.getTagName().substring("rcrmd:".length());
                            relationContributionRoleID = new IRepositoryRelationContributionRoleID(){

                                public String toCanonicalString() {
                                    return relationContributionRoleIDAsString;
                                }
                            };
                            contributionType = (ICrossLinkRepositoryRelationContributionType)requiredContributions.removeAsValue((Object)relationContributionRoleID);
                            if (contributionType == null) ** GOTO lbl85
                            relatedObjectTypeIDAsString = relationContributionElement.getAttribute("objectType");
                            relatedObjectTypeID = new IRepositoryObjectTypeID(){

                                public String toCanonicalString() {
                                    return relatedObjectTypeIDAsString;
                                }
                            };
                            relatedObjectType = repositorySnapshot.getTypeManager().findObjectType(relatedObjectTypeID);
                            if (relatedObjectType == null || !relatedObjectType.canBeInstanciated()) ** GOTO lbl77
                            if (!contributionType.getRelatedObjectType().isSuperTypeOf(relatedObjectType)) ** GOTO lbl73
                            idSample = relationContributionElement.getAttribute("idSample");
                            idType = relationContributionElement.getAttribute("idType");
                            if (!idType.equals("cockpit-id")) ** GOTO lbl69
                            idPropertyTypeID = RepositoryObjectTypes.findIDPropertyTypeID((IRepositoryObjectType)relatedObjectType);
                            if (idPropertyTypeID == null) ** GOTO lbl65
                            idPropertyType = RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)relatedObjectType, (IRepositoryPropertyTypeID)idPropertyTypeID);
                            dataAndErrorMessage = XMLImporter.createRepositoryDataFromSample(idPropertyType, idSample);
                            if (dataAndErrorMessage.getT1() == null) ** GOTO lbl61
                            data = (IRepositoryData)dataAndErrorMessage.getT1();
                            relatedObject = repositorySnapshot.findObjectByIDProperty(idPropertyType, data);
                            if (relatedObject != null) {
                                objectID = RepositoryObjects.getObjectID((IRepositoryObject)relatedObject);
                                contributionMap.put((Object)relationContributionRoleID, (Object)objectID);
                                idSamples.add(String.valueOf(relationContributionRoleIDAsString) + ": " + idSample);
                                if (!createdContextObjects.contains((Object)objectID)) {
                                    repositorySnippet.addContextObject((IRepositoryObjectSample)new RepositoryObjectSample(relatedObjectTypeID, null, objectID));
                                    createdContextObjects.add((Object)objectID);
                                }
                            } else {
                                canImportRelation = false;
                                warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + ", because contribution with role: " + relationContributionRoleIDAsString + " identifies the related object by Cockpit ID, but an object with the given Cockpit ID does not exist: " + idSample + ".");
                                break;
lbl61:
                                // 1 sources

                                canImportRelation = false;
                                warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + ", because contribution with role: " + relationContributionRoleIDAsString + " identifies the related object by Cockpit ID, but the given Cockpit ID can not be parsed, because: " + (String)dataAndErrorMessage.getT2() + ".");
                                break;
lbl65:
                                // 1 sources

                                canImportRelation = false;
                                warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + ", because contribution with role: " + relationContributionRoleIDAsString + " identifies the related object by Cockpit ID, but the related object type does not have an id attribute.");
                                break;
lbl69:
                                // 1 sources

                                canImportRelation = false;
                                warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + ", because contribution with role: " + relationContributionRoleIDAsString + " does not specify a supported id type: " + idType + ".");
                                break;
lbl73:
                                // 1 sources

                                canImportRelation = false;
                                warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + ", because contribution with role: " + relationContributionRoleIDAsString + " references an object of invalid type: " + relatedObjectTypeIDAsString + ".");
                                break;
lbl77:
                                // 1 sources

                                canImportRelation = false;
                                if (relatedObjectType == null) {
                                    warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + ", because contribution with role: " + relationContributionRoleIDAsString + " references object of unknown type: " + relatedObjectTypeIDAsString + ".");
                                    break;
                                }
                                warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + ", because contribution with role: " + relationContributionRoleIDAsString + " references object of not instantiable type: " + relatedObjectTypeIDAsString + ".");
                                break;
lbl85:
                                // 1 sources

                                canImportRelation = false;
                                warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + " due to contribution with unknown role: " + relationContributionRoleIDAsString + ".");
                                break;
                            }
                        }
                        ++relationContributionNodeIndex;
                    }
                    if (canImportRelation) {
                        if (!requiredContributions.isEmpty()) {
                            canImportRelation = false;
                            warningMessages.add("Warning: Ignored relation of type: " + relationTypeIDAsString + " because the list of contributions is incomplete.");
                        } else {
                            relationSample = new CrossLinkRepositoryRelationSample(relationTypeID, (IMap_)contributionMap);
                            try {
                                existingRelationIterator = repositorySnapshot.findCrossLinkRelations(relationType, (IMap_)contributionMap);
                                relationExists = existingRelationIterator.hasNext();
                                if (relationExists) {
                                    existingRelationIterator.abortIteration();
                                }
                            }
                            catch (EXMissingCrossLinkTarget eMCLT) {
                                relationExists = false;
                            }
                            if (!relationExists) {
                                repositorySnippet.addCrossLinkRelation((ICrossLinkRepositoryRelationSample)relationSample);
                            } else {
                                objectIDsString = "";
                                first = true;
                                for (String objectIDString : idSamples) {
                                    if (first) {
                                        first = false;
                                    } else {
                                        objectIDsString = String.valueOf(objectIDsString) + "/ ";
                                    }
                                    objectIDsString = String.valueOf(objectIDsString) + objectIDString;
                                }
                                warningMessages.add("Warning: Ignored already existing relation of type: " + relationTypeIDAsString + " with contributions " + objectIDsString);
                            }
                        }
                    }
                    break block20;
                }
                if (relationType == null) {
                    warningMessages.add("Warning: Ignored relation of unknown type: " + relationTypeIDAsString + ".");
                } else {
                    warningMessages.add("Warning: Ignored relation of not instantiable type: " + relationTypeIDAsString + ".");
                }
            }
            ++relationNodeIndex;
        }
    }

    private static Tuple<IRepositoryData, String> createRepositoryDataFromSample(IRepositoryPropertyType propertyType, String sample) {
        IRepositoryData data = null;
        String errorMessage = null;
        IRepositoryDataType dataType = propertyType.getDataType();
        if (dataType instanceof RDTFile) {
            errorMessage = "file properties are not yet implemented";
        } else {
            IDataType deserialiser = dataType.getDataTypeOfRepositoryData(propertyType.getDataTypeParameters(), false);
            if (deserialiser instanceof AbstractElementaryDataType) {
                IElementaryDataFactory dataFactory = ((AbstractElementaryDataType)deserialiser).createDataFactory();
                dataFactory.setCharacters(sample);
                try {
                    data = (IRepositoryData)dataFactory.createDataElement();
                }
                catch (EXDataCreationFailed eDCF) {
                    errorMessage = "the value sample could not be parsed: " + sample;
                }
            } else {
                errorMessage = "no such property type exists";
            }
        }
        return new Tuple(data, (Object)errorMessage);
    }

    private static List<Element> getChildrenByTag(Element element, String tagName) {
        ArrayList<Element> children = new ArrayList<Element>(element.getChildNodes().getLength());
        int index = 0;
        while (index < element.getChildNodes().getLength()) {
            Node node = element.getChildNodes().item(index);
            if (node instanceof Element && ((Element)node).getTagName().equalsIgnoreCase(tagName)) {
                children.add((Element)node);
            }
            ++index;
        }
        return children;
    }
}

