/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDMessageRW;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAResizeMessage
implements IRAChangeGeometryFigure {
    private static final ILogger logger = Logger.getLogger(RAResizeMessage.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAResizeMessage createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(1);
        RAResizeMessage.addFixActions(figure, context, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private static void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW outlineFigure = null;
        if (!(figure.getPlanElementRW() instanceof IPMPlanElementBPMNBPDMessageRW)) {
            return;
        }
        if (!(figure instanceof IPMFigurePlaneRW)) {
            return;
        }
        outlineFigure = (IPMFigurePlaneRW)figure;
        if (!outlineFigure.getRole().equals("outline")) {
            return;
        }
        Rectangle bounds = outlineFigure.getPointListRW().getPoints().getBounds();
        IPMFigureLineShapeRW edgeFigure = ((IPMPlanElementBPMNBPDMessageRW)outlineFigure.getPlanElementRW()).getEdgeFigureRW();
        IPMPointListRW edgeFigurePoints = edgeFigure.getPointListRW();
        assert (edgeFigurePoints.getPointCount() == 3) : "edge figure should have exactly 3 points";
        ACMovePoint moveAction = new ACMovePoint(actionContext, edgeFigurePoints.getPointRW(0), new GeoVector(edgeFigurePoints.getPointRW(0).getPosition(), bounds.upperLeft), false);
        actions.addAction((Action)moveAction);
        moveAction = new ACMovePoint(actionContext, edgeFigurePoints.getPointRW(1), new GeoVector(edgeFigurePoints.getPointRW(1).getPosition(), bounds.center()), false);
        actions.addAction((Action)moveAction);
        moveAction = new ACMovePoint(actionContext, edgeFigurePoints.getPointRW(2), new GeoVector(edgeFigurePoints.getPointRW(2).getPosition(), new Point(bounds.lowerRight.x, bounds.upperLeft.y)), false);
        actions.addAction((Action)moveAction);
    }
}

