/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.actions.ACMoveLine;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDCommentRW;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAResizeComment
implements IRAChangeGeometryFigure {
    private static final ILogger logger = Logger.getLogger(RAResizeComment.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAResizeComment createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(1);
        RAResizeComment.addFixActions(figure, context, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private static void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW outlineFigure = null;
        if (!(figure.getPlanElementRW() instanceof IPMPlanElementBPMNBPDCommentRW)) {
            return;
        }
        if (!(figure instanceof IPMFigurePlaneRW)) {
            return;
        }
        outlineFigure = (IPMFigurePlaneRW)figure;
        if (!outlineFigure.getRole().equals("outline")) {
            return;
        }
        Rectangle bounds = outlineFigure.getPointListRW().getPoints().getBounds();
        IPMFigureLineShapeRW edgeFigure = ((IPMPlanElementBPMNBPDCommentRW)outlineFigure.getPlanElementRW()).getEdgeFigureRW();
        IPMPointListRW edgeFigurePoints = edgeFigure.getPointListRW();
        assert (edgeFigurePoints.getPointCount() == 4 && edgeFigurePoints.getLineCount() == 3) : "edge figure should have exactly 4 points and 3 lines";
        IPMPointListRW points = edgeFigure.getPointListRW();
        Point upperLeft = bounds.upperLeft;
        Point lowerLeft = new Point(upperLeft.x, bounds.lowerRight.y);
        double xDiff01 = points.getPointRW((int)0).getPosition().x - points.getPointRW((int)1).getPosition().x;
        double xDiff32 = points.getPointRW((int)3).getPosition().x - points.getPointRW((int)2).getPosition().x;
        actions.addAction((Action)new ACMoveLine(actionContext, points.getLineRW(1), new GeoVector(upperLeft.x - points.getPointRW((int)1).getPosition().x, 0.0), false));
        actions.addAction((Action)ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)points.getPointRW(0), (GeoVector)new GeoVector(points.getPointRW(0).getPosition(), new Point(upperLeft.x + xDiff01, upperLeft.y)), (boolean)false));
        actions.addAction((Action)ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)points.getPointRW(3), (GeoVector)new GeoVector(points.getPointRW(3).getPosition(), new Point(lowerLeft.x + xDiff32, lowerLeft.y)), (boolean)false));
    }
}

