/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.bpmn.bpd.edit;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planeditor.base.edit.IPEPlanElementWithCommentSupplement;
import com.arcway.planagent.planeditor.base.edit.PEPlanElementWithOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planeditor.base.inputinterpreter.EPEditNameOnPlanElement;
import com.arcway.planagent.planeditor.bpmn.bpd.edit.PEGraphicalSupplementEventTypeSymbol;
import com.arcway.planagent.planeditor.bpmn.bpd.handles.BPMNHandleTemplates;
import com.arcway.planagent.planeditor.cm.inputinterpreter.EPDeleteCommentTextOnSupplement;
import com.arcway.planagent.planeditor.cm.inputinterpreter.EPEditCommentTextOnSupplement;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.edit.PEPlanObject;
import com.arcway.planagent.planeditor.handles.HandleBar;
import com.arcway.planagent.planeditor.handles.HandlePointCreatePlanElementStructure;
import com.arcway.planagent.planeditor.handles.HandlePointDiagonal;
import com.arcway.planagent.planeditor.handles.IHandle;
import com.arcway.planagent.planeditor.handles.IHandleLine;
import com.arcway.planagent.planeditor.handles.IHandlePoint;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.appearance.TemplateApplicationTuple;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDEventRO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;

public class PEPlanElementBPMNBPDEvent
extends PEPlanElementWithOutlineAndNameAndDescriptionSupplement
implements IPEPlanElementWithCommentSupplement {
    private static final double DEFAULT_COMMENT_WIDTH = 30.0;

    protected void createEditPolicies() {
        super.createEditPolicies();
        switch (this.getPEPlan().getMode()) {
            case 1: {
                this.installEditPolicy("planelement_edit_role", (EditPolicy)new EPEditNameOnPlanElement());
                this.installEditPolicy("commentsupplement_edit_role", (EditPolicy)new EPEditCommentTextOnSupplement());
                this.installEditPolicy("DELETE_COMMENT_ROLE", (EditPolicy)new EPDeleteCommentTextOnSupplement());
                break;
            }
            case 3: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public PEFigure getEditFigure() {
        return this.getOutlineFigure();
    }

    public Points getDefaultCommentArea() {
        Rectangle bounds = this.getPMPlanElementFMCWithOutline().getOutlineFigureRO().getPointListRO().getPoints().getBounds();
        Point lowerRight = bounds.lowerRight;
        Point upperLeft = bounds.upperLeft;
        Point base = new Point(lowerRight.x + 15.0, upperLeft.y);
        Points geometry = new Points();
        geometry.add(new Point(base.x - 15.0, base.y));
        geometry.add(new Point(base.x + 15.0, base.y));
        geometry.add(new Point(base.x + 15.0, base.y + bounds.h()));
        geometry.add(new Point(base.x - 15.0, base.y + bounds.h()));
        return geometry;
    }

    public Points getDefaultNameSupplementTextArea() {
        return this.getDefaultCommentArea();
    }

    protected void addShortcutCreationHandles(List<IHandlePoint> pointHandles) {
        FeedbackManager feedbackManager = this.getFeedbackManager();
        EditMgr viewMgr = this.getPEPlan().getViewMgr();
        HandleBar handleBar = new HandleBar((PEPlanElement)this, 0);
        handleBar.addHandle(new HandlePointCreatePlanElementStructure((PEPlanElement)this, viewMgr, feedbackManager, BPMNHandleTemplates.EVENT, false));
        handleBar.addHandle(new HandlePointCreatePlanElementStructure((PEPlanElement)this, viewMgr, feedbackManager, BPMNHandleTemplates.ACTIVITY, false));
        handleBar.addHandle(new HandlePointCreatePlanElementStructure((PEPlanElement)this, viewMgr, feedbackManager, BPMNHandleTemplates.XOR, false));
        handleBar.addHandle(new HandlePointCreatePlanElementStructure((PEPlanElement)this, viewMgr, feedbackManager, BPMNHandleTemplates.AND, false));
        handleBar.addHandle(new HandlePointCreatePlanElementStructure((PEPlanElement)this, viewMgr, feedbackManager, BPMNHandleTemplates.OR, false));
        pointHandles.addAll(handleBar.calculatePositionedHandles());
    }

    public List<IHandleLine> getLineHandles() {
        return Collections.emptyList();
    }

    public List<IHandle> getPointHandlesFor(PEPlanObject child) {
        List handles = super.getPointHandlesFor(child);
        int i = 0;
        while (i < child.getPMPointList().getPointCount()) {
            HandlePointDiagonal handlePoint = new HandlePointDiagonal((EditPart)child, this.getPEPlan().getViewMgr(), this.getFeedbackManager(), child.getPMPointList().getPointRO(i), 1);
            handles.add(handlePoint);
            ++i;
        }
        return handles;
    }

    public Collection<TemplateApplicationTuple> getTemplateApplicationTuples() {
        Collection superTuples = super.getTemplateApplicationTuples();
        ArrayList<TemplateApplicationTuple> tuples = new ArrayList<TemplateApplicationTuple>();
        IPMFigurePlaneRO outline = ((IPMPlanElementBPMNBPDEventRO)this.getPMPlanElement()).getOutlineFigurePlaneRO();
        for (TemplateApplicationTuple singleTuple : superTuples) {
            if (singleTuple.getPlanObject() == outline && singleTuple.getAppearance() == outline.getLineAppearanceRO()) continue;
            tuples.add(singleTuple);
        }
        return tuples;
    }

    protected boolean isGraphicalSupplementSelectable(PEGraphicalSupplement graphicalSupplement) {
        if (graphicalSupplement instanceof PEGraphicalSupplementEventTypeSymbol) {
            return false;
        }
        return super.isGraphicalSupplementSelectable(graphicalSupplement);
    }

    public boolean isFigureSelectable(PEFigure figureToCheck) {
        boolean isCenterDot = ((IPMFigureRO)figureToCheck.getModel()).getRole().equals("centerdot");
        return !isCenterDot && super.isFigureSelectable(figureToCheck);
    }
}

