/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Arrays;
import sun.nio.fs.LinuxFileSystem;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.UnixConstants;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class LinuxFileStore
extends UnixFileStore {
    private volatile boolean xattrChecked;
    private volatile boolean xattrEnabled;

    LinuxFileStore(UnixPath unixPath) throws IOException {
        super(unixPath);
    }

    LinuxFileStore(UnixFileSystem unixFileSystem, UnixMountEntry unixMountEntry) throws IOException {
        super(unixFileSystem, unixMountEntry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        LinuxFileSystem linuxFileSystem = (LinuxFileSystem)this.file().getFileSystem();
        UnixPath unixPath = null;
        try {
            object4 = UnixNativeDispatcher.realpath(this.file());
            unixPath = new UnixPath((UnixFileSystem)linuxFileSystem, (byte[])object4);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this.file());
        }
        object4 = linuxFileSystem.getMountEntries("/proc/mounts");
        for (UnixPath unixPath2 = unixPath.getParent(); unixPath2 != null; unixPath2 = unixPath2.getParent()) {
            object3 = null;
            try {
                object3 = UnixFileAttributes.get(unixPath2, true);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(unixPath2);
            }
            if (((UnixFileAttributes)object3).dev() != this.dev()) {
                object2 = unixPath.asByteArray();
                object = object4.iterator();
                while (object.hasNext()) {
                    UnixMountEntry unixMountEntry = (UnixMountEntry)object.next();
                    if (!Arrays.equals((byte[])object2, unixMountEntry.dir())) continue;
                    return unixMountEntry;
                }
            }
            unixPath = unixPath2;
        }
        object3 = unixPath.asByteArray();
        object2 = object4.iterator();
        while (object2.hasNext()) {
            object = (UnixMountEntry)object2.next();
            if (!Arrays.equals((byte[])object3, ((UnixMountEntry)object).dir())) continue;
            return object;
        }
        throw new IOException("Mount point not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExtendedAttributesEnabled(UnixPath unixPath) {
        try {
            int n = unixPath.openForAttributeAccess(false);
            try {
                byte[] byArray = Util.toBytes("user.java");
                LinuxNativeDispatcher.fgetxattr(n, byArray, 0L, 0);
                boolean bl = true;
                return bl;
            }
            catch (UnixException unixException) {
                if (unixException.errno() != UnixConstants.ENODATA) return false;
                boolean bl2 = true;
                return bl2;
            }
            finally {
                UnixNativeDispatcher.close(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        if (clazz == DosFileAttributeView.class || clazz == UserDefinedFileAttributeView.class) {
            UnixFileStore.FeatureStatus featureStatus = this.checkIfFeaturePresent("user_xattr");
            if (featureStatus == UnixFileStore.FeatureStatus.PRESENT) {
                return true;
            }
            if (featureStatus == UnixFileStore.FeatureStatus.NOT_PRESENT) {
                return false;
            }
            if (this.entry().hasOption("user_xattr")) {
                return true;
            }
            if (this.entry().fstype().equals("ext3") || this.entry().fstype().equals("ext4")) {
                return false;
            }
            if (!this.xattrChecked) {
                UnixPath unixPath = new UnixPath(this.file().getFileSystem(), this.entry().dir());
                this.xattrEnabled = this.isExtendedAttributesEnabled(unixPath);
                this.xattrChecked = true;
            }
            return this.xattrEnabled;
        }
        if (clazz == PosixFileAttributeView.class && this.entry().fstype().equals("vfat")) {
            return false;
        }
        return super.supportsFileAttributeView(clazz);
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        if (string.equals("dos")) {
            return this.supportsFileAttributeView(DosFileAttributeView.class);
        }
        if (string.equals("user")) {
            return this.supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        return super.supportsFileAttributeView(string);
    }
}

