/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import com.arcway.lib.java.Assert;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOInteger;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.HashMap;
import java.util.Map;

public class EOVersionFileContent
extends EOEncodableObject {
    public static final String XML_NAME = "moduleversions";
    private static final String ROLE_FILETYPE = "file-type";
    private String fileType;
    private final Map<String, Integer> moduleVersions;

    public EOVersionFileContent(String fileType, Map<String, Integer> moduleVersions) {
        super(XML_NAME);
        Assert.checkArgumentBeeingNotNull(moduleVersions);
        Assert.checkArgumentBeeingNotNull(fileType);
        this.fileType = fileType;
        this.moduleVersions = new HashMap<String, Integer>(moduleVersions);
    }

    public EOVersionFileContent(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
        this.fileType = null;
        this.moduleVersions = new HashMap<String, Integer>();
    }

    public String getFileType() {
        return this.fileType;
    }

    public void clearVersions() {
        this.moduleVersions.clear();
    }

    public void putVersion(String key, Integer versionNr) {
        this.moduleVersions.put(key, versionNr);
    }

    public void putAllVersions(EOVersionFileContent versionInformation) {
        this.moduleVersions.putAll(versionInformation.moduleVersions);
    }

    public Integer getVersion(String key) {
        return this.moduleVersions.get(key);
    }

    public boolean isDataFormatOlderThanThis(EOVersionFileContent versionsFoundInData) {
        Map<String, Integer> programModuleVersions = this.moduleVersions;
        Map<String, Integer> dataModuleVersions = versionsFoundInData.moduleVersions;
        boolean isSupported = true;
        for (Map.Entry<String, Integer> dataModuleVersion : dataModuleVersions.entrySet()) {
            int currentProgramModuleVersionInt;
            String currentModuleID = dataModuleVersion.getKey();
            Integer currentDataModuleVersion = dataModuleVersion.getValue();
            Integer currentProgramModuleVersion = programModuleVersions.get(currentModuleID);
            if (currentProgramModuleVersion == null) {
                isSupported = false;
                continue;
            }
            int currentDataModuleVersionAsInt = currentDataModuleVersion;
            if (currentDataModuleVersionAsInt <= (currentProgramModuleVersionInt = currentProgramModuleVersion.intValue())) continue;
            isSupported = false;
        }
        return isSupported;
    }

    public boolean isDataFormatTheSameAsThis(EOVersionFileContent versionsFoundInData) {
        Map<String, Integer> programModuleVersions = this.moduleVersions;
        Map<String, Integer> dataModuleVersions = versionsFoundInData.moduleVersions;
        boolean isSupported = true;
        for (Map.Entry<String, Integer> dataModuleVersion : dataModuleVersions.entrySet()) {
            int currentProgramModuleVersionInt;
            String currentModuleID = dataModuleVersion.getKey();
            Integer currentDataModuleVersion = dataModuleVersion.getValue();
            Integer currentProgramModuleVersion = programModuleVersions.get(currentModuleID);
            if (currentProgramModuleVersion == null) {
                isSupported = false;
                continue;
            }
            int currentDataModuleVersionAsInt = currentDataModuleVersion;
            if (currentDataModuleVersionAsInt == (currentProgramModuleVersionInt = currentProgramModuleVersion.intValue())) continue;
            isSupported = false;
        }
        return isSupported;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
    }

    @Override
    protected boolean hasChildren() {
        return this.moduleVersions.size() > 0 || this.fileType != null;
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        return false;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.fileType != null) {
            EOString string = new EOString(this.fileType, ROLE_FILETYPE);
            string.writeXMLBody(writeContext, depth);
        }
        for (Map.Entry<String, Integer> entry : this.moduleVersions.entrySet()) {
            EOInteger integer = new EOInteger(entry.getValue(), entry.getKey());
            integer.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success;
        if (newChild instanceof EOInteger) {
            EOInteger eoInteger = (EOInteger)newChild;
            this.moduleVersions.put(eoInteger.getRole(), eoInteger.getInteger());
            success = true;
        } else if (newChild instanceof EOString) {
            EOString eoString = (EOString)newChild;
            if (ROLE_FILETYPE.equals(eoString.getRole())) {
                this.fileType = eoString.getString();
                success = true;
            } else {
                success = false;
            }
        } else {
            success = false;
        }
        return success;
    }
}

